/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.h2o.backends.internal;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.external.ExternalBackendConf$;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.expose.Utils$;
import org.apache.spark.h2o.backends.internal.CheckClusterSizeMsg$;
import org.apache.spark.h2o.backends.internal.FlatFileMsg;
import org.apache.spark.h2o.backends.internal.GetLeaderNodeMsg$;
import org.apache.spark.h2o.backends.internal.InternalBackendUtils;
import org.apache.spark.h2o.backends.internal.LockClusterMsg$;
import org.apache.spark.h2o.backends.internal.SpreadRDDBuilder;
import org.apache.spark.h2o.backends.internal.StartH2OWorkersMsg;
import org.apache.spark.h2o.backends.internal.StopEndpointMsg$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.RpcUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import water.H2O;
import water.H2OStarter;
import water.hive.DelegationTokenRefresher;
import water.util.Log;

public final class InternalH2OBackend$
implements InternalBackendUtils {
    public static InternalH2OBackend$ MODULE$;
    private final Seq<Tuple2<String, String>> UNSUPPORTED_SPARK_OPTIONS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new InternalH2OBackend$();
    }

    @Override
    public void checkUnsupportedSparkOptions(Seq<Tuple2<String, String>> unsupportedSparkOptions, H2OConf conf) {
        InternalBackendUtils.checkUnsupportedSparkOptions$(this, unsupportedSparkOptions, conf);
    }

    @Override
    public void setSelfAddressToH2ONode(Seq<String> h2oArgs) {
        InternalBackendUtils.setSelfAddressToH2ONode$(this, h2oArgs);
    }

    @Override
    public Seq<String> getH2OWorkerArgs(H2OConf conf) {
        return InternalBackendUtils.getH2OWorkerArgs$(this, conf);
    }

    @Override
    public Option<Object> guessTotalExecutorSize(SparkContext sc) {
        return InternalBackendUtils.guessTotalExecutorSize$(this, sc);
    }

    @Override
    public String getHostname(SparkEnv env) {
        return SharedBackendUtils.getHostname$(this, env);
    }

    @Override
    public void distributeFiles(H2OConf conf, SparkContext sc) {
        SharedBackendUtils.distributeFiles$(this, conf, sc);
    }

    @Override
    public Seq<String> getH2OSecurityArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OSecurityArgs$(this, conf);
    }

    @Override
    public Seq<String> getH2OCommonArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OCommonArgs$(this, conf);
    }

    @Override
    public Seq<String> getH2OWorkerAsClientArgs(H2OConf conf) {
        return SharedBackendUtils.getH2OWorkerAsClientArgs$(this, conf);
    }

    @Override
    public Seq<String> parseStringToHttpHeaderArgs(String headers) {
        return SharedBackendUtils.parseStringToHttpHeaderArgs$(this, headers);
    }

    @Override
    public Seq<String> getExtraHttpHeaderArgs(H2OConf conf) {
        return SharedBackendUtils.getExtraHttpHeaderArgs$(this, conf);
    }

    @Override
    public String[] toH2OArgs(Seq<String> h2oArgs, NodeDesc[] executors) {
        return SharedBackendUtils.toH2OArgs$(this, h2oArgs, executors);
    }

    @Override
    public NodeDesc[] toH2OArgs$default$2() {
        return SharedBackendUtils.toH2OArgs$default$2$(this);
    }

    @Override
    public File createTempDir() {
        return SharedBackendUtils.createTempDir$(this);
    }

    @Override
    public File saveFlatFileAsFile(String content) {
        return SharedBackendUtils.saveFlatFileAsFile$(this, content);
    }

    @Override
    public String translateHostnameToIp(String hostname) {
        return SharedBackendUtils.translateHostnameToIp$(this, hostname);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public NodeDesc org$apache$spark$h2o$backends$internal$InternalH2OBackend$$getLeaderNode(RpcEndpointRef[] endpoints, H2OConf conf) {
        RpcTimeout askTimeout = RpcUtils$.MODULE$.askRpcTimeout(conf.sparkConf());
        return (NodeDesc)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).flatMap((Function1 & Serializable & scala.Serializable)ref -> {
            Future future = ref.ask((Object)GetLeaderNodeMsg$.MODULE$, ClassTag$.MODULE$.apply(Option.class));
            return Option$.MODULE$.option2Iterable((Option)askTimeout.awaitResult(future));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NodeDesc.class))))).head();
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$waitForClusterSize(RpcEndpointRef[] endpoints, H2OConf conf, int expectedSize) {
        long start = System.currentTimeMillis();
        int timeout = conf.cloudTimeout();
        while (System.currentTimeMillis() - start < (long)timeout) {
            if (this.isClusterOfExpectedSize(endpoints, conf, expectedSize)) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$lockCloud(RpcEndpointRef[] endpoints) {
        ((RpcEndpointRef)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).head()).send((Object)LockClusterMsg$.MODULE$);
    }

    private boolean isClusterOfExpectedSize(RpcEndpointRef[] endpoints, H2OConf conf, int expectedSize) {
        RpcTimeout askTimeout = RpcUtils$.MODULE$.askRpcTimeout(conf.sparkConf());
        return !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).map((Function1 & Serializable & scala.Serializable)ref -> BoxesRunTime.boxToInteger((int)InternalH2OBackend$.$anonfun$isClusterOfExpectedSize$1(askTimeout, ref)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != expectedSize);
    }

    @Override
    public H2OConf checkAndUpdateConf(H2OConf conf) {
        Object object;
        SharedBackendUtils.checkAndUpdateConf$(this, conf);
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Increasing 'spark.locality.wait' to value 0 (Infinitive) as we need to ensure we run on the nodes with H2O");
        conf.set("spark.locality.wait", "0");
        conf.getOption("spark.executor.instances").foreach((Function1 & Serializable & scala.Serializable)v2 -> conf.set("spark.ext.h2o.cluster.size", (String)v2));
        if (!conf.contains("spark.scheduler.minRegisteredResourcesRatio") && !SparkSessionUtils$.MODULE$.active().sparkContext().isLocal()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The property 'spark.scheduler.minRegisteredResourcesRatio' is not specified!\nWe recommend to pass `--conf spark.scheduler.minRegisteredResourcesRatio=1`");
            object = conf.set("spark.scheduler.minRegisteredResourcesRatio", "1");
        } else {
            object = BoxedUnit.UNIT;
        }
        Object object2 = conf.cloudName().isEmpty() ? conf.setCloudName(new StringBuilder(17).append("sparkling-water-").append(System.getProperty("user.name", "cluster")).append("_").append(conf.sparkConf().getAppId()).toString()) : BoxedUnit.UNIT;
        Object object3 = conf.hdfsConf().isEmpty() ? conf.setHdfsConf(SparkContext$.MODULE$.getOrCreate().hadoopConfiguration()) : BoxedUnit.UNIT;
        this.checkUnsupportedSparkOptions(this.UNSUPPORTED_SPARK_OPTIONS(), conf);
        this.distributeFiles(conf, SparkSessionUtils$.MODULE$.active().sparkContext());
        return conf;
    }

    public Seq<Tuple2<String, String>> UNSUPPORTED_SPARK_OPTIONS() {
        return this.UNSUPPORTED_SPARK_OPTIONS;
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$startSingleH2OWorker(H2OConf conf) {
        Seq<String> args = this.getH2OWorkerAsClientArgs(conf);
        String[] launcherArgs = this.toH2OArgs(args, this.toH2OArgs$default$2());
        this.initializeH2OKerberizedHiveSupport(conf);
        if (conf.isDirectIpConfigurationEnabled()) {
            this.setSelfAddressToH2ONode((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])launcherArgs));
        }
        H2OStarter.start(launcherArgs, true);
        conf.set((String)ExternalBackendConf$.MODULE$.PROP_EXTERNAL_CLUSTER_REPRESENTATIVE()._1(), H2O.getIpPortString());
    }

    public NodeDesc startH2OWorker(H2OConf conf) {
        Seq<String> args = this.getH2OWorkerArgs(conf);
        String[] launcherArgs = this.toH2OArgs(args, this.toH2OArgs$default$2());
        this.initializeH2OKerberizedHiveSupport(conf);
        if (conf.isDirectIpConfigurationEnabled()) {
            this.setSelfAddressToH2ONode((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])launcherArgs));
        }
        H2OStarter.start(launcherArgs, true);
        return new NodeDesc(SparkEnv$.MODULE$.get().executorId(), H2O.SELF_ADDRESS.getHostAddress(), H2O.API_PORT);
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$registerNewExecutorListener(H2OContext hc) {
        block0: {
            if (hc.sparkContext().master().startsWith("local-cluster[") || !hc.getConf().isClusterTopologyListenerEnabled()) break block0;
            hc.sparkContext().addSparkListener((SparkListenerInterface)new SparkListener(){

                public void onExecutorAdded(SparkListenerExecutorAdded executorAdded) {
                    InternalH2OBackend$.MODULE$.log().warn("New spark executor joined the cloud, however it won't be used for the H2O computations.");
                }
            });
        }
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$tearDownEndpoints(RpcEndpointRef[] endpoints) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.send((Object)StopEndpointMsg$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    public RpcEndpointRef[] org$apache$spark$h2o$backends$internal$InternalH2OBackend$$registerEndpoints(H2OContext hc) {
        RpcEndpointRef[] endpoints = new SpreadRDDBuilder(hc, this.guessTotalExecutorSize(SparkSessionUtils$.MODULE$.active().sparkContext())).build();
        H2OConf conf = hc.getConf();
        RpcEndpointRef[] endpointsFinal = conf.numH2OWorkers().isDefined() && !conf.extraClusterNodes() ? (RpcEndpointRef[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).take(BoxesRunTime.unboxToInt((Object)conf.numH2OWorkers().get())) : endpoints;
        return (RpcEndpointRef[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpointsFinal)).map((Function1 & Serializable & scala.Serializable)ref -> SparkEnv$.MODULE$.get().rpcEnv().setupEndpointRef(ref.address(), ref.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RpcEndpointRef.class)));
    }

    public NodeDesc[] org$apache$spark$h2o$backends$internal$InternalH2OBackend$$startH2OWorkers(RpcEndpointRef[] endpoints, H2OConf conf) {
        RpcTimeout askTimeout = RpcUtils$.MODULE$.askRpcTimeout(conf.sparkConf());
        return (NodeDesc[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).map((Function1 & Serializable & scala.Serializable)ref -> {
            Future future = ref.ask((Object)new StartH2OWorkersMsg(conf), ClassTag$.MODULE$.apply(NodeDesc.class));
            NodeDesc node = (NodeDesc)askTimeout.awaitResult(future);
            Log.info(new StringBuilder(27).append("H2O's worker node ").append(node).append(" started.").toString());
            return node;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NodeDesc.class)));
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$distributeFlatFile(RpcEndpointRef[] endpoints, H2OConf conf, NodeDesc[] nodes) {
        Log.info(new StringBuilder(37).append("Distributing worker nodes locations: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).mkString(",")).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.send((Object)new FlatFileMsg(nodes, conf.internalPortOffset()));
            return BoxedUnit.UNIT;
        });
    }

    private void initializeH2OKerberizedHiveSupport(H2OConf conf) {
        block0: {
            if (!conf.isKerberizedHiveEnabled()) break block0;
            Configuration configuration = new Configuration();
            conf.hiveHost().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                configuration.set("h2o.hive.jdbc.host", x$4);
                return BoxedUnit.UNIT;
            });
            conf.hivePrincipal().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                configuration.set("h2o.hive.principal", x$5);
                return BoxedUnit.UNIT;
            });
            conf.hiveJdbcUrlPattern().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                configuration.set("h2o.hive.jdbc.urlPattern", x$6);
                return BoxedUnit.UNIT;
            });
            conf.hiveToken().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                configuration.set("h2o.hive.token", x$7);
                return BoxedUnit.UNIT;
            });
            File sparkTmpDir = new File(Utils$.MODULE$.getLocalDir(SparkEnv$.MODULE$.get().conf()));
            DelegationTokenRefresher.setup(configuration, sparkTmpDir.getAbsolutePath());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$isClusterOfExpectedSize$1(RpcTimeout askTimeout$2, RpcEndpointRef ref) {
        void var3_3;
        Future future = ref.ask((Object)CheckClusterSizeMsg$.MODULE$, ClassTag$.MODULE$.Int());
        int clusterSize = BoxesRunTime.unboxToInt((Object)askTimeout$2.awaitResult(future));
        return (int)var3_3;
    }

    private InternalH2OBackend$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        SharedBackendUtils.$init$(this);
        InternalBackendUtils.$init$(this);
        this.UNSUPPORTED_SPARK_OPTIONS = (Seq)new .colon.colon((Object)new Tuple2((Object)"spark.dynamicAllocation.enabled", (Object)"true"), (List)new .colon.colon((Object)new Tuple2((Object)"spark.speculation", (Object)"true"), (List)Nil$.MODULE$));
    }
}

