/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.CompRowMatrix;

class UnitLowerCompRowMatrix
extends AbstractMatrix {
    private int[] rowptr;
    private int[] colind;
    private double[] data;
    private int[] diagind;

    public UnitLowerCompRowMatrix(CompRowMatrix LU, int[] diagind) {
        super(LU);
        this.rowptr = LU.getRowPointers();
        this.colind = LU.getColumnIndices();
        this.data = LU.getData();
        this.diagind = diagind;
    }

    @Override
    public Vector solve(Vector b2, Vector x2) {
        if (!(b2 instanceof DenseVector) || !(x2 instanceof DenseVector)) {
            return super.solve(b2, x2);
        }
        double[] bd = ((DenseVector)b2).getData();
        double[] xd = ((DenseVector)x2).getData();
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            double sum = 0.0;
            for (int j2 = this.rowptr[i2]; j2 < this.diagind[i2]; ++j2) {
                sum += this.data[j2] * xd[this.colind[j2]];
            }
            xd[i2] = bd[i2] - sum;
        }
        return x2;
    }

    @Override
    public Vector transSolve(Vector b2, Vector x2) {
        if (!(x2 instanceof DenseVector)) {
            return super.transSolve(b2, x2);
        }
        x2.set(b2);
        double[] xd = ((DenseVector)x2).getData();
        for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
            for (int j2 = this.rowptr[i2]; j2 < this.diagind[i2]; ++j2) {
                int n2 = this.colind[j2];
                xd[n2] = xd[n2] - this.data[j2] * xd[i2];
            }
        }
        return x2;
    }
}

