/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.SparseVector;

public class ILUT
implements Preconditioner {
    private final FlexCompRowMatrix LU;
    private Matrix L;
    private Matrix U;
    private final Vector y;
    private final double tau;
    private final int[] diagind;
    private final List<IntDoubleEntry> lower;
    private final List<IntDoubleEntry> upper;
    private final int p;

    public ILUT(FlexCompRowMatrix LU, double tau, int p2) {
        if (!LU.isSquare()) {
            throw new IllegalArgumentException("ILU only applies to square matrices");
        }
        this.LU = LU;
        this.tau = tau;
        this.p = p2;
        int n2 = LU.numRows();
        this.lower = new ArrayList<IntDoubleEntry>(n2);
        this.upper = new ArrayList<IntDoubleEntry>(n2);
        this.y = new DenseVector(n2);
        this.diagind = new int[n2];
    }

    public ILUT(FlexCompRowMatrix LU) {
        this(LU, 1.0E-6, 25);
    }

    @Override
    public Vector apply(Vector b2, Vector x2) {
        this.L.solve(b2, this.y);
        return this.U.solve(this.y, x2);
    }

    @Override
    public Vector transApply(Vector b2, Vector x2) {
        this.U.transSolve(b2, this.y);
        return this.L.transSolve(this.y, x2);
    }

    @Override
    public void setMatrix(Matrix A2) {
        this.LU.set(A2);
        this.LU.compact();
        this.factor();
    }

    private void factor() {
        int n2 = this.LU.numRows();
        double[] LUi = new double[n2];
        for (int k2 = 0; k2 < n2; ++k2) {
            SparseVector row = this.LU.getRow(k2);
            this.diagind[k2] = this.findDiagonalIndex(row, k2);
            if (this.diagind[k2] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k2 + 1));
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            SparseVector rowi = this.LU.getRow(i2);
            double taui = rowi.norm(Vector.Norm.Two) * this.tau;
            this.scatter(rowi, LUi);
            for (int k3 = 0; k3 < i2; ++k3) {
                SparseVector rowk = this.LU.getRow(k3);
                int[] rowIndex = rowk.getIndex();
                int rowUsed = rowk.getUsed();
                double[] rowData = rowk.getData();
                if (rowData[this.diagind[k3]] == 0.0) {
                    throw new RuntimeException("Zero diagonal entry on row " + (k3 + 1) + " during ILU process");
                }
                double LUik = LUi[k3] / rowData[this.diagind[k3]];
                if (Math.abs(LUik) <= taui) continue;
                for (int j2 = this.diagind[k3] + 1; j2 < rowUsed; ++j2) {
                    int n3 = rowIndex[j2];
                    LUi[n3] = LUi[n3] - LUik * rowData[j2];
                }
                LUi[k3] = LUik;
            }
            this.gather(LUi, rowi, taui, i2);
            int diagIndex = this.diagind[i2];
            int[] rowiIndices = rowi.getIndex();
            if (diagIndex < rowiIndices.length && rowiIndices[diagIndex] == i2) continue;
            this.diagind[i2] = this.findDiagonalIndex(rowi, i2);
            if (this.diagind[i2] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (i2 + 1) + " during ILU process");
        }
        this.L = new UnitLowerFlexCompRowMatrix(this.LU, this.diagind);
        this.U = new UpperFlexCompRowMatrix(this.LU, this.diagind);
    }

    private int findDiagonalIndex(SparseVector v2, int k2) {
        return Arrays.binarySearch(v2.getIndex(), k2, 0, v2.getUsed());
    }

    private void scatter(SparseVector v2, double[] z2) {
        int[] index = v2.getIndex();
        int used = v2.getUsed();
        double[] data = v2.getData();
        java.util.Arrays.fill(z2, 0.0);
        for (int i2 = 0; i2 < used; ++i2) {
            z2[index[i2]] = data[i2];
        }
    }

    private void gather(double[] z2, SparseVector v2, double taui, int d2) {
        int i2;
        Object e22;
        int nl = 0;
        int nu = 0;
        for (Object e22 : v2) {
            if (e22.index() < d2) {
                ++nl;
                continue;
            }
            if (e22.index() <= d2) continue;
            ++nu;
        }
        v2.zero();
        this.lower.clear();
        for (i2 = 0; i2 < d2; ++i2) {
            if (!(Math.abs(z2[i2]) > taui)) continue;
            this.lower.add(new IntDoubleEntry(i2, z2[i2]));
        }
        this.upper.clear();
        for (i2 = d2 + 1; i2 < z2.length; ++i2) {
            if (!(Math.abs(z2[i2]) > taui)) continue;
            this.upper.add(new IntDoubleEntry(i2, z2[i2]));
        }
        Collections.sort(this.lower);
        Collections.sort(this.upper);
        v2.set(d2, z2[d2]);
        for (i2 = 0; i2 < Math.min(nl + this.p, this.lower.size()); ++i2) {
            e22 = this.lower.get(i2);
            v2.set(((IntDoubleEntry)e22).index, ((IntDoubleEntry)e22).value);
        }
        for (i2 = 0; i2 < Math.min(nu + this.p, this.upper.size()); ++i2) {
            e22 = this.upper.get(i2);
            v2.set(((IntDoubleEntry)e22).index, ((IntDoubleEntry)e22).value);
        }
    }

    private static class UpperFlexCompRowMatrix
    extends AbstractMatrix {
        private final FlexCompRowMatrix LU;
        private final int[] diagind;

        public UpperFlexCompRowMatrix(FlexCompRowMatrix LU, int[] diagind) {
            super(LU);
            this.LU = LU;
            this.diagind = diagind;
        }

        @Override
        public Vector solve(Vector b2, Vector x2) {
            if (!(b2 instanceof DenseVector) || !(x2 instanceof DenseVector)) {
                return super.solve(b2, x2);
            }
            double[] bd = ((DenseVector)b2).getData();
            double[] xd = ((DenseVector)x2).getData();
            for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
                SparseVector row = this.LU.getRow(i2);
                int[] index = row.getIndex();
                int used = row.getUsed();
                double[] data = row.getData();
                double sum = 0.0;
                for (int j2 = this.diagind[i2] + 1; j2 < used; ++j2) {
                    sum += data[j2] * xd[index[j2]];
                }
                xd[i2] = (bd[i2] - sum) / data[this.diagind[i2]];
            }
            return x2;
        }

        @Override
        public Vector transSolve(Vector b2, Vector x2) {
            if (!(x2 instanceof DenseVector)) {
                return super.transSolve(b2, x2);
            }
            x2.set(b2);
            double[] xd = ((DenseVector)x2).getData();
            for (int i2 = 0; i2 < this.numRows; ++i2) {
                SparseVector row = this.LU.getRow(i2);
                int[] index = row.getIndex();
                int used = row.getUsed();
                double[] data = row.getData();
                int n2 = i2;
                xd[n2] = xd[n2] / data[this.diagind[i2]];
                for (int j2 = this.diagind[i2] + 1; j2 < used; ++j2) {
                    int n3 = index[j2];
                    xd[n3] = xd[n3] - data[j2] * xd[i2];
                }
            }
            return x2;
        }
    }

    private static class UnitLowerFlexCompRowMatrix
    extends AbstractMatrix {
        private final FlexCompRowMatrix LU;
        private final int[] diagind;

        public UnitLowerFlexCompRowMatrix(FlexCompRowMatrix LU, int[] diagind) {
            super(LU);
            this.LU = LU;
            this.diagind = diagind;
        }

        @Override
        public Vector solve(Vector b2, Vector x2) {
            if (!(b2 instanceof DenseVector) || !(x2 instanceof DenseVector)) {
                return super.solve(b2, x2);
            }
            double[] bd = ((DenseVector)b2).getData();
            double[] xd = ((DenseVector)x2).getData();
            for (int i2 = 0; i2 < this.numRows; ++i2) {
                SparseVector row = this.LU.getRow(i2);
                int[] index = row.getIndex();
                double[] data = row.getData();
                double sum = 0.0;
                for (int j2 = 0; j2 < this.diagind[i2]; ++j2) {
                    sum += data[j2] * xd[index[j2]];
                }
                xd[i2] = bd[i2] - sum;
            }
            return x2;
        }

        @Override
        public Vector transSolve(Vector b2, Vector x2) {
            if (!(x2 instanceof DenseVector)) {
                return super.transSolve(b2, x2);
            }
            x2.set(b2);
            double[] xd = ((DenseVector)x2).getData();
            for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
                SparseVector row = this.LU.getRow(i2);
                int[] index = row.getIndex();
                double[] data = row.getData();
                for (int j2 = 0; j2 < this.diagind[i2]; ++j2) {
                    int n2 = index[j2];
                    xd[n2] = xd[n2] - data[j2] * xd[i2];
                }
            }
            return x2;
        }
    }

    private static class IntDoubleEntry
    implements Comparable<IntDoubleEntry> {
        public int index;
        public double value;

        public IntDoubleEntry(int index, double value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IntDoubleEntry o2) {
            if (Math.abs(this.value) < Math.abs(o2.value)) {
                return 1;
            }
            if (Math.abs(this.value) == Math.abs(o2.value)) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.index + "=" + this.value + ")";
        }
    }
}

