/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.sparse.Arrays;

public class CompRowMatrix
extends AbstractMatrix {
    double[] data;
    int[] columnIndex;
    int[] rowPointer;

    public CompRowMatrix(MatrixVectorReader r2) throws IOException {
        block13: {
            int i2;
            double[] entry;
            int[] column;
            int[] row;
            int numEntries;
            MatrixInfo info;
            block12: {
                int i3;
                super(0, 0);
                info = null;
                info = r2.hasInfo() ? r2.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = r2.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                numEntries = size.numEntries();
                row = new int[numEntries];
                column = new int[numEntries];
                entry = new double[numEntries];
                r2.readCoordinate(row, column, entry);
                r2.add(-1, row);
                r2.add(-1, column);
                ArrayList rnz = new ArrayList(this.numRows);
                for (i3 = 0; i3 < this.numRows; ++i3) {
                    rnz.add(new HashSet());
                }
                for (i3 = 0; i3 < numEntries; ++i3) {
                    ((Set)rnz.get(row[i3])).add(column[i3]);
                }
                if (info.isSymmetric() || info.isSkewSymmetric()) {
                    for (i3 = 0; i3 < numEntries; ++i3) {
                        if (row[i3] == column[i3]) continue;
                        ((Set)rnz.get(column[i3])).add(row[i3]);
                    }
                }
                int[][] nz = new int[this.numRows][];
                for (i2 = 0; i2 < this.numRows; ++i2) {
                    nz[i2] = new int[((Set)rnz.get(i2)).size()];
                    int j2 = 0;
                    for (Integer colind : (Set)rnz.get(i2)) {
                        nz[i2][j2++] = colind;
                    }
                }
                this.construct(nz);
                for (i2 = 0; i2 < size.numEntries(); ++i2) {
                    this.set(row[i2], column[i2], entry[i2]);
                }
                if (!info.isSymmetric()) break block12;
                for (i2 = 0; i2 < numEntries; ++i2) {
                    if (row[i2] == column[i2]) continue;
                    this.set(column[i2], row[i2], entry[i2]);
                }
                break block13;
            }
            if (!info.isSkewSymmetric()) break block13;
            for (i2 = 0; i2 < numEntries; ++i2) {
                if (row[i2] == column[i2]) continue;
                this.set(column[i2], row[i2], -entry[i2]);
            }
        }
    }

    public CompRowMatrix(int numRows, int numColumns, int[][] nz) {
        super(numRows, numColumns);
        this.construct(nz);
    }

    private void construct(int[][] nz) {
        int i2;
        int nnz = 0;
        for (i2 = 0; i2 < nz.length; ++i2) {
            nnz += nz[i2].length;
        }
        this.rowPointer = new int[this.numRows + 1];
        this.columnIndex = new int[nnz];
        this.data = new double[nnz];
        if (nz.length != this.numRows) {
            throw new IllegalArgumentException("nz.length != numRows");
        }
        for (i2 = 1; i2 <= this.numRows; ++i2) {
            this.rowPointer[i2] = this.rowPointer[i2 - 1] + nz[i2 - 1].length;
            int j2 = this.rowPointer[i2 - 1];
            int k2 = 0;
            while (j2 < this.rowPointer[i2]) {
                this.columnIndex[j2] = nz[i2 - 1][k2];
                if (nz[i2 - 1][k2] < 0 || nz[i2 - 1][k2] >= this.numColumns) {
                    throw new IllegalArgumentException("nz[" + (i2 - 1) + "][" + k2 + "]=" + nz[i2 - 1][k2] + ", which is not a valid column index");
                }
                ++j2;
                ++k2;
            }
            java.util.Arrays.sort(this.columnIndex, this.rowPointer[i2 - 1], this.rowPointer[i2]);
        }
    }

    private void construct(Matrix A2, boolean deep) {
        if (deep) {
            if (A2 instanceof CompRowMatrix) {
                CompRowMatrix Ac = (CompRowMatrix)A2;
                this.data = new double[Ac.data.length];
                this.columnIndex = new int[Ac.columnIndex.length];
                this.rowPointer = new int[Ac.rowPointer.length];
                System.arraycopy(Ac.data, 0, this.data, 0, this.data.length);
                System.arraycopy(Ac.columnIndex, 0, this.columnIndex, 0, this.columnIndex.length);
                System.arraycopy(Ac.rowPointer, 0, this.rowPointer, 0, this.rowPointer.length);
            } else {
                ArrayList rnz = new ArrayList(this.numRows);
                for (int i2 = 0; i2 < this.numRows; ++i2) {
                    rnz.add(new HashSet());
                }
                for (MatrixEntry e2 : A2) {
                    ((Set)rnz.get(e2.row())).add(e2.column());
                }
                int[][] nz = new int[this.numRows][];
                for (int i3 = 0; i3 < this.numRows; ++i3) {
                    nz[i3] = new int[((Set)rnz.get(i3)).size()];
                    int j2 = 0;
                    for (Integer colind : (Set)rnz.get(i3)) {
                        nz[i3][j2++] = colind;
                    }
                }
                this.construct(nz);
                this.set(A2);
            }
        } else {
            CompRowMatrix Ac = (CompRowMatrix)A2;
            this.columnIndex = Ac.getColumnIndices();
            this.rowPointer = Ac.getRowPointers();
            this.data = Ac.getData();
        }
    }

    public CompRowMatrix(Matrix A2, boolean deep) {
        super(A2);
        this.construct(A2, deep);
    }

    public CompRowMatrix(Matrix A2) {
        this(A2, true);
    }

    public int[] getColumnIndices() {
        return this.columnIndex;
    }

    public int[] getRowPointers() {
        return this.rowPointer;
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    public Matrix mult(Matrix B2, Matrix C2) {
        this.checkMultAdd(B2, C2);
        C2.zero();
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < C2.numColumns(); ++j2) {
                double dot = 0.0;
                for (int k2 = this.rowPointer[i2]; k2 < this.rowPointer[i2 + 1]; ++k2) {
                    dot += this.data[k2] * B2.get(this.columnIndex[k2], j2);
                }
                if (dot == 0.0) continue;
                C2.set(i2, j2, dot);
            }
        }
        return C2;
    }

    @Override
    public Vector mult(Vector x2, Vector y2) {
        this.checkMultAdd(x2, y2);
        y2.zero();
        if (x2 instanceof DenseVector) {
            double[] xd = ((DenseVector)x2).getData();
            for (int i2 = 0; i2 < this.numRows; ++i2) {
                double dot = 0.0;
                for (int j2 = this.rowPointer[i2]; j2 < this.rowPointer[i2 + 1]; ++j2) {
                    dot += this.data[j2] * xd[this.columnIndex[j2]];
                }
                if (dot == 0.0) continue;
                y2.set(i2, dot);
            }
            return y2;
        }
        for (int i3 = 0; i3 < this.numRows; ++i3) {
            double dot = 0.0;
            for (int j3 = this.rowPointer[i3]; j3 < this.rowPointer[i3 + 1]; ++j3) {
                dot += this.data[j3] * x2.get(this.columnIndex[j3]);
            }
            y2.set(i3, dot);
        }
        return y2;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        int i2 = 0;
        while (i2 < this.numRows) {
            double dot = 0.0;
            for (int j2 = this.rowPointer[i2]; j2 < this.rowPointer[i2 + 1]; ++j2) {
                dot += this.data[j2] * xd[this.columnIndex[j2]];
            }
            int n2 = i2++;
            yd[n2] = yd[n2] + alpha * dot;
        }
        return y2;
    }

    @Override
    public Vector transMult(Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.transMult(x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        y2.zero();
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = this.rowPointer[i2]; j2 < this.rowPointer[i2 + 1]; ++j2) {
                int n2 = this.columnIndex[j2];
                yd[n2] = yd[n2] + this.data[j2] * xd[i2];
            }
        }
        return y2;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.transMultAdd(alpha, x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        y2.scale(1.0 / alpha);
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = this.rowPointer[i2]; j2 < this.rowPointer[i2 + 1]; ++j2) {
                int n2 = this.columnIndex[j2];
                yd[n2] = yd[n2] + this.data[j2] * xd[i2];
            }
        }
        return y2.scale(alpha);
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        int index = this.getIndex(row, column);
        this.data[index] = value;
    }

    @Override
    public void add(int row, int column, double value) {
        int index;
        this.check(row, column);
        int n2 = index = this.getIndex(row, column);
        this.data[n2] = this.data[n2] + value;
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        int index = Arrays.binarySearch(this.columnIndex, column, this.rowPointer[row], this.rowPointer[row + 1]);
        if (index >= 0) {
            return this.data[index];
        }
        return 0.0;
    }

    private int getIndex(int row, int column) {
        int i2 = Arrays.binarySearch(this.columnIndex, column, this.rowPointer[row], this.rowPointer[row + 1]);
        if (i2 != -1 && this.columnIndex[i2] == column) {
            return i2;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (column + 1) + ") is not in the matrix structure");
    }

    @Override
    public CompRowMatrix copy() {
        return new CompRowMatrix(this);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new CompRowMatrixIterator();
    }

    @Override
    public CompRowMatrix zero() {
        java.util.Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public Matrix set(Matrix B2) {
        if (!(B2 instanceof CompRowMatrix)) {
            return super.set(B2);
        }
        this.checkSize(B2);
        CompRowMatrix Bc = (CompRowMatrix)B2;
        if (Bc.columnIndex.length != this.columnIndex.length || Bc.rowPointer.length != this.rowPointer.length) {
            this.data = new double[Bc.data.length];
            this.columnIndex = new int[Bc.columnIndex.length];
            this.rowPointer = new int[Bc.rowPointer.length];
        }
        System.arraycopy(Bc.data, 0, this.data, 0, this.data.length);
        System.arraycopy(Bc.columnIndex, 0, this.columnIndex, 0, this.columnIndex.length);
        System.arraycopy(Bc.rowPointer, 0, this.rowPointer, 0, this.rowPointer.length);
        return this;
    }

    private class CompRowMatrixEntry
    implements MatrixEntry {
        private int row;
        private int cursor;

        private CompRowMatrixEntry() {
        }

        public void update(int row, int cursor) {
            this.row = row;
            this.cursor = cursor;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return CompRowMatrix.this.columnIndex[this.cursor];
        }

        @Override
        public double get() {
            return CompRowMatrix.this.data[this.cursor];
        }

        @Override
        public void set(double value) {
            CompRowMatrix.this.data[this.cursor] = value;
        }
    }

    private class CompRowMatrixIterator
    implements Iterator<MatrixEntry> {
        private int row;
        private int cursor;
        private CompRowMatrixEntry entry;

        public CompRowMatrixIterator() {
            this.entry = new CompRowMatrixEntry();
            this.nextNonEmptyRow();
        }

        private void nextNonEmptyRow() {
            while (this.row < CompRowMatrix.this.numRows() && CompRowMatrix.this.rowPointer[this.row] == CompRowMatrix.this.rowPointer[this.row + 1]) {
                ++this.row;
            }
            this.cursor = CompRowMatrix.this.rowPointer[this.row];
        }

        @Override
        public boolean hasNext() {
            return this.cursor < CompRowMatrix.this.data.length;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.cursor);
            if (this.cursor < CompRowMatrix.this.rowPointer[this.row + 1] - 1) {
                ++this.cursor;
            } else {
                ++this.row;
                this.nextNonEmptyRow();
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

