/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.sparse.Arrays;

public class CompDiagMatrix
extends AbstractMatrix {
    double[][] diag;
    int[] ind;

    public CompDiagMatrix(MatrixVectorReader r2) throws IOException {
        block11: {
            int i2;
            double[] entry;
            int[] column;
            int[] row;
            MatrixSize size;
            MatrixInfo info;
            block10: {
                int i3;
                super(0, 0);
                info = null;
                info = r2.hasInfo() ? r2.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                size = r2.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                row = new int[size.numEntries()];
                column = new int[size.numEntries()];
                entry = new double[size.numEntries()];
                r2.readCoordinate(row, column, entry);
                r2.add(-1, row);
                r2.add(-1, column);
                TreeSet<Integer> diags = new TreeSet<Integer>();
                for (i3 = 0; i3 < size.numEntries(); ++i3) {
                    diags.add(this.getDiagonal(row[i3], column[i3]));
                }
                if (info.isSymmetric() || info.isSkewSymmetric()) {
                    for (i3 = 0; i3 < size.numEntries(); ++i3) {
                        if (row[i3] == column[i3]) continue;
                        diags.add(this.getDiagonal(column[i3], row[i3]));
                    }
                }
                int[] ind = new int[diags.size()];
                Integer[] ints = new Integer[diags.size()];
                diags.toArray(ints);
                for (int i4 = 0; i4 < diags.size(); ++i4) {
                    ind[i4] = ints[i4];
                }
                this.construct(ind);
                for (i2 = 0; i2 < size.numEntries(); ++i2) {
                    this.set(row[i2], column[i2], entry[i2]);
                }
                if (!info.isSymmetric()) break block10;
                for (i2 = 0; i2 < size.numEntries(); ++i2) {
                    if (row[i2] == column[i2]) continue;
                    this.set(column[i2], row[i2], entry[i2]);
                }
                break block11;
            }
            if (!info.isSkewSymmetric()) break block11;
            for (i2 = 0; i2 < size.numEntries(); ++i2) {
                if (row[i2] == column[i2]) continue;
                this.set(column[i2], row[i2], -entry[i2]);
            }
        }
    }

    public CompDiagMatrix(int numRows, int numColumns, int[] diagonal) {
        super(numRows, numColumns);
        this.construct(diagonal);
    }

    private void construct(int[] diagonal) {
        this.diag = new double[diagonal.length][];
        this.ind = new int[diagonal.length];
        int[] sortedDiagonal = new int[diagonal.length];
        System.arraycopy(diagonal, 0, sortedDiagonal, 0, diagonal.length);
        java.util.Arrays.sort(sortedDiagonal);
        for (int i2 = 0; i2 < diagonal.length; ++i2) {
            this.ind[i2] = sortedDiagonal[i2];
            this.diag[i2] = new double[this.getDiagSize(sortedDiagonal[i2])];
        }
    }

    public CompDiagMatrix(int numRows, int numColumns) {
        this(numRows, numColumns, new int[0]);
    }

    public CompDiagMatrix(Matrix A2, int[] diagonal, boolean deep) {
        super(A2);
        if (deep) {
            this.construct(diagonal);
            this.set(A2);
        } else {
            CompDiagMatrix Ac = (CompDiagMatrix)A2;
            this.diag = Ac.getDiagonals();
            this.ind = Ac.getIndex();
        }
    }

    public CompDiagMatrix(Matrix A2, int[] diagonal) {
        this(A2, diagonal, true);
    }

    public CompDiagMatrix(Matrix A2, boolean deep) {
        this(A2, new int[0], deep);
    }

    public CompDiagMatrix(Matrix A2) {
        this(A2, new int[0], true);
    }

    public double[][] getDiagonals() {
        return this.diag;
    }

    public int[] getIndex() {
        return this.ind;
    }

    @Override
    public void add(int row, int column, double value) {
        this.check(row, column);
        int diagonal = this.getCompDiagIndex(row, column);
        double[] dArray = this.diag[diagonal];
        int n2 = this.getOnDiagIndex(row, column);
        dArray[n2] = dArray[n2] + value;
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        int diagonal = java.util.Arrays.binarySearch(this.ind, this.getDiagonal(row, column));
        if (diagonal >= 0) {
            return this.diag[diagonal][this.getOnDiagIndex(row, column)];
        }
        return 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        int diagonal = this.getCompDiagIndex(row, column);
        this.diag[diagonal][this.getOnDiagIndex((int)row, (int)column)] = value;
    }

    private int getDiagonal(int row, int column) {
        return column - row;
    }

    private int getOnDiagIndex(int row, int column) {
        return row > column ? column : row;
    }

    private int getCompDiagIndex(int row, int column) {
        int i2;
        int diagonal = this.getDiagonal(row, column);
        int index = Arrays.binarySearchGreater(this.ind, diagonal);
        if (index < this.ind.length && this.ind[index] == diagonal) {
            return index;
        }
        int size = this.getDiagSize(diagonal);
        double[] newDiag = new double[size];
        double[][] newDiagArray = new double[this.diag.length + 1][];
        int[] newInd = new int[this.ind.length + 1];
        System.arraycopy(this.ind, 0, newInd, 0, index);
        System.arraycopy(this.ind, index, newInd, index + 1, this.ind.length - index);
        for (i2 = 0; i2 < index; ++i2) {
            newDiagArray[i2] = this.diag[i2];
        }
        for (i2 = index; i2 < this.diag.length; ++i2) {
            newDiagArray[i2 + 1] = this.diag[i2];
        }
        newInd[index] = diagonal;
        newDiagArray[index] = newDiag;
        this.ind = newInd;
        this.diag = newDiagArray;
        return index;
    }

    private int getDiagSize(int diagonal) {
        if (diagonal < 0) {
            return Math.min(this.numRows + diagonal, this.numColumns);
        }
        return Math.min(this.numRows, this.numColumns - diagonal);
    }

    @Override
    public Matrix copy() {
        return new CompDiagMatrix((Matrix)this, this.ind);
    }

    @Override
    public Matrix zero() {
        for (int i2 = 0; i2 < this.diag.length; ++i2) {
            java.util.Arrays.fill(this.diag[i2], 0.0);
        }
        return this;
    }

    @Override
    public Vector mult(Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.mult(x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        y2.zero();
        for (int i2 = 0; i2 < this.ind.length; ++i2) {
            int row = this.ind[i2] < 0 ? -this.ind[i2] : 0;
            int column = this.ind[i2] > 0 ? this.ind[i2] : 0;
            double[] locDiag = this.diag[i2];
            int j2 = 0;
            while (j2 < locDiag.length) {
                int n2 = row++;
                yd[n2] = yd[n2] + locDiag[j2] * xd[column];
                ++j2;
                ++column;
            }
        }
        return y2;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        for (int i2 = 0; i2 < this.ind.length; ++i2) {
            int row = this.ind[i2] < 0 ? -this.ind[i2] : 0;
            int column = this.ind[i2] > 0 ? this.ind[i2] : 0;
            double[] locDiag = this.diag[i2];
            int j2 = 0;
            while (j2 < locDiag.length) {
                int n2 = row++;
                yd[n2] = yd[n2] + alpha * locDiag[j2] * xd[column];
                ++j2;
                ++column;
            }
        }
        return y2;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.transMultAdd(alpha, x2, y2);
        }
        this.checkTransMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        for (int i2 = 0; i2 < this.ind.length; ++i2) {
            int row = this.ind[i2] < 0 ? -this.ind[i2] : 0;
            int column = this.ind[i2] > 0 ? this.ind[i2] : 0;
            double[] locDiag = this.diag[i2];
            int j2 = 0;
            while (j2 < locDiag.length) {
                int n2 = column++;
                yd[n2] = yd[n2] + alpha * locDiag[j2] * xd[row];
                ++j2;
                ++row;
            }
        }
        return y2;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new CompDiagMatrixIterator();
    }

    private class CompDiagMatrixEntry
    implements MatrixEntry {
        private int diagonal;
        private int index;

        private CompDiagMatrixEntry() {
        }

        public void update(int diagonal, int index) {
            this.diagonal = diagonal;
            this.index = index;
        }

        @Override
        public int row() {
            return this.index + (CompDiagMatrix.this.ind[this.diagonal] < 0 ? -CompDiagMatrix.this.ind[this.diagonal] : 0);
        }

        @Override
        public int column() {
            return this.index + (CompDiagMatrix.this.ind[this.diagonal] > 0 ? CompDiagMatrix.this.ind[this.diagonal] : 0);
        }

        @Override
        public double get() {
            return CompDiagMatrix.this.diag[this.diagonal][this.index];
        }

        @Override
        public void set(double value) {
            CompDiagMatrix.this.diag[this.diagonal][this.index] = value;
        }
    }

    private class CompDiagMatrixIterator
    implements Iterator<MatrixEntry> {
        private int diagonal;
        private int index;
        private CompDiagMatrixEntry entry;

        private CompDiagMatrixIterator() {
            this.entry = new CompDiagMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.diagonal < CompDiagMatrix.this.diag.length;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.diagonal, this.index);
            if (this.index < CompDiagMatrix.this.diag[this.diagonal].length - 1) {
                ++this.index;
            } else {
                ++this.diagonal;
                this.index = 0;
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

