/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolver;
import no.uib.cipr.matrix.sparse.Preconditioner;

public abstract class AbstractIterativeSolver
implements IterativeSolver {
    protected Preconditioner M = new IdentityPreconditioner();
    protected IterationMonitor iter = new DefaultIterationMonitor();

    @Override
    public void setPreconditioner(Preconditioner M2) {
        this.M = M2;
    }

    @Override
    public Preconditioner getPreconditioner() {
        return this.M;
    }

    @Override
    public IterationMonitor getIterationMonitor() {
        return this.iter;
    }

    @Override
    public void setIterationMonitor(IterationMonitor iter2) {
        this.iter = iter2;
    }

    protected void checkSizes(Matrix A2, Vector b2, Vector x2) {
        if (!A2.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        if (b2.size() != A2.numRows()) {
            throw new IllegalArgumentException("b.size() != A.numRows()");
        }
        if (b2.size() != x2.size()) {
            throw new IllegalArgumentException("b.size() != x.size()");
        }
    }

    private static class IdentityPreconditioner
    implements Preconditioner {
        private IdentityPreconditioner() {
        }

        @Override
        public Vector apply(Vector b2, Vector x2) {
            return x2.set(b2);
        }

        @Override
        public Vector transApply(Vector b2, Vector x2) {
            return x2.set(b2);
        }

        @Override
        public void setMatrix(Matrix A2) {
        }
    }
}

