/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompColMatrix;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.SSOR;

public class AMG
implements Preconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private CompRowMatrix[] A;
    private DenseLU lu;
    private DenseVector[] u;
    private DenseVector[] f;
    private DenseVector[] r;
    private CompColMatrix[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final double omegaPreF;
    private final double omegaPreR;
    private final double omegaPostF;
    private final double omegaPostR;
    private final boolean reverse;
    private final double omega;
    private boolean transpose;

    public AMG(double omegaPreF, double omegaPreR, double omegaPostF, double omegaPostR, int nu1, int nu2, int gamma, int min2, double omega) {
        this.omegaPreF = omegaPreF;
        this.omegaPreR = omegaPreR;
        this.omegaPostF = omegaPostF;
        this.omegaPostR = omegaPostR;
        this.reverse = true;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min2;
        this.omega = omega;
    }

    public AMG(double omegaPre, double omegaPost, int nu1, int nu2, int gamma, int min2, double omega) {
        this.omegaPreF = omegaPre;
        this.omegaPreR = omegaPre;
        this.omegaPostF = omegaPost;
        this.omegaPostR = omegaPost;
        this.reverse = false;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min2;
        this.omega = omega;
    }

    public AMG() {
        this(1.0, 1.85, 1.85, 1.0, 1, 1, 1, 40, 0.6666666666666666);
    }

    @Override
    public Vector apply(Vector b2, Vector x2) {
        this.u[0].set(x2);
        this.f[0].set(b2);
        this.transpose = false;
        this.cycle(0);
        return x2.set(this.u[0]);
    }

    @Override
    public Vector transApply(Vector b2, Vector x2) {
        this.u[0].set(x2);
        this.f[0].set(b2);
        this.transpose = true;
        this.cycle(0);
        return x2.set(this.u[0]);
    }

    @Override
    public void setMatrix(Matrix A2) {
        int k2;
        double eps;
        CompRowMatrix Af;
        Aggregator aggregator;
        LinkedList<CompRowMatrix> Al = new LinkedList<CompRowMatrix>();
        LinkedList<CompColMatrix> Il = new LinkedList<CompColMatrix>();
        Al.add(new CompRowMatrix(A2));
        int k3 = 0;
        while (((CompRowMatrix)Al.get(k3)).numRows() > this.min && (aggregator = new Aggregator(Af = (CompRowMatrix)Al.get(k3), eps = 0.08 * Math.pow(0.5, k3))).getAggregates().size() != 0) {
            Interpolator sa = new Interpolator(aggregator, Af, this.omega);
            Al.add(sa.getGalerkinOperator());
            Il.add(sa.getInterpolationOperator());
            ++k3;
        }
        this.m = Al.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new CompColMatrix[this.m - 1];
        this.A = new CompRowMatrix[this.m - 1];
        Il.toArray(this.I);
        for (int i2 = 0; i2 < Al.size() - 1; ++i2) {
            this.A[i2] = (CompRowMatrix)Al.get(i2);
        }
        DenseMatrix Ac = new DenseMatrix((Matrix)Al.get(Al.size() - 1));
        this.lu = new DenseLU(Ac.numRows(), Ac.numColumns());
        this.lu.factor(Ac);
        this.u = new DenseVector[this.m];
        this.f = new DenseVector[this.m];
        this.r = new DenseVector[this.m];
        for (k2 = 0; k2 < this.m; ++k2) {
            int n2 = ((CompRowMatrix)Al.get(k2)).numRows();
            this.u[k2] = new DenseVector(n2);
            this.f[k2] = new DenseVector(n2);
            this.r[k2] = new DenseVector(n2);
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        for (k2 = 0; k2 < this.m - 1; ++k2) {
            CompRowMatrix Ak = this.A[k2];
            this.preM[k2] = new SSOR(Ak, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[k2] = new SSOR(Ak, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[k2].setMatrix(Ak);
            this.postM[k2].setMatrix(Ak);
        }
    }

    private void cycle(int k2) {
        if (k2 == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(k2);
            this.u[k2 + 1].zero();
            this.A[k2].multAdd(-1.0, this.u[k2], this.r[k2].set(this.f[k2]));
            this.I[k2].transMult(this.r[k2], this.f[k2 + 1]);
            for (int i2 = 0; i2 < this.gamma; ++i2) {
                this.cycle(k2 + 1);
            }
            this.I[k2].multAdd(this.u[k2 + 1], this.u[k2]);
            this.postRelax(k2);
        }
    }

    private void directSolve() {
        int k2 = this.m - 1;
        this.u[k2].set(this.f[k2]);
        DenseMatrix U = new DenseMatrix(this.u[k2], false);
        if (this.transpose) {
            this.lu.transSolve(U);
        } else {
            this.lu.solve(U);
        }
    }

    private void preRelax(int k2) {
        for (int i2 = 0; i2 < this.nu1; ++i2) {
            if (this.transpose) {
                this.preM[k2].transApply(this.f[k2], this.u[k2]);
                continue;
            }
            this.preM[k2].apply(this.f[k2], this.u[k2]);
        }
    }

    private void postRelax(int k2) {
        for (int i2 = 0; i2 < this.nu2; ++i2) {
            if (this.transpose) {
                this.postM[k2].transApply(this.f[k2], this.u[k2]);
                continue;
            }
            this.postM[k2].apply(this.f[k2], this.u[k2]);
        }
    }

    private static class Interpolator {
        private CompRowMatrix Ac;
        private CompColMatrix I;

        public Interpolator(Aggregator aggregator, CompRowMatrix A2, double omega) {
            List<Set<Integer>> C2 = aggregator.getAggregates();
            List<Set<Integer>> N2 = aggregator.getNodeNeighborhoods();
            int[] diagind = aggregator.getDiagonalIndices();
            int[] pt = this.createTentativeProlongation(C2, A2.numRows());
            if (omega != 0.0) {
                List<Map<Integer, Double>> P2 = this.createSmoothedProlongation(C2, N2, A2, diagind, omega, pt);
                this.I = this.createInterpolationMatrix(P2, A2.numRows());
                this.Ac = this.createGalerkinSlow(this.I, A2);
            } else {
                this.Ac = this.createGalerkinFast(A2, pt, C2.size());
                this.I = this.createInterpolationMatrix(pt, C2.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> C2, int n2) {
            int[] pt = new int[n2];
            java.util.Arrays.fill(pt, -1);
            for (int i2 = 0; i2 < C2.size(); ++i2) {
                for (int j2 : C2.get(i2)) {
                    pt[j2] = i2;
                }
            }
            return pt;
        }

        private CompRowMatrix createGalerkinFast(CompRowMatrix A2, int[] pt, int c2) {
            int n2 = pt.length;
            FlexCompRowMatrix Ac = new FlexCompRowMatrix(c2, c2);
            int[] rowptr = A2.getRowPointers();
            int[] colind = A2.getColumnIndices();
            double[] data = A2.getData();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (pt[i2] == -1) continue;
                for (int j2 = rowptr[i2]; j2 < rowptr[i2 + 1]; ++j2) {
                    if (pt[colind[j2]] == -1) continue;
                    Ac.add(pt[i2], pt[colind[j2]], data[j2]);
                }
            }
            return new CompRowMatrix(Ac);
        }

        private CompColMatrix createInterpolationMatrix(List<Map<Integer, Double>> P2, int n2) {
            Map<Integer, Double> Pj;
            int j2;
            int c2 = P2.size();
            int[][] nz = new int[c2][];
            for (j2 = 0; j2 < c2; ++j2) {
                Pj = P2.get(j2);
                nz[j2] = new int[Pj.size()];
                int l2 = 0;
                for (int k2 : Pj.keySet()) {
                    nz[j2][l2++] = k2;
                }
            }
            this.I = new CompColMatrix(n2, c2, nz);
            for (j2 = 0; j2 < c2; ++j2) {
                Pj = P2.get(j2);
                for (Map.Entry<Integer, Double> e2 : Pj.entrySet()) {
                    this.I.set(e2.getKey(), j2, e2.getValue());
                }
            }
            return this.I;
        }

        private CompColMatrix createInterpolationMatrix(int[] pt, int c2) {
            FlexCompColMatrix If2 = new FlexCompColMatrix(pt.length, c2);
            for (int i2 = 0; i2 < pt.length; ++i2) {
                if (pt[i2] == -1) continue;
                If2.set(i2, pt[i2], 1.0);
            }
            return new CompColMatrix(If2);
        }

        public CompColMatrix getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Double>> createSmoothedProlongation(List<Set<Integer>> C2, List<Set<Integer>> N2, CompRowMatrix A2, int[] diagind, double omega, int[] pt) {
            int n2 = A2.numRows();
            int c2 = C2.size();
            ArrayList<Map<Integer, Double>> P2 = new ArrayList<Map<Integer, Double>>(c2);
            for (int i2 = 0; i2 < c2; ++i2) {
                P2.add(new HashMap());
            }
            int[] rowptr = A2.getRowPointers();
            int[] colind = A2.getColumnIndices();
            double[] data = A2.getData();
            double[] dot = new double[c2];
            for (int i3 = 0; i3 < n2; ++i3) {
                if (pt[i3] == -1) continue;
                java.util.Arrays.fill(dot, 0.0);
                Set<Integer> Ni = N2.get(i3);
                double weakAij = 0.0;
                for (int j2 = rowptr[i3]; j2 < rowptr[i3 + 1]; ++j2) {
                    if (pt[colind[j2]] == -1) continue;
                    double aij = data[j2];
                    if (aij != 0.0 && !Ni.contains(colind[j2])) {
                        weakAij += aij;
                        continue;
                    }
                    int n3 = pt[colind[j2]];
                    dot[n3] = dot[n3] + aij;
                }
                int n4 = pt[i3];
                dot[n4] = dot[n4] - weakAij;
                double scale = -omega / data[diagind[i3]];
                int j3 = 0;
                while (j3 < dot.length) {
                    int n5 = j3++;
                    dot[n5] = dot[n5] * scale;
                }
                int n6 = pt[i3];
                dot[n6] = dot[n6] + 1.0;
                for (j3 = 0; j3 < dot.length; ++j3) {
                    if (dot[j3] == 0.0) continue;
                    ((Map)P2.get(j3)).put(i3, dot[j3]);
                }
            }
            return P2;
        }

        private CompRowMatrix createGalerkinSlow(CompColMatrix I2, CompRowMatrix A2) {
            int n2 = I2.numRows();
            int c2 = I2.numColumns();
            FlexCompRowMatrix Ac = new FlexCompRowMatrix(c2, c2);
            double[] aiCol = new double[n2];
            double[] iCol = new double[n2];
            DenseVector aiV = new DenseVector(aiCol, false);
            DenseVector iV = new DenseVector(iCol, false);
            double[] itaiCol = new double[c2];
            DenseVector itaiV = new DenseVector(itaiCol, false);
            int[] colptr = I2.getColumnPointers();
            int[] rowind = I2.getRowIndices();
            double[] Idata = I2.getData();
            for (int k2 = 0; k2 < c2; ++k2) {
                int i2;
                iV.zero();
                for (i2 = colptr[k2]; i2 < colptr[k2 + 1]; ++i2) {
                    iCol[rowind[i2]] = Idata[i2];
                }
                A2.mult(iV, aiV);
                I2.transMult(aiV, itaiV);
                for (i2 = 0; i2 < c2; ++i2) {
                    if (itaiCol[i2] == 0.0) continue;
                    Ac.set(i2, k2, itaiCol[i2]);
                }
            }
            return new CompRowMatrix(Ac);
        }

        public CompRowMatrix getGalerkinOperator() {
            return this.Ac;
        }
    }

    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(CompRowMatrix A2, double eps) {
            this.diagind = this.findDiagonalIndices(A2);
            this.N = this.findNodeNeighborhood(A2, this.diagind, eps);
            boolean[] R = this.createInitialR(A2);
            this.C = this.createInitialAggregates(this.N, R);
            this.C = this.enlargeAggregates(this.C, this.N, R);
            this.C = this.createFinalAggregates(this.C, this.N, R);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalIndices() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalIndices(CompRowMatrix A2) {
            int[] rowptr = A2.getRowPointers();
            int[] colind = A2.getColumnIndices();
            int[] diagind = new int[A2.numRows()];
            for (int i2 = 0; i2 < A2.numRows(); ++i2) {
                diagind[i2] = Arrays.binarySearch(colind, i2, rowptr[i2], rowptr[i2 + 1]);
                if (diagind[i2] >= 0) continue;
                throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i2 + 1));
            }
            return diagind;
        }

        private List<Set<Integer>> findNodeNeighborhood(CompRowMatrix A2, int[] diagind, double eps) {
            this.N = new ArrayList<Set<Integer>>(A2.numRows());
            int[] rowptr = A2.getRowPointers();
            int[] colind = A2.getColumnIndices();
            double[] data = A2.getData();
            for (int i2 = 0; i2 < A2.numRows(); ++i2) {
                HashSet<Integer> Ni = new HashSet<Integer>();
                double aii = data[diagind[i2]];
                for (int j2 = rowptr[i2]; j2 < rowptr[i2 + 1]; ++j2) {
                    double aij = data[j2];
                    double ajj = data[diagind[colind[j2]]];
                    if (!(Math.abs(aij) >= eps * Math.sqrt(aii * ajj))) continue;
                    Ni.add(colind[j2]);
                }
                this.N.add(Ni);
            }
            return this.N;
        }

        private boolean[] createInitialR(CompRowMatrix A2) {
            boolean[] R = new boolean[A2.numRows()];
            int[] rowptr = A2.getRowPointers();
            int[] colind = A2.getColumnIndices();
            double[] data = A2.getData();
            for (int i2 = 0; i2 < A2.numRows(); ++i2) {
                boolean hasOffDiagonal = false;
                for (int j2 = rowptr[i2]; j2 < rowptr[i2 + 1]; ++j2) {
                    if (colind[j2] == i2 || data[j2] == 0.0) continue;
                    hasOffDiagonal = true;
                    break;
                }
                R[i2] = hasOffDiagonal;
            }
            return R;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> N2, boolean[] R) {
            this.C = new ArrayList<Set<Integer>>();
            for (int i2 = 0; i2 < R.length; ++i2) {
                if (!R[i2]) continue;
                boolean free = true;
                for (int j2 : N2.get(i2)) {
                    free &= R[j2];
                }
                if (!free) continue;
                this.C.add(new HashSet(N2.get(i2)));
                for (int j2 : N2.get(i2)) {
                    R[j2] = false;
                }
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> C2, List<Set<Integer>> N2, boolean[] R) {
            ArrayList belong = new ArrayList(R.length);
            for (int i2 = 0; i2 < R.length; ++i2) {
                belong.add(new ArrayList());
            }
            for (int k2 = 0; k2 < C2.size(); ++k2) {
                for (int j2 : C2.get(k2)) {
                    ((List)belong.get(j2)).add(k2);
                }
            }
            int[] intersect = new int[C2.size()];
            for (int i3 = 0; i3 < R.length; ++i3) {
                if (!R[i3]) continue;
                java.util.Arrays.fill(intersect, 0);
                int largest = 0;
                int maxValue = 0;
                for (int j3 : N2.get(i3)) {
                    Iterator iterator = ((List)belong.get(j3)).iterator();
                    while (iterator.hasNext()) {
                        int k3;
                        int n2 = k3 = ((Integer)iterator.next()).intValue();
                        intersect[n2] = intersect[n2] + 1;
                        if (intersect[k3] <= maxValue) continue;
                        largest = k3;
                        maxValue = intersect[largest];
                    }
                }
                if (maxValue <= 0) continue;
                R[i3] = false;
                C2.get(largest).add(i3);
            }
            return C2;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> C2, List<Set<Integer>> N2, boolean[] R) {
            for (int i2 = 0; i2 < R.length; ++i2) {
                if (!R[i2]) continue;
                HashSet<Integer> Cn = new HashSet<Integer>();
                for (int j2 : N2.get(i2)) {
                    if (!R[j2]) continue;
                    R[j2] = false;
                    Cn.add(j2);
                }
                if (Cn.isEmpty()) continue;
                C2.add(Cn);
            }
            return C2;
        }
    }
}

