/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.LinkedList;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.VectorInfo;
import no.uib.cipr.matrix.io.VectorSize;

public class MatrixVectorReader
extends BufferedReader {
    private StreamTokenizer st;

    public MatrixVectorReader(Reader in) {
        super(in);
        this.setup();
    }

    public MatrixVectorReader(Reader in, int sz) {
        super(in, sz);
        this.setup();
    }

    private void setup() {
        this.st = new StreamTokenizer(this);
        this.st.resetSyntax();
        this.st.eolIsSignificant(false);
        this.st.lowerCaseMode(true);
        this.st.wordChars(48, 57);
        this.st.wordChars(45, 46);
        this.st.wordChars(0, 255);
        this.st.commentChar(37);
        this.st.whitespaceChars(32, 32);
        this.st.whitespaceChars(9, 14);
    }

    public void add(int num, int[] indices) {
        int i2 = 0;
        while (i2 < indices.length) {
            int n2 = i2++;
            indices[n2] = indices[n2] + num;
        }
    }

    private String readTrimmedLine() throws IOException {
        String line = this.readLine();
        if (line != null) {
            return line.trim();
        }
        throw new EOFException();
    }

    public MatrixInfo readMatrixInfo() throws IOException {
        String[] component = this.readTrimmedLine().split(" +");
        if (component.length != 5) {
            throw new IOException("Current line unparsable. It must consist of 5 tokens");
        }
        if (!component[0].equalsIgnoreCase("%%MatrixMarket")) {
            throw new IOException("Not in Matrix Market exchange format");
        }
        if (!component[1].equalsIgnoreCase("matrix")) {
            throw new IOException("Expected \"matrix\", got " + component[1]);
        }
        boolean sparse = false;
        if (component[2].equalsIgnoreCase("coordinate")) {
            sparse = true;
        } else if (component[2].equalsIgnoreCase("array")) {
            sparse = false;
        } else {
            throw new IOException("Unknown layout " + component[2]);
        }
        MatrixInfo.MatrixField field = null;
        if (component[3].equalsIgnoreCase("real")) {
            field = MatrixInfo.MatrixField.Real;
        } else if (component[3].equalsIgnoreCase("integer")) {
            field = MatrixInfo.MatrixField.Integer;
        } else if (component[3].equalsIgnoreCase("complex")) {
            field = MatrixInfo.MatrixField.Complex;
        } else if (component[3].equalsIgnoreCase("pattern")) {
            field = MatrixInfo.MatrixField.Pattern;
        } else {
            throw new IOException("Unknown field specification " + component[3]);
        }
        MatrixInfo.MatrixSymmetry symmetry = null;
        if (component[4].equalsIgnoreCase("general")) {
            symmetry = MatrixInfo.MatrixSymmetry.General;
        } else if (component[4].equalsIgnoreCase("symmetric")) {
            symmetry = MatrixInfo.MatrixSymmetry.Symmetric;
        } else if (component[4].equalsIgnoreCase("skew-symmetric")) {
            symmetry = MatrixInfo.MatrixSymmetry.SkewSymmetric;
        } else if (component[4].equalsIgnoreCase("Hermitian")) {
            symmetry = MatrixInfo.MatrixSymmetry.Hermitian;
        } else {
            throw new IOException("Unknown symmetry specification " + component[4]);
        }
        return new MatrixInfo(sparse, field, symmetry);
    }

    public VectorInfo readVectorInfo() throws IOException {
        String[] component = this.readTrimmedLine().split(" +");
        if (component.length != 4) {
            throw new IOException("Current line unparsable. It must consist of 4 tokens");
        }
        if (!component[0].equalsIgnoreCase("%%MatrixMarket")) {
            throw new IOException("Not in Matrix Market exchange format");
        }
        if (!component[1].equalsIgnoreCase("vector")) {
            throw new IOException("Expected \"vector\", got " + component[1]);
        }
        boolean sparse = false;
        if (component[2].equalsIgnoreCase("coordinate")) {
            sparse = true;
        } else if (component[2].equalsIgnoreCase("array")) {
            sparse = false;
        } else {
            throw new IOException("Unknown layout " + component[2]);
        }
        VectorInfo.VectorField field = null;
        if (component[3].equalsIgnoreCase("real")) {
            field = VectorInfo.VectorField.Real;
        } else if (component[3].equalsIgnoreCase("integer")) {
            field = VectorInfo.VectorField.Integer;
        } else if (component[3].equalsIgnoreCase("complex")) {
            field = VectorInfo.VectorField.Complex;
        } else if (component[3].equalsIgnoreCase("pattern")) {
            field = VectorInfo.VectorField.Pattern;
        } else {
            throw new IOException("Unknown field specification " + component[3]);
        }
        return new VectorInfo(sparse, field);
    }

    public boolean hasInfo() throws IOException {
        this.mark(1024);
        String[] component = this.readTrimmedLine().split(" +");
        this.reset();
        return component[0].equalsIgnoreCase("%%MatrixMarket");
    }

    public String[] readComments() throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        while (true) {
            this.mark(1024);
            String line = this.readTrimmedLine();
            if (line.length() <= 0) continue;
            if (line.charAt(0) != '%') break;
            list.add(line.substring(1));
        }
        this.reset();
        return list.toArray(new String[list.size()]);
    }

    public MatrixSize readMatrixSize(MatrixInfo info) throws IOException {
        int numRows = this.getInt();
        int numColumns = this.getInt();
        if (info.isDense()) {
            return new MatrixSize(numRows, numColumns, info);
        }
        int numEntries = this.getInt();
        return new MatrixSize(numRows, numColumns, numEntries);
    }

    public MatrixSize readArraySize() throws IOException {
        int numRows = this.getInt();
        int numColumns = this.getInt();
        return new MatrixSize(numRows, numColumns, numRows * numColumns);
    }

    public MatrixSize readCoordinateSize() throws IOException {
        int numRows = this.getInt();
        int numColumns = this.getInt();
        int numEntries = this.getInt();
        return new MatrixSize(numRows, numColumns, numEntries);
    }

    public VectorSize readVectorSize(VectorInfo info) throws IOException {
        int size = this.getInt();
        if (info.isDense()) {
            return new VectorSize(size);
        }
        int numEntries = this.getInt();
        return new VectorSize(size, numEntries);
    }

    public VectorSize readVectorArraySize() throws IOException {
        int size = this.getInt();
        return new VectorSize(size);
    }

    public VectorSize readVectorCoordinateSize() throws IOException {
        int size = this.getInt();
        int numEntries = this.getInt();
        return new VectorSize(size, numEntries);
    }

    public void readArray(double[] data) throws IOException {
        int size = data.length;
        for (int i2 = 0; i2 < size; ++i2) {
            data[i2] = this.getDouble();
        }
    }

    public void readArray(float[] data) throws IOException {
        int size = data.length;
        for (int i2 = 0; i2 < size; ++i2) {
            data[i2] = this.getFloat();
        }
    }

    public void readArray(int[] data) throws IOException {
        int size = data.length;
        for (int i2 = 0; i2 < size; ++i2) {
            data[i2] = this.getInt();
        }
    }

    public void readArray(long[] data) throws IOException {
        int size = data.length;
        for (int i2 = 0; i2 < size; ++i2) {
            data[i2] = this.getLong();
        }
    }

    public void readArray(double[] dataR, double[] dataI) throws IOException {
        int size = dataR.length;
        if (size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            dataR[i2] = this.getDouble();
            dataI[i2] = this.getDouble();
        }
    }

    public void readArray(float[] dataR, float[] dataI) throws IOException {
        int size = dataR.length;
        if (size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            dataR[i2] = this.getFloat();
            dataI[i2] = this.getFloat();
        }
    }

    public void readCoordinate(int[] index, double[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            index[i2] = this.getInt();
            data[i2] = this.getDouble();
        }
    }

    public void readCoordinate(int[] index, float[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            index[i2] = this.getInt();
            data[i2] = this.getFloat();
        }
    }

    public void readCoordinate(int[] index, int[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            index[i2] = this.getInt();
            data[i2] = this.getInt();
        }
    }

    public void readCoordinate(int[] index, long[] data) throws IOException {
        int size = index.length;
        if (size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            index[i2] = this.getInt();
            data[i2] = this.getLong();
        }
    }

    public void readCoordinate(int[] index, float[] dataR, float[] dataI) throws IOException {
        int size = index.length;
        if (size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            index[i2] = this.getInt();
            dataR[i2] = this.getFloat();
            dataI[i2] = this.getFloat();
        }
    }

    public void readCoordinate(int[] index, double[] dataR, double[] dataI) throws IOException {
        int size = index.length;
        if (size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            index[i2] = this.getInt();
            dataR[i2] = this.getDouble();
            dataI[i2] = this.getDouble();
        }
    }

    public void readPattern(int[] index) throws IOException {
        int size = index.length;
        for (int i2 = 0; i2 < size; ++i2) {
            index[i2] = this.getInt();
        }
    }

    public void readCoordinate(int[] row, int[] column, double[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            row[i2] = this.getInt();
            column[i2] = this.getInt();
            data[i2] = this.getDouble();
        }
    }

    public void readCoordinate(int[] row, int[] column, float[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            row[i2] = this.getInt();
            column[i2] = this.getInt();
            data[i2] = this.getFloat();
        }
    }

    public void readCoordinate(int[] row, int[] column, int[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            row[i2] = this.getInt();
            column[i2] = this.getInt();
            data[i2] = this.getInt();
        }
    }

    public void readCoordinate(int[] row, int[] column, long[] data) throws IOException {
        int size = row.length;
        if (size != column.length || size != data.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            row[i2] = this.getInt();
            column[i2] = this.getInt();
            data[i2] = this.getLong();
        }
    }

    public void readPattern(int[] row, int[] column) throws IOException {
        int size = row.length;
        if (size != column.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            row[i2] = this.getInt();
            column[i2] = this.getInt();
        }
    }

    public void readCoordinate(int[] row, int[] column, double[] dataR, double[] dataI) throws IOException {
        int size = row.length;
        if (size != column.length || size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            row[i2] = this.getInt();
            column[i2] = this.getInt();
            dataR[i2] = this.getDouble();
            dataI[i2] = this.getDouble();
        }
    }

    public void readCoordinate(int[] row, int[] column, float[] dataR, float[] dataI) throws IOException {
        int size = row.length;
        if (size != column.length || size != dataR.length || size != dataI.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i2 = 0; i2 < size; ++i2) {
            row[i2] = this.getInt();
            column[i2] = this.getInt();
            dataR[i2] = this.getFloat();
            dataI[i2] = this.getFloat();
        }
    }

    private int getInt() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Double.valueOf(this.st.sval).intValue();
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private long getLong() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Long.parseLong(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private double getDouble() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Double.parseDouble(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private float getFloat() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Float.parseFloat(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }
}

