/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import java.util.BitSet;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;

public class PermutationMatrix
extends AbstractMatrix {
    private int[] permutations;
    private int[] pivots;
    private boolean transposed;

    public static PermutationMatrix fromPartialPivots(int[] pivots) {
        int i2;
        int[] permutations2 = new int[pivots.length];
        for (i2 = 0; i2 < pivots.length; ++i2) {
            permutations2[i2] = i2;
        }
        for (i2 = 0; i2 < pivots.length; ++i2) {
            int j2 = pivots[i2] - 1;
            if (j2 == i2) continue;
            int tmp = permutations2[i2];
            permutations2[i2] = permutations2[j2];
            permutations2[j2] = tmp;
        }
        return new PermutationMatrix(permutations2, pivots);
    }

    public PermutationMatrix(int[] permutations2) {
        this(permutations2, null);
    }

    private PermutationMatrix(int[] permutations2, int[] pivots) {
        super(permutations2.length, permutations2.length);
        this.permutations = permutations2;
        BitSet bitset = new BitSet();
        for (int i2 : permutations2) {
            if (bitset.get(i2)) {
                throw new IllegalArgumentException("non-unique permutations: " + i2);
            }
            bitset.set(i2);
        }
        this.pivots = pivots;
    }

    @Override
    public double get(int row, int column) {
        if (!this.transposed && this.permutations[row] == column) {
            return 1.0;
        }
        if (this.transposed && this.permutations[column] == row) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Matrix transpose() {
        this.transposed = !this.transposed;
        return this;
    }

    @Override
    public Matrix mult(Matrix B2, Matrix C2) {
        if (C2 instanceof DenseMatrix) {
            return this.mult(B2, (DenseMatrix)C2);
        }
        return super.mult(B2, C2);
    }

    public Matrix mult(Matrix B2, DenseMatrix C2) {
        if (this.pivots == null) {
            return super.mult(B2, C2);
        }
        this.checkMultAdd(B2, C2);
        C2.set(B2);
        LAPACK.getInstance().dlaswp(C2.numColumns(), C2.getData(), Matrices.ld(C2.numRows()), 1, this.pivots.length, this.pivots, this.transposed ? -1 : 1);
        return C2;
    }

    @Override
    public Matrix transAmult(Matrix B2, Matrix C2) {
        if (C2 instanceof DenseMatrix) {
            return this.transAmult(B2, (DenseMatrix)C2);
        }
        return super.transAmult(B2, C2);
    }

    public Matrix transAmult(Matrix B2, DenseMatrix C2) {
        if (this.pivots == null) {
            return super.transAmult(B2, C2);
        }
        this.checkTransAmultAdd(B2, C2);
        C2.set(B2);
        LAPACK.getInstance().dlaswp(C2.numColumns(), C2.getData(), Matrices.ld(C2.numRows()), 1, this.pivots.length, this.pivots, this.transposed ? 1 : -1);
        return C2;
    }
}

