/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangPackMatrix;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class LowerTriangPackMatrix
extends AbstractTriangPackMatrix {
    public LowerTriangPackMatrix(int n2) {
        super(n2, UpLo.Lower, Diag.NonUnit);
    }

    LowerTriangPackMatrix(int n2, Diag diag) {
        super(n2, UpLo.Lower, diag);
    }

    public LowerTriangPackMatrix(Matrix A2) {
        this(A2, true);
    }

    public LowerTriangPackMatrix(Matrix A2, boolean deep) {
        super(A2, deep, UpLo.Lower, Diag.NonUnit);
    }

    LowerTriangPackMatrix(Matrix A2, boolean deep, Diag diag) {
        super(A2, deep, UpLo.Lower, diag);
    }

    @Override
    public void add(int row, int column, double value) {
        if (column > row) {
            throw new IllegalArgumentException("column > row");
        }
        int n2 = this.getIndex(row, column);
        this.data[n2] = this.data[n2] + value;
    }

    @Override
    public void set(int row, int column, double value) {
        if (column > row) {
            throw new IllegalArgumentException("column > row");
        }
        this.data[this.getIndex((int)row, (int)column)] = value;
    }

    @Override
    public double get(int row, int column) {
        if (column > row) {
            return 0.0;
        }
        return this.data[this.getIndex(row, column)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + (2 * this.n - (column + 1)) * column / 2;
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e2 : A2) {
            if (e2.row() < e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }

    @Override
    public LowerTriangPackMatrix copy() {
        return new LowerTriangPackMatrix(this);
    }
}

