/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.DenseVector;

public class DenseVectorSub
extends AbstractVector {
    private DenseVector wrapped;
    private int offset;

    public DenseVectorSub(DenseVector wrapped, int offset, int size) {
        super(size);
        if (offset + size > wrapped.size) {
            throw new IllegalArgumentException(offset + "+" + size + ">" + wrapped.size);
        }
        this.offset = offset;
        this.wrapped = wrapped;
    }

    @Override
    public double get(int index) {
        this.check(index);
        return this.wrapped.get(this.offset + index);
    }

    @Override
    public void set(int index, double value) {
        this.check(index);
        this.wrapped.set(this.offset + index, value);
    }

    @Override
    public DenseVector copy() {
        double[] data = Arrays.copyOfRange(this.wrapped.getData(), this.offset, this.offset + this.size);
        return new DenseVector(data, false);
    }
}

