/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import no.priv.garshol.duke.utils.SparqlResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SparqlClient {
    private static final String SPARQL_NS = "http://www.w3.org/2005/sparql-results#";

    public static SparqlResult execute(String endpoint, String query) {
        query = SparqlClient.urlencode(query);
        String url = endpoint + "?query=" + query;
        return SparqlClient.loadResultSet(SparqlClient.getResponse(url));
    }

    public static SparqlResult loadResultSet(InputSource source) {
        try {
            ResultHandler handler = new ResultHandler();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(handler);
            parser.parse(source);
            return handler.getResults();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        catch (SAXException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static InputSource getResponse(String url) {
        try {
            URL urlobj = new URL(url);
            URLConnection conn = urlobj.openConnection();
            conn.setRequestProperty("Accept", "application/sparql-results+xml");
            return new InputSource(conn.getInputStream());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String urlencode(String url) {
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static class ResultHandler
    extends DefaultHandler {
        private SparqlResult result = new SparqlResult();
        private String[] currentRow;
        private Map<String, Integer> columnIndexes = new HashMap<String, Integer>();
        private int colix = 0;
        private String curvar;
        private Set<String> keepers = new HashSet<String>();
        private boolean keep;
        private StringBuffer content = new StringBuffer();

        private ResultHandler() {
            this.keepers.add("uri");
            this.keepers.add("literal");
            this.keepers.add("bnode");
        }

        public SparqlResult getResults() {
            return this.result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!SparqlClient.SPARQL_NS.equals(uri)) {
                return;
            }
            if (localName.equals("variable")) {
                String var = attributes.getValue("name");
                this.columnIndexes.put(var, this.colix++);
                this.result.addVariable(var);
            } else if (localName.equals("result")) {
                this.currentRow = new String[this.columnIndexes.size()];
            } else if (localName.equals("binding")) {
                this.curvar = attributes.getValue("name");
            } else if (this.keepers.contains(localName)) {
                this.keep = true;
                this.content.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.keep) {
                this.content.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!SparqlClient.SPARQL_NS.equals(uri)) {
                return;
            }
            if (localName.equals("binding")) {
                int ix = this.columnIndexes.get(this.curvar);
                this.currentRow[ix] = this.content.toString();
            } else if (localName.equals("result")) {
                this.result.addRow(this.currentRow);
            } else if (this.keepers.contains(localName)) {
                this.keep = false;
            }
        }
    }
}

