/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.genetic.GeneticConfiguration;

public class GeneticPopulation {
    private GeneticConfiguration config;
    private List<GeneticConfiguration> population;
    private int size;

    public GeneticPopulation(Configuration config) {
        this.config = new GeneticConfiguration(config);
        this.size = 100;
    }

    public void create() {
        this.population = new ArrayList<GeneticConfiguration>(this.size);
        for (int ix = 0; ix < this.size; ++ix) {
            this.population.add(this.config.makeRandomCopy());
        }
    }

    public List<GeneticConfiguration> getConfigs() {
        return this.population;
    }

    public void setNewGeneration(List<GeneticConfiguration> nextgen) {
        this.population = nextgen;
    }

    public void sort() {
        Collections.sort(this.population);
        for (int ix = 0; ix < this.population.size(); ++ix) {
            this.population.get(ix).setRank(ix + 1);
        }
    }

    public GeneticConfiguration getBestConfiguration() {
        return this.population.get(0);
    }

    public GeneticConfiguration getWorstConfiguration() {
        return this.population.get(this.population.size() - 1);
    }

    public GeneticConfiguration pickRandomConfig() {
        return this.population.get((int)Math.random() * this.population.size());
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int size() {
        return this.size;
    }
}

