/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.JDBCDataSource;
import no.priv.garshol.duke.utils.JDBCUtils;

public class JNDIDataSource
extends JDBCDataSource {
    private String jndipath;

    @Override
    public RecordIterator getRecords() {
        this.verifyProperty(this.jndipath, "jndi-path");
        try {
            Statement stmt2 = JDBCUtils.open(this.jndipath);
            ResultSet rs = stmt2.executeQuery(this.getQuery());
            return new JDBCDataSource.JDBCIterator(rs);
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    protected String getSourceName() {
        return "JNDI";
    }

    public void setJndiPath(String path) {
        this.jndipath = path;
    }

    public String getJndiPath() {
        return this.jndipath;
    }
}

