/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.Logger;
import no.priv.garshol.duke.datasources.Column;

public abstract class ColumnarDataSource
implements DataSource {
    protected Map<String, Collection<Column>> columns = new HashMap<String, Collection<Column>>();
    protected Logger logger;

    public void addColumn(Column column) {
        Collection<Column> cols = this.columns.get(column.getName());
        if (cols == null) {
            cols = new ArrayList<Column>();
            this.columns.put(column.getName(), cols);
        }
        cols.add(column);
    }

    public Collection<Column> getColumn(String name) {
        return this.columns.get(name);
    }

    public Collection<Column> getColumns() {
        ArrayList<Column> all = new ArrayList<Column>(this.columns.size());
        for (Collection<Column> col : this.columns.values()) {
            all.addAll(col);
        }
        return all;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected abstract String getSourceName();

    protected void verifyProperty(String value, String name) {
        if (value == null) {
            throw new DukeConfigException("Missing '" + name + "' property to " + this.getSourceName() + " data source");
        }
    }
}

