/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.RecordBuilder;
import no.priv.garshol.duke.utils.CSVReader;

public class CSVDataSource
extends ColumnarDataSource {
    private String file;
    private String encoding;
    private Reader directreader;
    private int skiplines;
    private boolean hasheader = true;
    private char separator;

    public String getInputFile() {
        return this.file;
    }

    public void setInputFile(String file) {
        this.file = file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getSkipLines() {
        return this.skiplines;
    }

    public void setSkipLines(int skiplines) {
        this.skiplines = skiplines;
    }

    public boolean getHeaderLine() {
        return this.hasheader;
    }

    public void setHeaderLine(boolean hasheader) {
        this.hasheader = hasheader;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setReader(Reader reader) {
        this.directreader = reader;
    }

    @Override
    public RecordIterator getRecords() {
        if (this.directreader == null) {
            this.verifyProperty(this.file, "input-file");
        }
        try {
            Reader in = this.directreader != null ? this.directreader : (this.encoding == null ? new FileReader(this.file) : new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
            CSVReader csv = new CSVReader(in);
            if (this.separator != '\u0000') {
                csv.setSeparator(this.separator);
            }
            return new CSVRecordIterator(csv);
        }
        catch (FileNotFoundException e2) {
            throw new DukeConfigException("Couldn't find CSV file '" + this.file + "'");
        }
        catch (IOException e3) {
            throw new DukeException(e3);
        }
    }

    @Override
    protected String getSourceName() {
        return "CSV";
    }

    public class CSVRecordIterator
    extends RecordIterator {
        private CSVReader reader;
        private int[] index;
        private Column[] column;
        private RecordBuilder builder;
        private Record nextrecord;

        public CSVRecordIterator(CSVReader reader) throws IOException {
            this.reader = reader;
            this.builder = new RecordBuilder(CSVDataSource.this);
            this.index = new int[CSVDataSource.this.columns.size()];
            this.column = new Column[CSVDataSource.this.columns.size()];
            for (int ix = 0; ix < CSVDataSource.this.skiplines; ++ix) {
                reader.next();
            }
            String[] header = null;
            if (CSVDataSource.this.hasheader) {
                header = reader.next();
            } else {
                int high = 0;
                for (Column c2 : CSVDataSource.this.getColumns()) {
                    high = Math.max(high, Integer.parseInt(c2.getName()));
                }
                header = new String[high];
                for (int ix = 0; ix < high; ++ix) {
                    header[ix] = "" + (ix + 1);
                }
            }
            int count2 = 0;
            for (Column c2 : CSVDataSource.this.getColumns()) {
                boolean found = false;
                for (int ix = 0; ix < header.length; ++ix) {
                    if (!header[ix].equals(c2.getName())) continue;
                    this.index[count2] = ix;
                    this.column[count2++] = c2;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new DukeConfigException("Column " + c2.getName() + " not found " + "in CSV file");
            }
            this.findNextRecord();
        }

        private void findNextRecord() {
            String[] row;
            try {
                row = this.reader.next();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            if (row == null) {
                this.nextrecord = null;
                return;
            }
            this.builder.newRecord();
            for (int ix = 0; ix < this.column.length; ++ix) {
                if (this.index[ix] >= row.length) continue;
                this.builder.addValue(this.column[ix], row[this.index[ix]]);
            }
            this.nextrecord = this.builder.getRecord();
        }

        @Override
        public boolean hasNext() {
            return this.nextrecord != null;
        }

        @Override
        public Record next() {
            Record thenext = this.nextrecord;
            this.findNextRecord();
            return thenext;
        }
    }
}

