/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import no.priv.garshol.duke.CompactRecord;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.databases.AbstractBlockingDatabase;
import no.priv.garshol.duke.databases.KeyFunction;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class MapDBBlockingDatabase
extends AbstractBlockingDatabase {
    private DB db;
    private boolean overwrite;
    private int cache_size = 32768;
    private String file;
    private boolean async = true;
    private boolean mmap = true;
    private boolean compression;
    private boolean snapshot;
    private boolean notxn;

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setCacheSize(int cache_size) {
        this.cache_size = cache_size;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setMmap(boolean mmap) {
        this.mmap = mmap;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public void setNotxn(boolean notxn) {
        this.notxn = notxn;
    }

    @Override
    public void index(Record record) {
        Record old;
        if (this.db == null) {
            this.init();
        }
        String id = this.getId(record);
        if (!this.overwrite && this.file != null && (old = this.findRecordById(id)) != null) {
            for (KeyFunction keyfunc : this.functions) {
                NavigableMap blocks = this.getBlocks(keyfunc);
                String key = keyfunc.makeKey(old);
                Block block = (Block)blocks.get(key);
                block.remove(id);
                blocks.put(key, block);
            }
        }
        this.indexById(record);
        for (KeyFunction keyfunc : this.functions) {
            String key;
            NavigableMap blocks = this.getBlocks(keyfunc);
            Block block = (Block)blocks.get(key = keyfunc.makeKey(record));
            if (block == null) {
                block = new Block();
            }
            block.add(id);
            blocks.put(key, block);
        }
    }

    @Override
    public Record findRecordById(String id) {
        if (this.db == null) {
            this.init();
        }
        return (Record)this.idmap.get(id);
    }

    @Override
    public Collection<Record> findCandidateMatches(Record record) {
        if (this.db == null) {
            this.init();
        }
        return super.findCandidateMatches(record);
    }

    @Override
    public boolean isInMemory() {
        return this.file == null;
    }

    @Override
    public void commit() {
    }

    @Override
    public void close() {
        this.db.commit();
        this.db.close();
    }

    public String toString() {
        return "MapDBBlockingDatabase window_size=" + this.window_size + ", cache_size=" + this.cache_size + ", in-memory=" + this.isInMemory() + "\n  " + "async=" + this.async + ", mmap=" + this.mmap + ", compress=" + this.compression + ", snapshot=" + this.snapshot + "\n  notxn=" + this.notxn + "\n  " + this.functions;
    }

    private String getId(Record r2) {
        for (Property idprop : this.config.getIdentityProperties()) {
            String v2 = r2.getValue(idprop.getName());
            if (v2 == null) continue;
            return v2;
        }
        return null;
    }

    private void init() {
        DBMaker maker;
        if (this.file == null) {
            maker = DBMaker.newMemoryDB();
        } else {
            if (this.overwrite) {
                this.wipe(this.file);
            }
            maker = DBMaker.newFileDB((File)new File(this.file));
            maker = maker.cacheSize(this.cache_size);
            if (this.async) {
                maker = maker.asyncWriteEnable();
                maker = maker.asyncWriteFlushDelay(10000);
            }
            if (this.mmap) {
                maker = maker.mmapFileEnableIfSupported();
            }
            if (this.compression) {
                maker = maker.compressionEnable();
            }
            if (this.snapshot) {
                maker = maker.snapshotEnable();
            }
            if (this.notxn) {
                maker = maker.transactionDisable();
            }
        }
        this.db = maker.make();
        this.idmap = !this.db.exists("idmap") ? this.db.createHashMap("idmap").valueSerializer((Serializer)new RecordSerializer()).make() : this.db.getHashMap("idmap");
    }

    private void wipe(String dbfile) {
        File file = new File(dbfile);
        File dir = file.getParentFile();
        for (File f2 : dir.listFiles()) {
            if (!f2.getName().startsWith(file.getName())) continue;
            f2.delete();
        }
    }

    @Override
    protected int addBlock(Collection<Record> candidates, Map.Entry entry) {
        int ix;
        Block block = (Block)entry.getValue();
        String[] ids = block.getIds();
        for (ix = 0; ix < block.size(); ++ix) {
            candidates.add((Record)this.idmap.get(ids[ix]));
        }
        return ix;
    }

    @Override
    protected NavigableMap makeMap(KeyFunction keyfunc) {
        String name;
        if (this.db == null) {
            this.init();
        }
        if (!this.db.exists(name = keyfunc.getClass().getName())) {
            return this.db.createTreeMap(name).valueSerializer((Serializer)new BlockSerializer()).make();
        }
        return this.db.getTreeMap(name);
    }

    static class RecordSerializer
    implements Serializable,
    Serializer<CompactRecord> {
        RecordSerializer() {
        }

        public void serialize(DataOutput out, CompactRecord value) throws IOException {
            int free = value.getFree();
            out.writeInt(free);
            String[] s2 = value.getArray();
            for (int ix = 0; ix < free; ++ix) {
                out.writeUTF(s2[ix]);
            }
        }

        public CompactRecord deserialize(DataInput in, int available) throws IOException {
            int free = in.readInt();
            String[] s2 = new String[free];
            for (int ix = 0; ix < free; ++ix) {
                s2[ix] = in.readUTF();
            }
            return new CompactRecord(free, s2);
        }

        public int fixedSize() {
            return -1;
        }
    }

    static class BlockSerializer
    implements Serializable,
    Serializer<Block> {
        BlockSerializer() {
        }

        public void serialize(DataOutput out, Block block) throws IOException {
            int size = block.size();
            out.writeInt(size);
            String[] ids = block.getIds();
            for (int ix = 0; ix < size; ++ix) {
                out.writeUTF(ids[ix]);
            }
        }

        public Block deserialize(DataInput in, int available) throws IOException {
            int free = in.readInt();
            String[] ids = new String[free];
            for (int ix = 0; ix < free; ++ix) {
                ids[ix] = in.readUTF();
            }
            return new Block(free, ids);
        }

        public int fixedSize() {
            return -1;
        }
    }

    public static class Block
    implements Serializable {
        private int free;
        private String[] ids;

        public Block() {
            this.ids = new String[10];
        }

        public Block(int free, String[] ids) {
            this.free = free;
            this.ids = ids;
        }

        public String[] getIds() {
            return this.ids;
        }

        public void add(String id) {
            if (this.free >= this.ids.length) {
                String[] newids = new String[this.ids.length * 2];
                for (int ix = 0; ix < this.ids.length; ++ix) {
                    newids[ix] = this.ids[ix];
                }
                this.ids = newids;
            }
            this.ids[this.free++] = id;
        }

        public void remove(String id) {
            for (int ix = 0; ix < this.free; ++ix) {
                if (!this.ids[ix].equals(id)) continue;
                --this.free;
                this.ids[ix] = this.ids[this.free];
                return;
            }
        }

        public int size() {
            return this.free;
        }
    }
}

