/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.comparators.GeopositionComparator;
import no.priv.garshol.duke.databases.DocumentRecord;
import no.priv.garshol.duke.databases.GeoProperty;
import no.priv.garshol.duke.utils.Utils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public class LuceneDatabase
implements Database {
    private Configuration config;
    private EstimateResultTracker maintracker;
    private IndexWriter iwriter;
    private Directory directory;
    private IndexReader reader;
    private IndexSearcher searcher;
    private Analyzer analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
    private static final int SEARCH_EXPANSION_FACTOR = 1;
    private int max_search_hits = 1000000;
    private float min_relevance;
    private boolean overwrite;
    private String path;
    private boolean fuzzy_search = true;
    private GeoProperty geoprop;

    public LuceneDatabase() {
        this.maintracker = new EstimateResultTracker();
    }

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setMaxSearchHits(int max_search_hits) {
        this.max_search_hits = max_search_hits;
    }

    public void setMinRelevance(float min_relevance) {
        this.min_relevance = min_relevance;
    }

    public void setFuzzySearch(boolean fuzzy_search) {
        this.fuzzy_search = fuzzy_search;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isInMemory() {
        return this.directory instanceof RAMDirectory;
    }

    @Override
    public void index(Record record) {
        if (this.directory == null) {
            this.init();
        }
        if (!this.overwrite && this.path != null) {
            this.delete(record);
        }
        Document doc = new Document();
        for (String propname : record.getProperties()) {
            Property prop = this.config.getPropertyByName(propname);
            if (prop == null) {
                throw new DukeConfigException("Record has property " + propname + " for which there is no configuration");
            }
            if (prop.getComparator() instanceof GeopositionComparator && this.geoprop != null) {
                String v2 = record.getValue(propname);
                if (v2 == null || v2.equals("")) continue;
                for (IndexableField f2 : this.geoprop.createIndexableFields(v2)) {
                    doc.add(f2);
                }
                doc.add((IndexableField)new Field(propname, v2, Field.Store.YES, Field.Index.NOT_ANALYZED));
                continue;
            }
            Field.Index ix = prop.isIdProperty() ? Field.Index.NOT_ANALYZED : Field.Index.ANALYZED;
            for (String v3 : record.getValues(propname)) {
                if (v3.equals("")) continue;
                doc.add((IndexableField)new Field(propname, v3, Field.Store.YES, ix));
            }
        }
        try {
            this.iwriter.addDocument((Iterable)doc);
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    private void delete(Record record) {
        Property idprop = this.config.getIdentityProperties().iterator().next();
        Query q2 = this.parseTokens(idprop.getName(), record.getValue(idprop.getName()));
        try {
            this.iwriter.deleteDocuments(q2);
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    @Override
    public void commit() {
        if (this.directory == null) {
            return;
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.iwriter.commit();
            this.openSearchers();
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    @Override
    public Record findRecordById(String id) {
        if (this.directory == null) {
            this.init();
        }
        Property idprop = this.config.getIdentityProperties().iterator().next();
        for (Record r2 : this.lookup(idprop, id)) {
            if (!r2.getValue(idprop.getName()).equals(id)) continue;
            return r2;
        }
        return null;
    }

    @Override
    public Collection<Record> findCandidateMatches(Record record) {
        String value;
        if (this.geoprop != null && (value = record.getValue(this.geoprop.getName())) != null) {
            Filter filter = this.geoprop.geoSearch(value);
            return this.maintracker.doQuery((Query)new MatchAllDocsQuery(), filter);
        }
        BooleanQuery query = new BooleanQuery();
        for (Property prop : this.config.getLookupProperties()) {
            Collection<String> values = record.getValues(prop.getName());
            if (values == null) continue;
            for (String value2 : values) {
                this.parseTokens(query, prop.getName(), value2, prop.getLookupBehaviour() == Property.Lookup.REQUIRED);
            }
        }
        return this.maintracker.doQuery((Query)query);
    }

    @Override
    public void close() {
        if (this.directory == null) {
            return;
        }
        try {
            this.iwriter.close();
            this.directory.close();
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    public String toString() {
        return "LuceneDatabase, max-search-hits: " + this.max_search_hits + ", min-relevance: " + this.min_relevance + ", fuzzy=" + this.fuzzy_search + "\n  " + this.directory;
    }

    private void init() {
        try {
            this.openIndexes(this.overwrite);
            this.openSearchers();
            this.initSpatial();
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    private void openIndexes(boolean overwrite) {
        if (this.directory == null) {
            try {
                this.directory = this.path == null ? new RAMDirectory() : (Utils.isWindowsOS() ? FSDirectory.open((File)new File(this.path)) : NIOFSDirectory.open((File)new File(this.path)));
                IndexWriterConfig cfg = new IndexWriterConfig(Version.LUCENE_CURRENT, this.analyzer);
                cfg.setOpenMode(overwrite ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
                this.iwriter = new IndexWriter(this.directory, cfg);
                this.iwriter.commit();
            }
            catch (IndexNotFoundException e2) {
                if (!overwrite) {
                    this.directory = null;
                    this.openIndexes(true);
                }
                throw new DukeException(e2);
            }
            catch (IOException e3) {
                throw new DukeException(e3);
            }
        }
    }

    public void openSearchers() throws IOException {
        this.reader = DirectoryReader.open((Directory)this.directory);
        this.searcher = new IndexSearcher(this.reader);
    }

    private Query parseTokens(String fieldName, String value) {
        BooleanQuery searchQuery = new BooleanQuery();
        if (value != null) {
            KeywordAnalyzer analyzer = new KeywordAnalyzer();
            try {
                TokenStream tokenStream = analyzer.tokenStream(fieldName, (Reader)new StringReader(value));
                tokenStream.reset();
                CharTermAttribute attr = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                while (tokenStream.incrementToken()) {
                    String term = attr.toString();
                    TermQuery termQuery = new TermQuery(new Term(fieldName, term));
                    searchQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
                }
            }
            catch (IOException e2) {
                throw new DukeException("Error parsing input string '" + value + "' " + "in field " + fieldName);
            }
        }
        return searchQuery;
    }

    protected void parseTokens(BooleanQuery parent, String fieldName, String value, boolean required) {
        if ((value = this.escapeLucene(value)).length() == 0) {
            return;
        }
        try {
            TokenStream tokenStream = this.analyzer.tokenStream(fieldName, (Reader)new StringReader(value));
            tokenStream.reset();
            CharTermAttribute attr = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            while (tokenStream.incrementToken()) {
                String term = attr.toString();
                Object termQuery = this.fuzzy_search && this.isFuzzy(fieldName) ? new FuzzyQuery(new Term(fieldName, term)) : new TermQuery(new Term(fieldName, term));
                parent.add((Query)termQuery, required ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
            }
        }
        catch (IOException e2) {
            throw new DukeException("Error parsing input string '" + value + "' " + "in field " + fieldName);
        }
    }

    private boolean isFuzzy(String fieldName) {
        Comparator c2 = this.config.getPropertyByName(fieldName).getComparator();
        return c2 != null && c2.isTokenized();
    }

    private String escapeLucene(String query) {
        char[] tmp = new char[query.length() * 2];
        int count2 = 0;
        for (int ix = 0; ix < query.length(); ++ix) {
            char ch = query.charAt(ix);
            if (ch == '*' || ch == '?' || ch == '!' || ch == '&' || ch == '(' || ch == ')' || ch == '-' || ch == '+' || ch == ':' || ch == '\"' || ch == '[' || ch == ']' || ch == '~' || ch == '{' || ch == '}' || ch == '^' || ch == '|') {
                tmp[count2++] = 92;
            }
            tmp[count2++] = ch;
        }
        return new String(tmp, 0, count2).trim();
    }

    public Collection<Record> lookup(Property property, String value) {
        Query query = this.parseTokens(property.getName(), value);
        return this.maintracker.doQuery(query);
    }

    private void initSpatial() {
        if (this.config.getLookupProperties().size() != 1) {
            return;
        }
        Property prop = this.config.getLookupProperties().iterator().next();
        if (!(prop.getComparator() instanceof GeopositionComparator)) {
            return;
        }
        this.geoprop = new GeoProperty(prop);
    }

    class EstimateResultTracker {
        private int limit = 100;
        private int[] prevsizes = new int[10];
        private int sizeix;

        public Collection<Record> doQuery(Query query) {
            return this.doQuery(query, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Record> doQuery(Query query, Filter filter) {
            ArrayList<Record> matches;
            block8: {
                try {
                    ScoreDoc[] hits;
                    for (int thislimit = Math.min(this.limit, LuceneDatabase.this.max_search_hits); (hits = ((LuceneDatabase)LuceneDatabase.this).searcher.search((Query)query, (Filter)filter, (int)thislimit).scoreDocs).length >= thislimit && thislimit != LuceneDatabase.this.max_search_hits; thislimit *= 5) {
                    }
                    matches = new ArrayList<Record>(Math.min(hits.length, LuceneDatabase.this.max_search_hits));
                    for (int ix = 0; ix < hits.length && hits[ix].score >= LuceneDatabase.this.min_relevance; ++ix) {
                        matches.add(new DocumentRecord(hits[ix].doc, LuceneDatabase.this.searcher.doc(hits[ix].doc)));
                    }
                    if (hits.length <= 0) break block8;
                    EstimateResultTracker estimateResultTracker = this;
                    synchronized (estimateResultTracker) {
                        this.prevsizes[this.sizeix++] = matches.size();
                        if (this.sizeix == this.prevsizes.length) {
                            this.sizeix = 0;
                            this.limit = Math.max((int)(this.average() * 1.0), this.limit);
                        }
                    }
                }
                catch (IOException e2) {
                    throw new DukeException(e2);
                }
            }
            return matches;
        }

        private double average() {
            int ix;
            int sum = 0;
            for (ix = 0; ix < this.prevsizes.length && this.prevsizes[ix] != 0; ++ix) {
                sum += this.prevsizes[ix];
            }
            return (double)sum / (double)ix;
        }
    }
}

