/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import java.util.ArrayList;
import java.util.Collections;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.comparators.JaroWinkler;
import no.priv.garshol.duke.utils.StringUtils;

public class JaroWinklerTokenized
implements Comparator {
    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String s1, String s2) {
        String[] t2;
        if (s1.equals(s2)) {
            return 1.0;
        }
        String[] t1 = StringUtils.split(s1);
        if (t1.length > (t2 = StringUtils.split(s2)).length) {
            String[] tmp = t2;
            t2 = t1;
            t1 = tmp;
        }
        ArrayList<Match> matches = new ArrayList<Match>(t1.length * t2.length);
        for (int ix1 = 0; ix1 < t1.length; ++ix1) {
            for (int ix2 = 0; ix2 < t2.length; ++ix2) {
                matches.add(new Match(JaroWinkler.similarity(t1[ix1], t2[ix2]), ix1, ix2));
            }
        }
        Collections.sort(matches);
        double sum = 0.0;
        for (Match m4 : matches) {
            if (t1[m4.ix1] == null || t2[m4.ix2] == null) continue;
            sum += m4.score;
            t1[m4.ix1] = null;
            t2[m4.ix2] = null;
        }
        return sum / (double)t1.length;
    }

    static class Match
    implements Comparable {
        double score;
        int ix1;
        int ix2;

        public Match(double score, int ix1, int ix2) {
            this.score = score;
            this.ix1 = ix1;
            this.ix2 = ix2;
        }

        public int compareTo(Object other) {
            if (!(other instanceof Match)) {
                return -1;
            }
            double oscore = ((Match)other).score;
            if (this.score < oscore) {
                return 1;
            }
            if (this.score > oscore) {
                return -1;
            }
            return 0;
        }
    }
}

