/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.IOException;
import java.util.Collection;
import no.priv.garshol.duke.AbstractCmdlineTool;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.utils.Utils;
import org.xml.sax.SAXException;

public class DebugCompare
extends AbstractCmdlineTool {
    public static void main(String[] argv) throws IOException, SAXException {
        new DebugCompare().run(argv);
    }

    public void run(String[] argv) throws IOException, SAXException {
        Record r1 = this.database.findRecordById((argv = this.init(argv, 3, 3))[1]);
        if (r1 == null) {
            System.err.println("Couldn't find record for '" + argv[1] + "'");
            System.err.println("Consider using --reindex");
            return;
        }
        Record r2 = this.database.findRecordById(argv[2]);
        if (r2 == null) {
            System.err.println("Couldn't find record for '" + argv[2] + "'");
            System.err.println("Consider using --reindex");
            return;
        }
        double prob = 0.5;
        for (Property prop : this.config.getProperties()) {
            if (prop.isIdProperty()) continue;
            String propname = prop.getName();
            System.out.println("---" + propname);
            Collection<String> vs1 = r1.getValues(propname);
            Collection<String> vs2 = r2.getValues(propname);
            if (vs1.isEmpty() || vs2.isEmpty() || prop.isIgnoreProperty()) continue;
            double high = 0.0;
            block3: for (String v1 : vs1) {
                if (v1.equals("")) continue;
                for (String v2 : vs2) {
                    if (v2.equals("")) continue;
                    try {
                        Comparator comp = prop.getComparator();
                        if (comp == null) {
                            high = 0.5;
                            continue block3;
                        }
                        double d2 = comp.compare(v1, v2);
                        double p2 = prop.compare(v1, v2);
                        System.out.println("'" + v1 + "' ~ '" + v2 + "': " + d2 + " (prob " + p2 + ")");
                        high = Math.max(high, p2);
                    }
                    catch (Exception e2) {
                        throw new DukeException("Comparison of values '" + v1 + "' and " + "'" + v2 + "' failed", e2);
                    }
                }
            }
            double newprob = Utils.computeBayes(prob, high);
            System.out.println("Result: " + prob + " -> " + newprob + "\n");
            prob = newprob;
        }
        System.out.println("Overall: " + prob);
    }

    @Override
    protected void usage() {
        System.out.println("");
        System.out.println("java no.priv.garshol.duke.DebugCompare <cfgfile> <id1> <id2>");
        System.out.println("");
        System.out.println("  --reindex: Reindex all records before comparing");
    }
}

