/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.FileOutputStream;
import java.io.IOException;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.datasources.CSVDataSource;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.JDBCDataSource;
import no.priv.garshol.duke.datasources.JNDIDataSource;
import no.priv.garshol.duke.utils.XMLPrettyPrinter;
import org.xml.sax.helpers.AttributeListImpl;

public class ConfigWriter {
    public static void write(Configuration config, String file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        XMLPrettyPrinter pp = new XMLPrettyPrinter(fos);
        pp.startDocument();
        pp.startElement("duke", null);
        pp.startElement("schema", null);
        ConfigWriter.writeElement(pp, "threshold", "" + config.getThreshold());
        if (config.getMaybeThreshold() != 0.0) {
            ConfigWriter.writeElement(pp, "maybe-threshold", "" + config.getMaybeThreshold());
        }
        for (Property p2 : config.getProperties()) {
            ConfigWriter.writeProperty(pp, p2);
        }
        pp.endElement("schema");
        if (config.isDeduplicationMode()) {
            for (DataSource src : config.getDataSources()) {
                ConfigWriter.writeDataSource(pp, src);
            }
        }
        pp.endElement("duke");
        pp.endDocument();
        fos.close();
    }

    private static void writeParam(XMLPrettyPrinter pp, String name, String value) {
        if (value == null) {
            return;
        }
        AttributeListImpl atts = new AttributeListImpl();
        atts.addAttribute("name", "CDATA", name);
        atts.addAttribute("value", "CDATA", value);
        pp.startElement("param", atts);
        pp.endElement("param");
    }

    private static void writeParam(XMLPrettyPrinter pp, String name, int value) {
        ConfigWriter.writeParam(pp, name, "" + value);
    }

    private static void writeParam(XMLPrettyPrinter pp, String name, char value) {
        ConfigWriter.writeParam(pp, name, "" + value);
    }

    private static void writeParam(XMLPrettyPrinter pp, String name, boolean value) {
        ConfigWriter.writeParam(pp, name, "" + value);
    }

    private static void writeElement(XMLPrettyPrinter pp, String name, String value) {
        if (value == null) {
            return;
        }
        pp.startElement(name, null);
        pp.text(value);
        pp.endElement(name);
    }

    private static void writeProperty(XMLPrettyPrinter pp, Property prop) {
        AttributeListImpl atts = new AttributeListImpl();
        if (prop.isIdProperty()) {
            atts.addAttribute("type", "CDATA", "id");
        } else if (prop.isIgnoreProperty()) {
            atts.addAttribute("type", "CDATA", "ignore");
        }
        if (!prop.isIdProperty() && prop.getLookupBehaviour() != Property.Lookup.DEFAULT) {
            String value = prop.getLookupBehaviour().toString().toLowerCase();
            atts.addAttribute("lookup", "CDATA", value);
        }
        pp.startElement("property", atts);
        ConfigWriter.writeElement(pp, "name", prop.getName());
        if (prop.getComparator() != null) {
            ConfigWriter.writeElement(pp, "comparator", prop.getComparator().getClass().getName());
        }
        if (prop.getLowProbability() != 0.0) {
            ConfigWriter.writeElement(pp, "low", "" + prop.getLowProbability());
        }
        if (prop.getHighProbability() != 0.0) {
            ConfigWriter.writeElement(pp, "high", "" + prop.getHighProbability());
        }
        pp.endElement("property");
    }

    private static void writeDataSource(XMLPrettyPrinter pp, DataSource src) {
        String name = null;
        if (src instanceof JNDIDataSource) {
            name = "jndi";
            JNDIDataSource jndi = (JNDIDataSource)src;
            pp.startElement(name, null);
            ConfigWriter.writeParam(pp, "jndi-path", jndi.getJndiPath());
            ConfigWriter.writeParam(pp, "query", jndi.getQuery());
        } else if (src instanceof JDBCDataSource) {
            name = "jdbc";
            JDBCDataSource jdbc = (JDBCDataSource)src;
            pp.startElement(name, null);
            ConfigWriter.writeParam(pp, "driver-class", jdbc.getDriverClass());
            ConfigWriter.writeParam(pp, "connection-string", jdbc.getConnectionString());
            ConfigWriter.writeParam(pp, "user-name", jdbc.getUserName());
            ConfigWriter.writeParam(pp, "password", jdbc.getPassword());
            ConfigWriter.writeParam(pp, "query", jdbc.getQuery());
        } else if (src instanceof CSVDataSource) {
            name = "csv";
            CSVDataSource csv = (CSVDataSource)src;
            pp.startElement(name, null);
            ConfigWriter.writeParam(pp, "input-file", csv.getInputFile());
            ConfigWriter.writeParam(pp, "encoding", csv.getEncoding());
            ConfigWriter.writeParam(pp, "skip-lines", csv.getSkipLines());
            ConfigWriter.writeParam(pp, "header-line", csv.getHeaderLine());
            if (csv.getSeparator() != '\u0000') {
                ConfigWriter.writeParam(pp, "separator", csv.getSeparator());
            }
        }
        if (src instanceof ColumnarDataSource) {
            for (Column col : ((ColumnarDataSource)src).getColumns()) {
                AttributeListImpl atts = new AttributeListImpl();
                atts.addAttribute("name", "CDATA", col.getName());
                atts.addAttribute("property", "CDATA", col.getProperty());
                if (col.getPrefix() != null) {
                    atts.addAttribute("prefix", "CDATA", col.getPrefix());
                }
                if (col.getCleaner() != null) {
                    atts.addAttribute("cleaner", "CDATA", col.getCleaner().getClass().getName());
                }
                pp.startElement("column", atts);
                pp.endElement("column");
            }
        }
        pp.endElement(name);
    }
}

