/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import jsr166y.ForkJoinPool;
import sun.misc.Unsafe;
import water.H2ORuntime;

public class Phaser {
    private volatile long state;
    private static final int MAX_PARTIES = 65535;
    private static final int MAX_PHASE = Integer.MAX_VALUE;
    private static final int PARTIES_SHIFT = 16;
    private static final int PHASE_SHIFT = 32;
    private static final int UNARRIVED_MASK = 65535;
    private static final long PARTIES_MASK = 0xFFFF0000L;
    private static final long COUNTS_MASK = 0xFFFFFFFFL;
    private static final long TERMINATION_BIT = Long.MIN_VALUE;
    private static final int ONE_ARRIVAL = 1;
    private static final int ONE_PARTY = 65536;
    private static final int ONE_DEREGISTER = 65537;
    private static final int EMPTY = 1;
    private final Phaser parent;
    private final Phaser root;
    private final AtomicReference<QNode> evenQ;
    private final AtomicReference<QNode> oddQ;
    private static final int NCPU = H2ORuntime.availableProcessors();
    static final int SPINS_PER_ARRIVAL = NCPU < 2 ? 1 : 256;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;

    private static int unarrivedOf(long s2) {
        int counts = (int)s2;
        return counts == 1 ? 0 : counts & 0xFFFF;
    }

    private static int partiesOf(long s2) {
        return (int)s2 >>> 16;
    }

    private static int phaseOf(long s2) {
        return (int)(s2 >>> 32);
    }

    private static int arrivedOf(long s2) {
        int counts = (int)s2;
        return counts == 1 ? 0 : (counts >>> 16) - (counts & 0xFFFF);
    }

    private AtomicReference<QNode> queueFor(int phase) {
        return (phase & 1) == 0 ? this.evenQ : this.oddQ;
    }

    private String badArrive(long s2) {
        return "Attempted arrival of unregistered party for " + this.stateToString(s2);
    }

    private String badRegister(long s2) {
        return "Attempt to register more than 65535 parties for " + this.stateToString(s2);
    }

    private int doArrive(int adjust) {
        int unarrived;
        int phase;
        long s2;
        Phaser root = this.root;
        do {
            if ((phase = (int)((s2 = root == this ? this.state : this.reconcileState()) >>> 32)) < 0) {
                return phase;
            }
            int counts = (int)s2;
            int n2 = unarrived = counts == 1 ? 0 : counts & 0xFFFF;
            if (unarrived > 0) continue;
            throw new IllegalStateException(this.badArrive(s2));
        } while (!UNSAFE.compareAndSwapLong(this, stateOffset, s2, s2 -= (long)adjust));
        if (unarrived == 1) {
            long n3 = s2 & 0xFFFF0000L;
            int nextUnarrived = (int)n3 >>> 16;
            if (root == this) {
                n3 = this.onAdvance(phase, nextUnarrived) ? (n3 |= Long.MIN_VALUE) : (nextUnarrived == 0 ? (n3 |= 1L) : (n3 |= (long)nextUnarrived));
                int nextPhase = phase + 1 & Integer.MAX_VALUE;
                UNSAFE.compareAndSwapLong(this, stateOffset, s2, n3 |= (long)nextPhase << 32);
                this.releaseWaiters(phase);
            } else if (nextUnarrived == 0) {
                phase = this.parent.doArrive(65537);
                UNSAFE.compareAndSwapLong(this, stateOffset, s2, s2 | 1L);
            } else {
                phase = this.parent.doArrive(1);
            }
        }
        return phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRegister(int registrations) {
        int phase;
        long adjust = (long)registrations << 16 | (long)registrations;
        Phaser parent = this.parent;
        while (true) {
            long s2 = parent == null ? this.state : this.reconcileState();
            int counts = (int)s2;
            int parties = counts >>> 16;
            int unarrived = counts & 0xFFFF;
            if (registrations > 65535 - parties) {
                throw new IllegalStateException(this.badRegister(s2));
            }
            phase = (int)(s2 >>> 32);
            if (phase < 0) break;
            if (counts != 1) {
                if (parent != null && this.reconcileState() != s2) continue;
                if (unarrived == 0) {
                    this.root.internalAwaitAdvance(phase, null);
                    continue;
                }
                if (!UNSAFE.compareAndSwapLong(this, stateOffset, s2, s2 + adjust)) continue;
                break;
            }
            if (parent == null) {
                long next = (long)phase << 32 | adjust;
                if (!UNSAFE.compareAndSwapLong(this, stateOffset, s2, next)) continue;
                break;
            }
            Phaser phaser = this;
            synchronized (phaser) {
                if (this.state == s2) {
                    phase = parent.doRegister(1);
                    if (phase < 0) {
                        break;
                    }
                    while (!UNSAFE.compareAndSwapLong(this, stateOffset, s2, (long)phase << 32 | adjust)) {
                        s2 = this.state;
                        phase = (int)(this.root.state >>> 32);
                    }
                    break;
                }
            }
        }
        return phase;
    }

    private long reconcileState() {
        Phaser root = this.root;
        long s2 = this.state;
        if (root != this) {
            int phase;
            while ((phase = (int)(root.state >>> 32)) != (int)(s2 >>> 32)) {
                int p2;
                if (UNSAFE.compareAndSwapLong(this, stateOffset, s2, s2 = (long)phase << 32 | (phase < 0 ? s2 & 0xFFFFFFFFL : ((p2 = (int)s2 >>> 16) == 0 ? 1L : s2 & 0xFFFF0000L | (long)p2)))) break;
                s2 = this.state;
            }
        }
        return s2;
    }

    public Phaser() {
        this(null, 0);
    }

    public Phaser(int parties) {
        this(null, parties);
    }

    public Phaser(Phaser parent) {
        this(parent, 0);
    }

    public Phaser(Phaser parent, int parties) {
        if (parties >>> 16 != 0) {
            throw new IllegalArgumentException("Illegal number of parties");
        }
        int phase = 0;
        this.parent = parent;
        if (parent != null) {
            Phaser root;
            this.root = root = parent.root;
            this.evenQ = root.evenQ;
            this.oddQ = root.oddQ;
            if (parties != 0) {
                phase = parent.doRegister(1);
            }
        } else {
            this.root = this;
            this.evenQ = new AtomicReference();
            this.oddQ = new AtomicReference();
        }
        this.state = parties == 0 ? 1L : (long)phase << 32 | (long)parties << 16 | (long)parties;
    }

    public int register() {
        return this.doRegister(1);
    }

    public int bulkRegister(int parties) {
        if (parties < 0) {
            throw new IllegalArgumentException();
        }
        if (parties == 0) {
            return this.getPhase();
        }
        return this.doRegister(parties);
    }

    public int arrive() {
        return this.doArrive(1);
    }

    public int arriveAndDeregister() {
        return this.doArrive(65537);
    }

    public int arriveAndAwaitAdvance() {
        int unarrived;
        int phase;
        long s2;
        Phaser root = this.root;
        do {
            if ((phase = (int)((s2 = root == this ? this.state : this.reconcileState()) >>> 32)) < 0) {
                return phase;
            }
            int counts = (int)s2;
            int n2 = unarrived = counts == 1 ? 0 : counts & 0xFFFF;
            if (unarrived > 0) continue;
            throw new IllegalStateException(this.badArrive(s2));
        } while (!UNSAFE.compareAndSwapLong(this, stateOffset, s2--, s2));
        if (unarrived > 1) {
            return root.internalAwaitAdvance(phase, null);
        }
        if (root != this) {
            return this.parent.arriveAndAwaitAdvance();
        }
        long n3 = s2 & 0xFFFF0000L;
        int nextUnarrived = (int)n3 >>> 16;
        n3 = this.onAdvance(phase, nextUnarrived) ? (n3 |= Long.MIN_VALUE) : (nextUnarrived == 0 ? (n3 |= 1L) : (n3 |= (long)nextUnarrived));
        int nextPhase = phase + 1 & Integer.MAX_VALUE;
        if (!UNSAFE.compareAndSwapLong(this, stateOffset, s2, n3 |= (long)nextPhase << 32)) {
            return (int)(this.state >>> 32);
        }
        this.releaseWaiters(phase);
        return nextPhase;
    }

    public int awaitAdvance(int phase) {
        Phaser root = this.root;
        long s2 = root == this ? this.state : this.reconcileState();
        int p2 = (int)(s2 >>> 32);
        if (phase < 0) {
            return phase;
        }
        if (p2 == phase) {
            return root.internalAwaitAdvance(phase, null);
        }
        return p2;
    }

    public int awaitAdvanceInterruptibly(int phase) throws InterruptedException {
        Phaser root = this.root;
        long s2 = root == this ? this.state : this.reconcileState();
        int p2 = (int)(s2 >>> 32);
        if (phase < 0) {
            return phase;
        }
        if (p2 == phase) {
            QNode node = new QNode(this, phase, true, false, 0L);
            p2 = root.internalAwaitAdvance(phase, node);
            if (node.wasInterrupted) {
                throw new InterruptedException();
            }
        }
        return p2;
    }

    public int awaitAdvanceInterruptibly(int phase, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        Phaser root = this.root;
        long s2 = root == this ? this.state : this.reconcileState();
        int p2 = (int)(s2 >>> 32);
        if (phase < 0) {
            return phase;
        }
        if (p2 == phase) {
            QNode node = new QNode(this, phase, true, true, nanos);
            p2 = root.internalAwaitAdvance(phase, node);
            if (node.wasInterrupted) {
                throw new InterruptedException();
            }
            if (p2 == phase) {
                throw new TimeoutException();
            }
        }
        return p2;
    }

    public void forceTermination() {
        long s2;
        Phaser root = this.root;
        while ((s2 = root.state) >= 0L) {
            if (!UNSAFE.compareAndSwapLong(root, stateOffset, s2, s2 | Long.MIN_VALUE)) continue;
            this.releaseWaiters(0);
            this.releaseWaiters(1);
            return;
        }
    }

    public final int getPhase() {
        return (int)(this.root.state >>> 32);
    }

    public int getRegisteredParties() {
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        return Phaser.arrivedOf(this.reconcileState());
    }

    public int getUnarrivedParties() {
        return Phaser.unarrivedOf(this.reconcileState());
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        return this.root.state < 0L;
    }

    protected boolean onAdvance(int phase, int registeredParties) {
        return registeredParties == 0;
    }

    public String toString() {
        return this.stateToString(this.reconcileState());
    }

    private String stateToString(long s2) {
        return super.toString() + "[phase = " + Phaser.phaseOf(s2) + " parties = " + Phaser.partiesOf(s2) + " arrived = " + Phaser.arrivedOf(s2) + "]";
    }

    private void releaseWaiters(int phase) {
        QNode q2;
        AtomicReference<QNode> head;
        AtomicReference<QNode> atomicReference = head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
        while ((q2 = head.get()) != null && q2.phase != (int)(this.root.state >>> 32)) {
            Thread t2;
            if (!head.compareAndSet(q2, q2.next) || (t2 = q2.thread) == null) continue;
            q2.thread = null;
            LockSupport.unpark(t2);
        }
    }

    private int abortWait(int phase) {
        AtomicReference<QNode> head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
        while (true) {
            Thread t2;
            QNode q2 = head.get();
            int p2 = (int)(this.root.state >>> 32);
            if (q2 == null || (t2 = q2.thread) != null && q2.phase == p2) {
                return p2;
            }
            if (!head.compareAndSet(q2, q2.next) || t2 == null) continue;
            q2.thread = null;
            LockSupport.unpark(t2);
        }
    }

    private int internalAwaitAdvance(int phase, QNode node) {
        long s2;
        int p2;
        this.releaseWaiters(phase - 1);
        boolean queued = false;
        int lastUnarrived = 0;
        int spins = SPINS_PER_ARRIVAL;
        while ((p2 = (int)((s2 = this.state) >>> 32)) == phase) {
            if (node == null) {
                boolean interrupted;
                int unarrived = (int)s2 & 0xFFFF;
                if (unarrived != lastUnarrived && (lastUnarrived = unarrived) < NCPU) {
                    spins += SPINS_PER_ARRIVAL;
                }
                if (!(interrupted = Thread.interrupted()) && --spins >= 0) continue;
                node = new QNode(this, phase, false, false, 0L);
                node.wasInterrupted = interrupted;
                continue;
            }
            if (node.isReleasable()) break;
            if (!queued) {
                AtomicReference<QNode> head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
                node.next = head.get();
                QNode q2 = node.next;
                if (q2 != null && q2.phase != phase || (int)(this.state >>> 32) != phase) continue;
                queued = head.compareAndSet(q2, node);
                continue;
            }
            try {
                ForkJoinPool.managedBlock(node);
            }
            catch (InterruptedException ie) {
                node.wasInterrupted = true;
            }
        }
        if (node != null) {
            if (node.thread != null) {
                node.thread = null;
            }
            if (node.wasInterrupted && !node.interruptible) {
                Thread.currentThread().interrupt();
            }
            if (p2 == phase && (p2 = (int)(this.state >>> 32)) == phase) {
                return this.abortWait(phase);
            }
        }
        this.releaseWaiters(phase);
        return p2;
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
                        f2.setAccessible(true);
                        return (Unsafe)f2.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e2) {
                throw new RuntimeException("Could not initialize intrinsics", e2.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = Phaser.getUnsafe();
            Class<Phaser> k2 = Phaser.class;
            stateOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("state"));
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
    }

    static final class QNode
    implements ForkJoinPool.ManagedBlocker {
        final Phaser phaser;
        final int phase;
        final boolean interruptible;
        final boolean timed;
        boolean wasInterrupted;
        long nanos;
        long lastTime;
        volatile Thread thread;
        QNode next;

        QNode(Phaser phaser, int phase, boolean interruptible, boolean timed, long nanos) {
            this.phaser = phaser;
            this.phase = phase;
            this.interruptible = interruptible;
            this.nanos = nanos;
            this.timed = timed;
            this.lastTime = timed ? System.nanoTime() : 0L;
            this.thread = Thread.currentThread();
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (this.phaser.getPhase() != this.phase) {
                this.thread = null;
                return true;
            }
            if (Thread.interrupted()) {
                this.wasInterrupted = true;
            }
            if (this.wasInterrupted && this.interruptible) {
                this.thread = null;
                return true;
            }
            if (this.timed) {
                if (this.nanos > 0L) {
                    long now = System.nanoTime();
                    this.nanos -= now - this.lastTime;
                    this.lastTime = now;
                }
                if (this.nanos <= 0L) {
                    this.thread = null;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean block() {
            if (this.isReleasable()) {
                return true;
            }
            if (!this.timed) {
                LockSupport.park(this);
            } else if (this.nanos > 0L) {
                LockSupport.parkNanos(this, this.nanos);
            }
            return this.isReleasable();
        }
    }
}

