/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;

public class StructByReferenceFromNativeConverter
implements FromNativeConverter<Struct, Pointer> {
    private final Constructor<? extends Struct> constructor;

    public static FromNativeConverter<Struct, Pointer> getInstance(Class structClass, FromNativeContext toNativeContext) {
        try {
            return new StructByReferenceFromNativeConverter(structClass.getConstructor(Runtime.class));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(structClass.getName() + " has no constructor that accepts jnr.ffi.Runtime");
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
    }

    StructByReferenceFromNativeConverter(Constructor<? extends Struct> constructor) {
        this.constructor = constructor;
    }

    @Override
    public Struct fromNative(Pointer nativeValue, FromNativeContext context) {
        try {
            Struct s2 = this.constructor.newInstance(context.getRuntime());
            s2.useMemory(nativeValue);
            return s2;
        }
        catch (InstantiationException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new RuntimeException(e4);
        }
    }

    @Override
    public Class<Pointer> nativeType() {
        return Pointer.class;
    }
}

