/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.propagation;

import io.opencensus.internal.Utils;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.propagation.SpanContextParseException;
import java.text.ParseException;

public abstract class BinaryFormat {
    static final NoopBinaryFormat NOOP_BINARY_FORMAT = new NoopBinaryFormat();

    @Deprecated
    public byte[] toBinaryValue(SpanContext spanContext) {
        return this.toByteArray(spanContext);
    }

    public byte[] toByteArray(SpanContext spanContext) {
        return this.toBinaryValue(spanContext);
    }

    @Deprecated
    public SpanContext fromBinaryValue(byte[] bytes) throws ParseException {
        try {
            return this.fromByteArray(bytes);
        }
        catch (SpanContextParseException e2) {
            throw new ParseException(e2.toString(), 0);
        }
    }

    public SpanContext fromByteArray(byte[] bytes) throws SpanContextParseException {
        try {
            return this.fromBinaryValue(bytes);
        }
        catch (ParseException e2) {
            throw new SpanContextParseException("Error while parsing.", e2);
        }
    }

    static BinaryFormat getNoopBinaryFormat() {
        return NOOP_BINARY_FORMAT;
    }

    private static final class NoopBinaryFormat
    extends BinaryFormat {
        @Override
        public byte[] toByteArray(SpanContext spanContext) {
            Utils.checkNotNull(spanContext, "spanContext");
            return new byte[0];
        }

        @Override
        public SpanContext fromByteArray(byte[] bytes) {
            Utils.checkNotNull(bytes, "bytes");
            return SpanContext.INVALID;
        }

        private NoopBinaryFormat() {
        }
    }
}

