/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.remote;

import hex.genmodel.utils.IOUtils;
import hex.schemas.XGBoostExecReqV3;
import hex.schemas.XGBoostExecRespV3;
import hex.tree.xgboost.exec.LocalXGBoostExecutor;
import hex.tree.xgboost.exec.XGBoostExecReq;
import hex.tree.xgboost.remote.XGBoostExecutorRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import water.BootstrapFreezable;
import water.H2O;
import water.Iced;
import water.TypeMap;
import water.api.Handler;
import water.api.StreamingSchema;

public class RemoteXGBoostHandler
extends Handler {
    private static final Logger LOG = Logger.getLogger(RemoteXGBoostHandler.class);

    private XGBoostExecRespV3 makeResponse(LocalXGBoostExecutor exec) {
        return new XGBoostExecRespV3(exec.modelKey);
    }

    public XGBoostExecRespV3 init(int ignored, XGBoostExecReqV3 req) {
        XGBoostExecReq.Init init = (XGBoostExecReq.Init)req.readData();
        LocalXGBoostExecutor exec = new LocalXGBoostExecutor(req.key.key(), init);
        XGBoostExecutorRegistry.storeExecutor(exec);
        return new XGBoostExecRespV3(exec.modelKey, this.collectNodes());
    }

    private RemoteExecutors collectNodes() {
        String[] nodes = new String[H2O.CLOUD.size()];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            nodes[i2] = H2O.CLOUD.members()[i2].getIpPortString();
        }
        return new RemoteExecutors(nodes);
    }

    public StreamingSchema setup(int ignored, XGBoostExecReqV3 req) {
        LocalXGBoostExecutor exec = XGBoostExecutorRegistry.getExecutor(req);
        byte[] booster = exec.setup();
        return this.streamBytes(booster);
    }

    public XGBoostExecRespV3 update(int ignored, XGBoostExecReqV3 req) {
        LocalXGBoostExecutor exec = XGBoostExecutorRegistry.getExecutor(req);
        XGBoostExecReq.Update update = (XGBoostExecReq.Update)req.readData();
        exec.update(update.treeId);
        return this.makeResponse(exec);
    }

    public StreamingSchema getBooster(int ignored, XGBoostExecReqV3 req) {
        LocalXGBoostExecutor exec = XGBoostExecutorRegistry.getExecutor(req);
        byte[] booster = exec.updateBooster();
        return this.streamBytes(booster);
    }

    public XGBoostExecRespV3 cleanup(int ignored, XGBoostExecReqV3 req) {
        LocalXGBoostExecutor exec = XGBoostExecutorRegistry.getExecutor(req);
        exec.close();
        XGBoostExecutorRegistry.removeExecutor(exec);
        return this.makeResponse(exec);
    }

    private StreamingSchema streamBytes(byte[] data) {
        byte[] dataToSend = data == null ? new byte[]{} : data;
        return new StreamingSchema((os2, options) -> {
            try {
                IOUtils.copyStream(new ByteArrayInputStream(dataToSend), os2);
            }
            catch (IOException e2) {
                LOG.error((Object)"Failed writing data to response.", (Throwable)e2);
                throw new RuntimeException("Failed writing data to response.", e2);
            }
        });
    }

    public static class RemoteExecutors
    extends Iced<RemoteExecutors>
    implements BootstrapFreezable<RemoteExecutors> {
        public final String[] _nodes;
        public final String[] _typeMap;

        public RemoteExecutors(String[] nodes) {
            this._nodes = nodes;
            this._typeMap = TypeMap.bootstrapClasses();
        }
    }
}

