/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.predict;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.gbm.GBTree;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeNode;
import biz.k11i.xgboost.tree.RegTreeNodeStat;
import hex.DataInfo;
import hex.tree.xgboost.XGBoostModelInfo;
import hex.tree.xgboost.XGBoostUtils;
import hex.tree.xgboost.predict.PredictorFactory;
import hex.tree.xgboost.predict.XGBoostVariableImportance;
import hex.tree.xgboost.util.FeatureScore;
import java.util.HashMap;
import java.util.Map;

public class XGBoostJavaVariableImportance
implements XGBoostVariableImportance {
    private final String[] _featureNames;

    public XGBoostJavaVariableImportance(XGBoostModelInfo modelInfo) {
        this._featureNames = XGBoostUtils.assembleFeatureNames((DataInfo)modelInfo.dataInfo())._names;
    }

    @Override
    public Map<String, FeatureScore> getFeatureScores(byte[] boosterBytes) {
        RegTree[][] trees;
        Predictor predictor = PredictorFactory.makePredictor(boosterBytes, null, false);
        HashMap<String, FeatureScore> featureScore = new HashMap<String, FeatureScore>();
        if (!(predictor.getBooster() instanceof GBTree)) {
            return featureScore;
        }
        GBTree gbm = (GBTree)predictor.getBooster();
        for (RegTree[] treeGroup : trees = gbm.getGroupedTrees()) {
            for (int j2 = 0; j2 < treeGroup.length; ++j2) {
                RegTree t2 = treeGroup[j2];
                for (int k2 = 0; k2 < t2.getNodes().length; ++k2) {
                    RegTreeNode node = t2.getNodes()[k2];
                    if (node.isLeaf()) continue;
                    RegTreeNodeStat stat = t2.getStats()[k2];
                    FeatureScore fs = new FeatureScore();
                    fs._gain = stat.getGain();
                    fs._cover = stat.getCover();
                    String fid = this._featureNames[node.getSplitIndex()];
                    if (featureScore.containsKey(fid)) {
                        ((FeatureScore)featureScore.get(fid)).add(fs);
                        continue;
                    }
                    featureScore.put(fid, fs);
                }
            }
        }
        return featureScore;
    }
}

