/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import ai.h2o.xgboost4j.java.DMatrix;
import ai.h2o.xgboost4j.java.XGBoostError;
import ai.h2o.xgboost4j.java.util.BigDenseMatrix;
import hex.DataInfo;
import hex.tree.xgboost.matrix.MatrixFactoryUtils;
import hex.tree.xgboost.matrix.MatrixLoader;
import java.util.Objects;
import org.apache.log4j.Logger;
import water.H2O;
import water.LocalMR;
import water.MrFun;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class DenseMatrixFactory {
    private static final Logger LOG = Logger.getLogger(DenseMatrixFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMatrix dense(Chunk[] chunks, DataInfo di, int respIdx, float[] resp, float[] weights, int offsetIdx, float[] offsets) throws XGBoostError {
        LOG.debug((Object)"Treating matrix as dense.");
        BigDenseMatrix data = null;
        try {
            data = DenseMatrixFactory.allocateDenseMatrix(chunks[0].len(), di);
            long actualRows = DenseMatrixFactory.denseChunk(data, chunks, respIdx, di, resp, weights, offsetIdx, offsets);
            assert (actualRows == (long)data.nrow);
            DMatrix dMatrix = new DMatrix(data, Float.NaN);
            return dMatrix;
        }
        finally {
            if (data != null) {
                data.dispose();
            }
        }
    }

    public static DenseDMatrixProvider dense(Frame f2, int[] chunks, int nRows, int[] nRowsByChunk, Vec weightVec, Vec offsetVec, Vec responseVec, DataInfo di, float[] resp, float[] weights, float[] offsets) {
        BigDenseMatrix data = null;
        try {
            data = DenseMatrixFactory.allocateDenseMatrix(nRows, di);
            int actualRows = DenseMatrixFactory.denseChunk(data, chunks, nRowsByChunk, f2, weightVec, offsetVec, responseVec, di, resp, weights, offsets);
            assert (data.nrow == actualRows);
            return new DenseDMatrixProvider(actualRows, resp, weights, offsets, data);
        }
        catch (Exception e2) {
            if (data != null) {
                data.dispose();
            }
            throw new RuntimeException("Error while create off-heap matrix.", e2);
        }
    }

    private static int denseChunk(BigDenseMatrix data, int[] chunks, int[] nRowsByChunk, Frame f2, Vec weightsVec, Vec offsetVec, Vec respVec, DataInfo di, float[] resp, float[] weights, float[] offsets) {
        int[] rowOffsets = new int[nRowsByChunk.length + 1];
        for (int i2 = 0; i2 < chunks.length; ++i2) {
            rowOffsets[i2 + 1] = nRowsByChunk[i2] + rowOffsets[i2];
        }
        WriteDenseChunkFun writeFun = new WriteDenseChunkFun(f2, chunks, rowOffsets, weightsVec, offsetVec, respVec, di, data, resp, weights, offsets);
        H2O.submitTask(new LocalMR((MrFun)writeFun, chunks.length)).join();
        return writeFun.getTotalRows();
    }

    private static long denseChunk(BigDenseMatrix data, Chunk[] chunks, int respIdx, DataInfo di, float[] resp, float[] weights, int offsetIdx, float[] offsets) {
        long idx = 0L;
        long actualRows = 0L;
        int rwRow = 0;
        for (int i2 = 0; i2 < chunks[0]._len; ++i2) {
            idx = DenseMatrixFactory.writeDenseRow(di, chunks, i2, data, idx);
            ++actualRows;
            rwRow = MatrixFactoryUtils.setResponseAndWeightAndOffset(chunks, respIdx, -1, offsetIdx, resp, weights, offsets, rwRow, i2);
        }
        assert ((long)data.nrow * (long)data.ncol == idx);
        return actualRows;
    }

    private static long writeDenseRow(DataInfo di, Chunk[] chunks, int rowInChunk, BigDenseMatrix data, long idx) {
        int j2;
        for (j2 = 0; j2 < di._cats; ++j2) {
            int len = di._catOffsets[j2 + 1] - di._catOffsets[j2];
            double val = chunks[j2].isNA(rowInChunk) ? Double.NaN : (double)chunks[j2].at8(rowInChunk);
            int pos = di.getCategoricalId(j2, val) - di._catOffsets[j2];
            for (int cat = 0; cat < len; ++cat) {
                data.set(idx + (long)cat, 0.0f);
            }
            data.set(idx + (long)pos, 1.0f);
            idx += (long)len;
        }
        for (j2 = 0; j2 < di._nums; ++j2) {
            float val = chunks[di._cats + j2].isNA(rowInChunk) ? Float.NaN : (float)chunks[di._cats + j2].atd(rowInChunk);
            data.set(idx++, val);
        }
        return idx;
    }

    private static BigDenseMatrix allocateDenseMatrix(int rowCount, DataInfo dataInfo) {
        return new BigDenseMatrix(rowCount, dataInfo.fullN());
    }

    private static class WriteDenseChunkFun
    extends MrFun<WriteDenseChunkFun> {
        private final Frame _f;
        private final int[] _chunks;
        private final int[] _rowOffsets;
        private final Vec _weightsVec;
        private final Vec _offsetsVec;
        private final Vec _respVec;
        private final DataInfo _di;
        private final BigDenseMatrix _data;
        private final float[] _resp;
        private final float[] _weights;
        private final float[] _offsets;
        private final int[] _nRowsByChunk;

        private WriteDenseChunkFun(Frame f2, int[] chunks, int[] rowOffsets, Vec weightsVec, Vec offsetsVec, Vec respVec, DataInfo di, BigDenseMatrix data, float[] resp, float[] weights, float[] offsets) {
            this._f = f2;
            this._chunks = chunks;
            this._rowOffsets = rowOffsets;
            this._weightsVec = weightsVec;
            this._offsetsVec = offsetsVec;
            this._respVec = respVec;
            this._di = di;
            this._data = data;
            this._resp = resp;
            this._weights = weights;
            this._offsets = offsets;
            this._nRowsByChunk = new int[chunks.length];
        }

        @Override
        protected void map(int id) {
            int chunkIdx = this._chunks[id];
            Chunk[] chks = new Chunk[this._f.numCols()];
            for (int c2 = 0; c2 < chks.length; ++c2) {
                chks[c2] = this._f.vec(c2).chunkForChunkIdx(chunkIdx);
            }
            Chunk weightsChk = this._weightsVec != null ? this._weightsVec.chunkForChunkIdx(chunkIdx) : null;
            Chunk offsetsChk = this._offsetsVec != null ? this._offsetsVec.chunkForChunkIdx(chunkIdx) : null;
            Chunk respChk = this._respVec.chunkForChunkIdx(chunkIdx);
            long idx = this._rowOffsets[id] * this._data.ncol;
            int actualRows = 0;
            for (int i2 = 0; i2 < chks[0]._len; ++i2) {
                if (weightsChk != null && weightsChk.atd(i2) == 0.0) continue;
                idx = DenseMatrixFactory.writeDenseRow(this._di, chks, i2, this._data, idx);
                this._resp[this._rowOffsets[id] + actualRows] = (float)respChk.atd(i2);
                if (weightsChk != null) {
                    this._weights[this._rowOffsets[id] + actualRows] = (float)weightsChk.atd(i2);
                }
                if (offsetsChk != null) {
                    this._offsets[this._rowOffsets[id] + actualRows] = (float)offsetsChk.atd(i2);
                }
                ++actualRows;
            }
            assert (idx == (long)this._rowOffsets[id + 1] * (long)this._data.ncol);
            this._nRowsByChunk[id] = actualRows;
        }

        private int getTotalRows() {
            int totalRows = 0;
            for (int r2 : this._nRowsByChunk) {
                totalRows += r2;
            }
            return totalRows;
        }
    }

    public static class DenseDMatrixProvider
    extends MatrixLoader.DMatrixProvider {
        private BigDenseMatrix data;

        protected DenseDMatrixProvider(long actualRows, float[] response, float[] weights, float[] offsets, BigDenseMatrix data) {
            super(actualRows, response, weights, offsets);
            this.data = data;
        }

        @Override
        public void print(int nrow) {
            for (int i2 = 0; i2 < (nrow > 0 ? nrow : this.data.nrow); ++i2) {
                System.out.print(i2 + ":");
                for (int j2 = 0; j2 < this.data.ncol; ++j2) {
                    System.out.print(this.data.get(i2, j2) + ", ");
                }
                System.out.print(this.response[i2]);
                System.out.println();
            }
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            if (!super.equals(o2)) {
                return false;
            }
            DenseDMatrixProvider that = (DenseDMatrixProvider)o2;
            if (that.data.ncol != this.data.ncol || that.data.nrow != this.data.nrow) {
                return false;
            }
            for (int i2 = 0; i2 < this.data.nrow; ++i2) {
                for (int j2 = 0; j2 < this.data.ncol; ++j2) {
                    if (this.data.get(i2, j2) == that.data.get(i2, j2)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + Objects.hash(this.data);
        }

        @Override
        public DMatrix makeDMatrix() throws XGBoostError {
            return new DMatrix(this.data, Float.NaN);
        }

        @Override
        protected void dispose() {
            if (this.data != null) {
                this.data.dispose();
                this.data = null;
            }
        }
    }
}

