/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.CVModelBuilder;
import hex.ModelBuilder;
import hex.tree.xgboost.XGBoost;
import hex.tree.xgboost.remote.SteamExecutorStarter;
import java.io.IOException;
import org.apache.log4j.Logger;
import water.Job;

public class XGBoostExternalCVModelBuilder
extends CVModelBuilder {
    private static final Logger LOG = Logger.getLogger(XGBoostExternalCVModelBuilder.class);
    private final SteamExecutorStarter _starter;
    private boolean _initialized;

    public XGBoostExternalCVModelBuilder(Job job, ModelBuilder<?, ?, ?>[] modelBuilders, int parallelization, SteamExecutorStarter starter) {
        super(job, modelBuilders, parallelization);
        this._starter = starter;
    }

    @Override
    protected void prepare(ModelBuilder<?, ?, ?> m4) {
        if (!this._initialized) {
            XGBoost xgb = (XGBoost)m4;
            try {
                this.prepareCluster(xgb);
            }
            catch (Exception e2) {
                LOG.error((Object)"Failed to prepare an external XGBoost cluster, individual CV models will attempt to start the cluster again.", (Throwable)e2);
            }
            this._initialized = true;
        }
    }

    void prepareCluster(XGBoost xgb) {
        LOG.info((Object)("Requesting external cluster for model " + xgb.dest()));
        try {
            this._starter.startCluster(xgb.dest(), this.getJob());
        }
        catch (IOException e2) {
            throw new IllegalStateException("Failed to start external XGBoost cluster", e2);
        }
        LOG.info((Object)"External cluster successfully initialized");
    }
}

