/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended.isolationtree;

import hex.tree.isoforextended.isolationtree.AbstractCompressedNode;
import hex.tree.isoforextended.isolationtree.IsolationTree;
import java.util.Arrays;
import water.AutoBuffer;

public class CompressedNode
extends AbstractCompressedNode {
    private final double[] _n;
    private final double[] _p;

    public CompressedNode(IsolationTree.Node node) {
        this(node.getN(), node.getP(), node.getHeight());
    }

    public CompressedNode(double[] n2, double[] p2, int currentHeight) {
        super(currentHeight);
        this._n = n2 == null ? null : Arrays.copyOf(n2, n2.length);
        this._p = p2 == null ? null : Arrays.copyOf(p2, p2.length);
    }

    public double[] getN() {
        return this._n;
    }

    public double[] getP() {
        return this._p;
    }

    @Override
    public void toBytes(AutoBuffer ab) {
        ab.put1(78);
        for (double v2 : this._n) {
            ab.put8d(v2);
        }
        for (double v2 : this._p) {
            ab.put8d(v2);
        }
    }
}

