/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.ModelMojoWriter;
import hex.glm.GLMModel;
import hex.tree.CompressedTree;
import hex.tree.SharedTreeModel;
import java.io.IOException;
import water.DKV;
import water.Key;
import water.Value;

public abstract class SharedTreeMojoWriter<M extends SharedTreeModel<M, P, O>, P extends SharedTreeModel.SharedTreeParameters, O extends SharedTreeModel.SharedTreeOutput>
extends ModelMojoWriter<M, P, O> {
    public SharedTreeMojoWriter() {
    }

    public SharedTreeMojoWriter(M model) {
        super(model);
    }

    @Override
    protected void writeModelData() throws IOException {
        assert (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeys.length == ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees);
        int nclasses = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output).nclasses();
        int ntreesPerClass = ((SharedTreeModel)this.model).binomialOpt() && nclasses == 2 ? 1 : nclasses;
        this.writekv("n_trees", ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees);
        this.writekv("n_trees_per_class", ntreesPerClass);
        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._calib_model != null) {
            GLMModel calibModel = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._calib_model;
            double[] beta = calibModel.beta();
            assert (beta.length == nclasses);
            this.writekv("calib_method", "platt");
            this.writekv("calib_glm_beta", beta);
        }
        this.writekv("_genmodel_encoding", (Object)((SharedTreeModel)this.model).getGenModelEncoding());
        String[] origNames = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origNames;
        if (origNames != null) {
            int nOrigNames = origNames.length;
            this.writekv("_n_orig_names", nOrigNames);
            this.writeStringArray(origNames, "_orig_names");
        }
        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origDomains != null) {
            int nOrigDomainValues = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origDomains.length;
            this.writekv("_n_orig_domain_values", nOrigDomainValues);
            for (int i2 = 0; i2 < nOrigDomainValues; ++i2) {
                String[] currOrigDomain = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origDomains[i2];
                this.writekv("_m_orig_domain_values_" + i2, currOrigDomain == null ? 0 : currOrigDomain.length);
                if (currOrigDomain == null) continue;
                this.writeStringArray(currOrigDomain, "_orig_domain_values_" + i2);
            }
        }
        this.writekv("_orig_projection_array", ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._orig_projection_array);
        for (int i3 = 0; i3 < ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees; ++i3) {
            for (int j2 = 0; j2 < ntreesPerClass; ++j2) {
                Value ctVal;
                Key<CompressedTree> key = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeys[i3][j2];
                Value value = ctVal = key != null ? DKV.get(key) : null;
                if (ctVal == null) continue;
                CompressedTree ct = (CompressedTree)ctVal.get();
                this.writeblob(String.format("trees/t%02d_%03d.bin", j2, i3), ct._bits);
                if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeysAux == null) continue;
                key = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeysAux[i3][j2];
                Value value2 = ctVal = key != null ? DKV.get(key) : null;
                if (ctVal == null) continue;
                ct = (CompressedTree)ctVal.get();
                this.writeblob(String.format("trees/t%02d_%03d_aux.bin", j2, i3), ct._bits);
            }
        }
    }
}

