/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import hex.Model;
import hex.MultiModelMojoWriter;
import hex.rulefit.Condition;
import hex.rulefit.Rule;
import hex.rulefit.RuleEnsemble;
import hex.rulefit.RuleFitModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuleFitMojoWriter
extends MultiModelMojoWriter<RuleFitModel, RuleFitModel.RuleFitParameters, RuleFitModel.RuleFitOutput> {
    public RuleFitMojoWriter() {
    }

    public RuleFitMojoWriter(RuleFitModel model) {
        super(model);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }

    @Override
    protected List<Model> getSubModels() {
        if (((RuleFitModel)this.model).glmModel != null) {
            return Collections.singletonList(((RuleFitModel)this.model).glmModel);
        }
        return Collections.emptyList();
    }

    @Override
    protected void writeParentModelData() throws IOException {
        int i2;
        this.writekv("linear_model", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output).glmModelKey);
        if (!((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._model_type.equals((Object)RuleFitModel.ModelType.LINEAR)) {
            this.writeOrderedRuleEnsemble(((RuleFitModel)this.model).ruleEnsemble, ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._max_rule_length - ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._min_rule_length + 1, ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._rule_generation_ntrees, ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output).classNames());
        }
        if (((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._model_type.equals((Object)RuleFitModel.ModelType.LINEAR)) {
            this.writekv("model_type", 0);
        } else if (((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._model_type.equals((Object)RuleFitModel.ModelType.RULES_AND_LINEAR)) {
            this.writekv("model_type", 1);
        } else {
            this.writekv("model_type", 2);
        }
        this.writekv("type", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output).glmModelKey);
        this.writekv("depth", ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._max_rule_length - ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._min_rule_length + 1);
        this.writekv("ntrees", ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._rule_generation_ntrees);
        this.writekv("data_from_rules_codes_len", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._dataFromRulesCodes.length);
        for (i2 = 0; i2 < ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._dataFromRulesCodes.length; ++i2) {
            this.writekv("data_from_rules_codes_" + i2, ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._dataFromRulesCodes[i2]);
        }
        if (((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._weights_column != null) {
            this.writekv("weights_column", ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._weights_column);
        }
        this.writekv("linear_names_len", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._linear_names.length);
        for (i2 = 0; i2 < ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._linear_names.length; ++i2) {
            this.writekv("linear_names_" + i2, ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._linear_names[i2]);
        }
    }

    void writeOrderedRuleEnsemble(RuleEnsemble ruleEnsemble, int depth, int ntrees, String[] classes) throws IOException {
        for (int i2 = 0; i2 < depth; ++i2) {
            for (int j2 = 0; j2 < ntrees; ++j2) {
                int k2;
                String regex = "M" + i2 + "T" + j2 + "N\\d+";
                int nclasses = classes != null && classes.length > 2 ? classes.length : 1;
                String[] classRegex = new String[nclasses];
                ArrayList[] filteredClassRules = new ArrayList[nclasses];
                ArrayList filteredRules = new ArrayList();
                for (k2 = 0; k2 < nclasses; ++k2) {
                    classRegex[k2] = nclasses > 2 ? regex + "_" + classes[k2] : regex;
                }
                for (k2 = 0; k2 < nclasses; ++k2) {
                    for (int l2 = 0; l2 < ruleEnsemble.rules.length; ++l2) {
                        if (!ruleEnsemble.rules[l2].varName.matches(classRegex[k2])) continue;
                        if (filteredClassRules[k2] == null) {
                            filteredClassRules[k2] = new ArrayList();
                        }
                        filteredClassRules[k2].add(ruleEnsemble.rules[l2]);
                    }
                    filteredRules.addAll(filteredClassRules[k2]);
                }
                int currNumRules = filteredRules.size();
                this.writekv("num_rules_M".concat(String.valueOf(i2)).concat("T").concat(String.valueOf(j2)), currNumRules);
                String currIdPrefix = i2 + "_" + j2 + "_";
                for (int k3 = 0; k3 < currNumRules; ++k3) {
                    this.writeRule((Rule)filteredRules.get(k3), currIdPrefix + k3);
                }
            }
        }
    }

    void writeRule(Rule rule, String ruleId) throws IOException {
        int numConditions = rule.conditions.length;
        this.writekv("num_conditions_rule_id_" + ruleId, numConditions);
        for (int i2 = 0; i2 < numConditions; ++i2) {
            this.writeCondition(rule.conditions[i2], i2, ruleId);
        }
        this.writekv("prediction_value_rule_id_" + ruleId, rule.predictionValue);
        this.writekv("language_rule_rule_id_" + ruleId, rule.languageRule);
        this.writekv("coefficient_rule_id_" + ruleId, rule.coefficient);
        this.writekv("var_name_rule_id_" + ruleId, rule.varName);
        this.writekv("support_rule_id_" + ruleId, rule.support);
    }

    void writeCondition(Condition condition, int conditionId, String ruleId) throws IOException {
        String conditionIdentifier = conditionId + "_" + ruleId;
        this.writekv("feature_index_" + conditionIdentifier, condition.featureIndex);
        if (Condition.Type.Categorical.equals((Object)condition.type)) {
            this.writekv("type_" + conditionIdentifier, 0);
            int languageCatTresholdLength = condition.languageCatTreshold.length;
            this.writekv("language_cat_treshold_length_" + conditionIdentifier, languageCatTresholdLength);
            for (int i2 = 0; i2 < languageCatTresholdLength; ++i2) {
                this.writekv("language_cat_treshold_" + i2 + "_" + conditionIdentifier, condition.languageCatTreshold[i2]);
            }
            int catTresholdLength = condition.catTreshold.length;
            this.writekv("cat_treshold_length_" + conditionIdentifier, catTresholdLength);
            for (int i3 = 0; i3 < catTresholdLength; ++i3) {
                this.writekv("cat_treshold_length_" + i3 + "_" + conditionIdentifier, condition.catTreshold[i3]);
            }
        } else {
            this.writekv("type_" + conditionIdentifier, 1);
            this.writekv("num_treshold" + conditionIdentifier, condition.numTreshold);
        }
        if (Condition.Operator.LessThan.equals((Object)condition.operator)) {
            this.writekv("operator_" + conditionIdentifier, 0);
        } else if (Condition.Operator.GreaterThanOrEqual.equals((Object)condition.operator)) {
            this.writekv("operator_" + conditionIdentifier, 1);
        } else {
            this.writekv("operator_" + conditionIdentifier, 2);
        }
        this.writekv("feature_name_" + conditionIdentifier, condition.featureName);
        this.writekv("nas_included_" + conditionIdentifier, condition.NAsIncluded);
        this.writekv("language_condition" + conditionIdentifier, condition.languageCondition);
    }
}

