/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import water.Iced;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.parser.BufferedString;
import water.util.ArrayUtils;

public class Condition
extends Iced {
    int featureIndex;
    Type type;
    public Operator operator;
    public String featureName;
    public boolean NAsIncluded;
    public String languageCondition;
    public double numTreshold;
    public String[] languageCatTreshold;
    public int[] catTreshold;

    public Condition(int featureIndex, Type type, Operator operator2, double numTreshold, String[] languageCatTreshold, int[] catTreshold, String featureName, boolean NAsIncluded) {
        this.featureIndex = featureIndex;
        this.type = type;
        this.operator = operator2;
        this.featureName = featureName;
        this.NAsIncluded = NAsIncluded;
        this.numTreshold = numTreshold;
        this.languageCatTreshold = languageCatTreshold;
        this.catTreshold = catTreshold;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }

    public Type getType() {
        return this.type;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean isNAsIncluded() {
        return this.NAsIncluded;
    }

    public int getNumCatTreshold() {
        return this.catTreshold.length;
    }

    public double getNumTreshold() {
        return this.numTreshold;
    }

    String constructLanguageCondition() {
        StringBuilder description = new StringBuilder();
        description.append("(").append(this.featureName);
        if (Operator.LessThan.equals((Object)this.operator)) {
            description.append(" < ").append(this.numTreshold);
        } else if (Operator.GreaterThanOrEqual.equals((Object)this.operator)) {
            description.append(" >= ").append(this.numTreshold);
        } else if (Operator.In.equals((Object)this.operator)) {
            description.append(" in {");
            for (int i2 = 0; i2 < this.languageCatTreshold.length; ++i2) {
                if (i2 != 0) {
                    description.append(", ");
                }
                description.append(this.languageCatTreshold[i2]);
            }
            description.append("}");
        }
        if (this.NAsIncluded) {
            description.append(" or ").append(this.featureName).append(" is NA");
        }
        description.append(")");
        return description.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition condition = (Condition)obj;
        if (Type.Numerical.equals((Object)condition.type)) {
            return this.featureIndex == condition.featureIndex && this.operator == condition.operator && this.featureName.equals(condition.featureName) && Math.abs(this.numTreshold - condition.numTreshold) < 1.0E-5 && this.type == condition.type;
        }
        return this.NAsIncluded == condition.NAsIncluded && this.operator == condition.operator && Arrays.equals(this.catTreshold, condition.catTreshold) && this.featureIndex == condition.featureIndex && this.featureName.equals(condition.featureName) && Arrays.equals(this.languageCatTreshold, condition.languageCatTreshold) && this.type == condition.type;
    }

    public int hashCode() {
        if (Type.Numerical.equals((Object)this.type)) {
            int result = Objects.hash(new Object[]{this.featureIndex, this.type, this.operator, this.featureName, this.numTreshold});
            return result;
        }
        int result = Objects.hash(new Object[]{this.featureIndex, this.type, this.operator, this.featureName, this.NAsIncluded});
        result = 31 * result + Arrays.hashCode(this.languageCatTreshold);
        result = 31 * result + Arrays.hashCode(this.catTreshold);
        return result;
    }

    public void map(Chunk[] cs, byte[] out) {
        Chunk col = cs[this.featureIndex];
        for (int iRow = 0; iRow < col._len; ++iRow) {
            byte newVal;
            block6: {
                block7: {
                    block8: {
                        boolean isNA;
                        block5: {
                            if (out[iRow] == 0) continue;
                            newVal = 0;
                            isNA = col.isNA(iRow);
                            if (!this.NAsIncluded || !isNA) break block5;
                            newVal = 1;
                            break block6;
                        }
                        if (isNA) break block6;
                        if (!Type.Numerical.equals((Object)this.type)) break block7;
                        if (!Operator.LessThan.equals((Object)this.operator)) break block8;
                        if (col.atd(iRow) < this.numTreshold) {
                            newVal = 1;
                        }
                        break block6;
                    }
                    if (!Operator.GreaterThanOrEqual.equals((Object)this.operator) || !(col.atd(iRow) >= this.numTreshold)) break block6;
                    newVal = 1;
                    break block6;
                }
                if (Type.Categorical.equals((Object)this.type)) {
                    BufferedString tmpStr = new BufferedString();
                    for (int i2 = 0; i2 < this.catTreshold.length; ++i2) {
                        if (col instanceof CStrChunk) {
                            if (!ArrayUtils.contains(this.languageCatTreshold, col.atStr(tmpStr, iRow))) continue;
                            newVal = 1;
                            continue;
                        }
                        if ((double)this.catTreshold[i2] != col.atd(iRow)) continue;
                        newVal = 1;
                    }
                }
            }
            out[iRow] = newVal;
        }
    }

    Condition expandBy(Condition otherCondition) {
        int[] expandedCatTreshold;
        String[] expandedlanguageCatTreshold;
        double expandedNumThreshold;
        assert (this.type.equals((Object)otherCondition.type));
        assert (this.operator.equals((Object)otherCondition.operator));
        assert (this.featureIndex == otherCondition.featureIndex);
        assert (this.featureName.equals(otherCondition.featureName));
        boolean expandedNAsIncluded = false;
        if (this.type.equals((Object)Type.Categorical)) {
            expandedNumThreshold = -1.0;
            ArrayList<String> expandedLanguageCatTresholdList = new ArrayList<String>();
            ArrayList<Integer> expandedCatTresholdList = new ArrayList<Integer>();
            expandedLanguageCatTresholdList.addAll(Arrays.asList(this.languageCatTreshold));
            expandedCatTresholdList.addAll(Arrays.stream(this.catTreshold).boxed().collect(Collectors.toList()));
            for (int i3 = 0; i3 < otherCondition.catTreshold.length; ++i3) {
                if (expandedCatTresholdList.contains(otherCondition.catTreshold[i3])) continue;
                expandedCatTresholdList.add(otherCondition.catTreshold[i3]);
                expandedLanguageCatTresholdList.add(otherCondition.languageCatTreshold[i3]);
            }
            expandedlanguageCatTreshold = expandedLanguageCatTresholdList.toArray(new String[0]);
            expandedCatTreshold = expandedCatTresholdList.stream().mapToInt(i2 -> i2).toArray();
        } else {
            if (Operator.LessThan.equals((Object)this.operator)) {
                expandedNumThreshold = Double.max(this.numTreshold, otherCondition.numTreshold);
            } else {
                assert (Operator.GreaterThanOrEqual.equals((Object)this.operator));
                expandedNumThreshold = Double.min(this.numTreshold, otherCondition.numTreshold);
            }
            expandedlanguageCatTreshold = null;
            expandedCatTreshold = null;
        }
        if (this.NAsIncluded || otherCondition.NAsIncluded) {
            expandedNAsIncluded = true;
        }
        return new Condition(this.featureIndex, this.type, this.operator, expandedNumThreshold, expandedlanguageCatTreshold, expandedCatTreshold, this.featureName, expandedNAsIncluded);
    }

    public static enum Operator {
        LessThan,
        GreaterThanOrEqual,
        In;

    }

    public static enum Type {
        Categorical,
        Numerical;

    }
}

