/*
 * Decompiled with CFR 0.152.
 */
package hex.mojopipeline;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import water.DKV;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.ByteVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;

public class MojoPipeline
extends Iced<MojoPipeline> {
    private ByteVec _mojoData;
    private transient MojoPipelineMeta _mojoPipelineMeta;

    public MojoPipeline(ByteVec mojoData) {
        this._mojoData = mojoData;
        this._mojoPipelineMeta = MojoPipeline.readPipelineMeta(this._mojoData);
    }

    public Frame transform(Frame f2, boolean allowTimestamps) {
        Frame adaptedFrame = this.adaptFrame(f2, allowTimestamps);
        byte[] types = this.outputTypes();
        return ((MojoPipelineTransformer)new MojoPipelineTransformer(this._mojoData._key).doAll(types, adaptedFrame)).outputFrame(null, this._mojoPipelineMeta.outputFrameMeta.getColumnNames(), null);
    }

    private byte[] outputTypes() {
        MojoFrameMeta outputMeta = this._mojoPipelineMeta.outputFrameMeta;
        byte[] types = new byte[outputMeta.size()];
        int i2 = 0;
        for (MojoColumn.Type type : outputMeta.getColumnTypes()) {
            types[i2++] = type.isnumeric || type == MojoColumn.Type.Bool ? 3 : 2;
        }
        return types;
    }

    private Frame adaptFrame(Frame f2, boolean allowTimestamps) {
        return MojoPipeline.adaptFrame(f2, this._mojoPipelineMeta.inputFrameMeta, allowTimestamps);
    }

    private static Frame adaptFrame(Frame f2, MojoFrameMeta inputMeta, boolean allowTimestamps) {
        Frame adaptedFrame = new Frame(new Vec[0]);
        for (int colIdx = 0; colIdx < inputMeta.size(); ++colIdx) {
            String colName = inputMeta.getColumnName(colIdx);
            Vec v2 = f2.vec(colName);
            if (v2 == null) {
                throw new IllegalArgumentException("Input frame is missing a column: " + colName);
            }
            if (v2.get_type() == 0 || v2.get_type() == 1) {
                throw new UnsupportedOperationException("Columns of type " + v2.get_type_str() + " are currently not supported.");
            }
            if (!allowTimestamps && v2.get_type() == 5 && inputMeta.getColumnType(colName) == MojoColumn.Type.Str) {
                throw new IllegalArgumentException("MOJO Pipelines currently do not support datetime columns represented as timestamps. Please parse your dataset again and make sure column '" + colName + "' is parsed as String instead of Timestamp. You can also enable implicit timestamp conversion in your client. Please refer to documentation of the transform function.");
            }
            adaptedFrame.add(colName, v2);
        }
        return adaptedFrame;
    }

    /*
     * Exception decompiling
     */
    private static ai.h2o.mojos.runtime.MojoPipeline readPipeline(ByteVec mojoData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static MojoPipelineMeta readPipelineMeta(ByteVec mojoData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MojoChunkConverter makeConverter(Chunk c2, int col, MojoColumn.Type type) {
        switch (c2.vec().get_type()) {
            case 3: {
                if (type == MojoColumn.Type.Str) {
                    return new MojoChunkConverter(c2, col){

                        @Override
                        void convertValue(int i2, MojoRowBuilder target) {
                            double val = this._c.atd(i2);
                            target.setString(this._col, String.valueOf(val));
                        }
                    };
                }
                if (type == MojoColumn.Type.Bool) {
                    return new MojoChunkConverter(c2, col){

                        @Override
                        void convertValue(int i2, MojoRowBuilder target) {
                            long val = this._c.at8(i2);
                            target.setBool(this._col, (Boolean)(val == 1L ? 1 : 0));
                        }
                    };
                }
                if (type.isfloat) {
                    return new MojoChunkConverter(c2, col){

                        @Override
                        void convertValue(int i2, MojoRowBuilder target) {
                            target.setDouble(this._col, (Double)this._c.atd(i2));
                        }
                    };
                }
                return new MojoChunkConverter(c2, col){

                    @Override
                    void convertValue(int i2, MojoRowBuilder target) {
                        target.setLong(this._col, (Long)this._c.at8(i2));
                    }
                };
            }
            case 4: {
                return new MojoChunkConverter(c2, col){

                    @Override
                    void convertValue(int i2, MojoRowBuilder target) {
                        target.setValue(this._col, this._c.vec().domain()[(int)this._c.at8(i2)]);
                    }
                };
            }
            case 2: {
                if (type == MojoColumn.Type.Str) {
                    return new MojoChunkConverter(c2, col){

                        @Override
                        void convertValue(int i2, MojoRowBuilder target) {
                            target.setString(this._col, this._c.atStr(new BufferedString(), i2).toString());
                        }
                    };
                }
                return new MojoChunkConverter(c2, col){

                    @Override
                    void convertValue(int i2, MojoRowBuilder target) {
                        target.setValue(this._col, this._c.atStr(new BufferedString(), i2).toString());
                    }
                };
            }
            case 5: {
                if (type == MojoColumn.Type.Time64) {
                    return new MojoChunkConverter(c2, col){

                        @Override
                        void convertValue(int i2, MojoRowBuilder target) {
                            long timestamp = this._c.at8(i2);
                            target.setTimestamp(this._col, new Timestamp(timestamp));
                        }
                    };
                }
                final DateFormat dateFormatter = MojoPipeline.dateFormatter();
                return new MojoChunkConverter(c2, col){

                    @Override
                    void convertValue(int i2, MojoRowBuilder target) {
                        long timestamp = this._c.at8(i2);
                        target.setValue(this._col, dateFormatter.format(new Date(timestamp)));
                    }
                };
            }
        }
        throw new IllegalStateException("Unexpected column type: " + c2.vec().get_type_str());
    }

    private static DateFormat dateFormatter() {
        return new SimpleDateFormat("MM/dd/yyyy'T'hh:mm:ss.sss");
    }

    private static abstract class MojoChunkConverter {
        final int _col;
        final Chunk _c;

        private MojoChunkConverter(Chunk c2, int col) {
            this._c = c2;
            this._col = col;
        }

        abstract void convertValue(int var1, MojoRowBuilder var2);
    }

    private static class MojoPipelineTransformer
    extends MRTask<MojoPipelineTransformer> {
        private final Key<Vec> _mojoDataKey;
        private transient ai.h2o.mojos.runtime.MojoPipeline _pipeline;

        private MojoPipelineTransformer(Key<Vec> mojoDataKey) {
            this._mojoDataKey = mojoDataKey;
        }

        @Override
        protected void setupLocal() {
            ByteVec mojoData = (ByteVec)DKV.getGet(this._mojoDataKey);
            this._pipeline = MojoPipeline.readPipeline(mojoData);
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            assert (cs.length == this._pipeline.getInputMeta().size());
            MojoFrameBuilder frameBuilder = this._pipeline.getInputFrameBuilder();
            MojoRowBuilder rowBuilder = frameBuilder.getMojoRowBuilder();
            MojoChunkConverter[] conv = new MojoChunkConverter[cs.length];
            MojoFrameMeta meta = this._pipeline.getInputMeta();
            for (int col = 0; col < cs.length; ++col) {
                MojoColumn.Type type = meta.getColumnType(this._fr.name(col));
                int idx = meta.getColumnIndex(this._fr.name(col));
                conv[col] = MojoPipeline.makeConverter(cs[col], idx, type);
            }
            for (int i2 = 0; i2 < cs[0]._len; ++i2) {
                for (int col = 0; col < cs.length; ++col) {
                    Chunk c2 = cs[col];
                    if (c2.isNA(i2)) continue;
                    conv[col].convertValue(i2, rowBuilder);
                }
                frameBuilder.addRow(rowBuilder);
            }
            MojoFrame input = frameBuilder.toMojoFrame();
            MojoFrame transformed = this._pipeline.transform(input);
            block11: for (int col = 0; col < ncs.length; ++col) {
                NewChunk nc = ncs[col];
                MojoColumn column = transformed.getColumn(col);
                assert (column.size() == cs[0].len());
                switch (column.getType()) {
                    case Str: {
                        for (String s2 : (String[])column.getData()) {
                            nc.addStr(s2);
                        }
                        continue block11;
                    }
                    case Bool: {
                        for (byte d2 : (byte[])column.getData()) {
                            nc.addNum(d2, 0);
                        }
                        continue block11;
                    }
                    case Int32: {
                        for (int d3 : (int[])column.getData()) {
                            nc.addNum(d3, 0);
                        }
                        continue block11;
                    }
                    case Int64: {
                        for (long d4 : (long[])column.getData()) {
                            nc.addNum(d4, 0);
                        }
                        continue block11;
                    }
                    case Float32: {
                        for (float d5 : (float[])column.getData()) {
                            nc.addNum(d5);
                        }
                        continue block11;
                    }
                    case Float64: {
                        for (double d6 : (double[])column.getData()) {
                            nc.addNum(d6);
                        }
                        continue block11;
                    }
                    default: {
                        throw new UnsupportedOperationException("Output type " + (Object)((Object)column.getType()) + " is currently not supported for MOJO2. See https://0xdata.atlassian.net/browse/PUBDEV-7741");
                    }
                }
            }
        }
    }

    private static class MojoPipelineMeta {
        final MojoFrameMeta inputFrameMeta;
        final MojoFrameMeta outputFrameMeta;

        private MojoPipelineMeta(MojoFrameMeta inputFrameMeta, MojoFrameMeta outputFrameMeta) {
            this.inputFrameMeta = inputFrameMeta;
            this.outputFrameMeta = outputFrameMeta;
        }
    }
}

