/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import hex.genmodel.MojoPipelineBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BuildPipeline {
    private File _output;
    private Map<String, File> _input;
    private List<MojoPipelineBuilder.MappingSpec> _mappings;

    public static void main(String[] args) {
        BuildPipeline main = new BuildPipeline();
        main.parseArgs(args);
        try {
            main.run();
        }
        catch (Exception e2) {
            System.err.println("ERROR: " + e2.getMessage());
            e2.printStackTrace();
            System.exit(2);
        }
    }

    private void run() throws Exception {
        String mainModelAlias = this.findMainModel();
        MojoPipelineBuilder builder = new MojoPipelineBuilder();
        for (Map.Entry<String, File> e2 : this._input.entrySet()) {
            if (mainModelAlias.equals(e2.getKey())) continue;
            builder.addModel(e2.getKey(), e2.getValue());
        }
        builder.addMappings(this._mappings).addMainModel(mainModelAlias, this._input.get(mainModelAlias)).buildPipeline(this._output);
    }

    private String findMainModel() {
        HashSet<String> subModels = new HashSet<String>();
        for (MojoPipelineBuilder.MappingSpec spec : this._mappings) {
            subModels.add(spec._modelAlias);
        }
        HashSet<String> candidates = new HashSet<String>();
        for (String alias2 : this._input.keySet()) {
            if (subModels.contains(alias2)) continue;
            candidates.add(alias2);
        }
        if (candidates.size() != 1) {
            throw new IllegalStateException("Main model cannot be identified, main should be the only model that doesn't have output mappings. Candidates: " + ((Object)candidates).toString());
        }
        return (String)candidates.iterator().next();
    }

    private static void usage() {
        System.out.println("");
        System.out.println("Usage:  java [...java args...] hex.genmodel.tools.BuildPipeline ");
        System.out.println("             --mapping <inputMapping1> <inputMapping2> ... --output <outputFile> --input <inputFile1> <inputFile2> ...");
        System.out.println("");
        System.out.println("     --mapping Mapping of model predictions to main model inputs.");
        System.out.println("               Example: Specify 'CLUSTER=clustering:0' to use a model defined in a MOJO file 'clustering.zip'");
        System.out.println("                        and map the predicted cluster (output 0) to input column 'CLUSTER' of the main model.");
        System.out.println("     --input   List of input MOJO files representing both the main model and the prerequisite models.");
        System.out.println("     --output  Name of the generated MOJO pipeline file.");
        System.out.println("");
        System.out.println("     Input mappings are specified in format '<columnName>=<modelAlias>:<predictionIndex>'.");
        System.out.println("");
        System.out.println("     Model alias is based on the name of the MOJO file.");
        System.out.println("     For example, a MOJO stored in 'glm_model.zip' will have the alias 'glm_model'.");
        System.out.println("");
        System.out.println("Note: There is no need to specify which of the MOJO model represents the main model. The tool");
        System.out.println("automatically identifies the main model as the one that doesn't have any output mappings.");
        System.out.println("");
        System.exit(1);
    }

    private void parseArgs(String[] args) {
        try {
            for (int i2 = 0; i2 < args.length; ++i2) {
                String s2 = args[i2];
                if (s2.equals("--mapping")) {
                    List<String> mappingSpec = BuildPipeline.readArgValues(args, i2 + 1);
                    this._mappings = new ArrayList<MojoPipelineBuilder.MappingSpec>(mappingSpec.size());
                    for (String spec : mappingSpec) {
                        try {
                            this._mappings.add(MojoPipelineBuilder.MappingSpec.parse(spec));
                        }
                        catch (Exception e2) {
                            throw new IllegalArgumentException("Invalid mapping specified ('" + spec + "'. Please use format '<columnName>=<modelAlias>:<predictionIndex>'.");
                        }
                    }
                    i2 += mappingSpec.size();
                    continue;
                }
                if (s2.equals("--output")) {
                    List<String> outputFile = BuildPipeline.readArgValues(args, i2 + 1);
                    if (outputFile.size() != 1) {
                        throw new IllegalArgumentException("Invalid specification of the output file (" + outputFile.toString() + "). Please specify only a single output file.");
                    }
                    this._output = new File(outputFile.get(0));
                    ++i2;
                    continue;
                }
                if (s2.equals("--input")) {
                    List<String> inputFiles = BuildPipeline.readArgValues(args, i2 + 1);
                    if (inputFiles.size() < 2) {
                        throw new IllegalArgumentException("Pipeline needs at least 2 input files, only " + inputFiles.size() + " specified.");
                    }
                    this._input = this.makeAliases(inputFiles);
                    i2 += inputFiles.size();
                    continue;
                }
                System.out.println("ERROR: Unknown command line argument: " + s2);
                BuildPipeline.usage();
            }
        }
        catch (Exception e3) {
            System.err.println("ERROR: " + e3.getMessage());
            e3.printStackTrace();
            BuildPipeline.usage();
        }
        if (this._input == null) {
            System.err.println("ERROR: Missing mandatory argument '--output'");
            BuildPipeline.usage();
        }
        if (this._output == null) {
            System.err.println("ERROR: Missing mandatory argument '--input'");
            BuildPipeline.usage();
        }
        if (this._mappings == null) {
            System.err.println("ERROR: Missing mandatory argument '--mapping'");
            BuildPipeline.usage();
        }
    }

    private Map<String, File> makeAliases(List<String> paths) {
        HashMap<String, File> aliases = new HashMap<String, File>(paths.size());
        for (String path : paths) {
            File f2 = new File(path);
            String name = f2.getName();
            int extIndex = name.lastIndexOf(".");
            String alias2 = extIndex >= 0 ? name.substring(0, extIndex) : name;
            aliases.put(alias2, f2);
        }
        return aliases;
    }

    private static List<String> readArgValues(String[] args, int startIdx) {
        LinkedList<String> params = new LinkedList<String>();
        for (int i2 = startIdx; i2 < args.length && !args[i2].startsWith("--"); ++i2) {
            params.add(args[i2]);
        }
        return params;
    }
}

