/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import com.google.gson.JsonObject;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.glm.GlmMojoModel;
import hex.genmodel.algos.glm.GlmMojoModelBase;
import hex.genmodel.algos.glm.GlmMultinomialMojoModel;
import hex.genmodel.algos.glm.GlmOrdinalMojoModel;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.ModelAttributesGLM;
import hex.genmodel.attributes.ModelJsonReader;
import java.io.IOException;

public class GlmMojoReader
extends ModelMojoReader<GlmMojoModelBase> {
    @Override
    public String getModelName() {
        return "Generalized Linear Model";
    }

    @Override
    protected void readModelData() throws IOException {
        ((GlmMojoModelBase)this._model)._useAllFactorLevels = this.readkv("use_all_factor_levels", false);
        ((GlmMojoModelBase)this._model)._cats = this.readkv("cats", -1);
        ((GlmMojoModelBase)this._model)._catModes = this.readkv("cat_modes", new int[0]);
        ((GlmMojoModelBase)this._model)._catOffsets = this.readkv("cat_offsets", new int[0]);
        ((GlmMojoModelBase)this._model)._nums = this.readkv("nums", -1);
        ((GlmMojoModelBase)this._model)._numMeans = this.readkv("num_means", new double[0]);
        ((GlmMojoModelBase)this._model)._meanImputation = this.readkv("mean_imputation", false);
        ((GlmMojoModelBase)this._model)._beta = (double[])this.readkv("beta");
        ((GlmMojoModelBase)this._model)._family = (String)this.readkv("family");
        if (this._model instanceof GlmMojoModel) {
            GlmMojoModel m4 = (GlmMojoModel)this._model;
            m4._link = (String)this.readkv("link");
            m4._tweedieLinkPower = this.readkv("tweedie_link_power", 0.0);
        }
        ((GlmMojoModelBase)this._model).init();
    }

    @Override
    protected ModelAttributes readModelSpecificAttributes() {
        JsonObject modelJson = ModelJsonReader.parseModelJson(this._reader);
        if (modelJson != null) {
            return new ModelAttributesGLM(this._model, modelJson);
        }
        return null;
    }

    @Override
    protected GlmMojoModelBase makeModel(String[] columns, String[][] domains, String responseColumn) {
        String family = (String)this.readkv("family");
        if ("multinomial".equals(family)) {
            return new GlmMultinomialMojoModel(columns, domains, responseColumn);
        }
        if ("ordinal".equals(family)) {
            return new GlmOrdinalMojoModel(columns, domains, responseColumn);
        }
        return new GlmMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

