/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

public class GamUtilsThinPlateRegression {
    public static double calTPConstantTerm(int m4, int d2, boolean dEven) {
        if (dEven) {
            return Math.pow(-1.0, (double)(m4 + 1) + (double)d2 / 2.0) / (Math.pow(2.0, 2 * m4 - 1) * Math.pow(Math.PI, (double)d2 / 2.0) * (double)GamUtilsThinPlateRegression.factorial(m4 - 1) * (double)GamUtilsThinPlateRegression.factorial(m4 - d2 / 2));
        }
        return Math.pow(-1.0, m4) * (double)m4 / ((double)GamUtilsThinPlateRegression.factorial(2 * m4) * Math.pow(Math.PI, (double)(d2 - 1) / 2.0));
    }

    public static int factorial(int m4) {
        if (m4 <= 1) {
            return 1;
        }
        int prod = 1;
        for (int index = 1; index <= m4; ++index) {
            prod *= index;
        }
        return prod;
    }

    public static void calculateDistance(double[] rowValues, double[] chk, int knotNum, double[][] knots, int d2, int m4, boolean dEven, double constantTerms, double[] oneOGamColStd, boolean standardizeGAM) {
        for (int knotInd = 0; knotInd < knotNum; ++knotInd) {
            double sumSq = 0.0;
            for (int predInd = 0; predInd < d2; ++predInd) {
                double temp = standardizeGAM ? (chk[predInd] - knots[predInd][knotInd]) * oneOGamColStd[predInd] : chk[predInd] - knots[predInd][knotInd];
                sumSq += temp * temp;
            }
            double distance = Math.pow(Math.sqrt(sumSq), 2 * m4 - d2);
            rowValues[knotInd] = constantTerms * distance;
            if (!dEven || distance == 0.0) continue;
            int n2 = knotInd;
            rowValues[n2] = rowValues[n2] * Math.log(distance);
        }
    }

    public static void calculatePolynomialBasis(double[] onePolyRow, double[] oneDataRow, int d2, int M2, int[][] polyBasisList, double[] gamColMean, double[] oneOGamStd, boolean standardizeGAM) {
        for (int colIndex = 0; colIndex < M2; ++colIndex) {
            int[] oneBasis = polyBasisList[colIndex];
            double val = 1.0;
            for (int predIndex = 0; predIndex < d2; ++predIndex) {
                val *= standardizeGAM ? Math.pow(oneDataRow[predIndex] - gamColMean[predIndex] * oneOGamStd[predIndex], oneBasis[predIndex]) : Math.pow(oneDataRow[predIndex], oneBasis[predIndex]);
            }
            onePolyRow[colIndex] = val;
        }
    }
}

