/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import hex.gam.GamSplines.ThinPlateRegressionUtils;
import hex.genmodel.algos.gam.GamUtilsThinPlateRegression;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class ThinPlatePolynomialWithKnots
extends MRTask<ThinPlatePolynomialWithKnots> {
    final int _weightID;
    final int[][] _polyBasisList;
    final int _M;
    final int _d;
    final double[] _gamColMeanRaw;
    final double[] _oneOverColStd;
    final boolean _standardizeGAM;

    public ThinPlatePolynomialWithKnots(int weightID, int[][] polyBasis, double[] gamColMeanRaw, double[] oneOverColStd, boolean standardizeGAM) {
        this._weightID = weightID;
        this._d = weightID;
        this._polyBasisList = polyBasis;
        this._M = polyBasis.length;
        this._gamColMeanRaw = gamColMeanRaw;
        this._oneOverColStd = oneOverColStd;
        this._standardizeGAM = standardizeGAM;
    }

    @Override
    public void map(Chunk[] chk, NewChunk[] newGamCols) {
        int numRow = chk[0].len();
        double[] onePolyRow = MemoryManager.malloc8d(this._M);
        double[] oneDataRow = MemoryManager.malloc8d(this._d);
        for (int rowIndex = 0; rowIndex < numRow; ++rowIndex) {
            if (chk[this._weightID].atd(rowIndex) != 0.0) {
                if (ThinPlateRegressionUtils.checkRowNA(chk, rowIndex)) {
                    ThinPlateRegressionUtils.fillRowOneValue(newGamCols, this._M, Double.NaN);
                    continue;
                }
                ThinPlatePolynomialWithKnots.extractNDemeanOneRowFromChunk(chk, rowIndex, oneDataRow, this._d);
                GamUtilsThinPlateRegression.calculatePolynomialBasis(onePolyRow, oneDataRow, this._d, this._M, this._polyBasisList, this._gamColMeanRaw, this._oneOverColStd, this._standardizeGAM);
                ThinPlateRegressionUtils.fillRowArray(newGamCols, this._M, onePolyRow);
                continue;
            }
            ThinPlateRegressionUtils.fillRowOneValue(newGamCols, this._M, 0.0);
        }
    }

    public static void extractNDemeanOneRowFromChunk(Chunk[] chk, int rowIndex, double[] oneRow, int d2) {
        for (int colInd = 0; colInd < d2; ++colInd) {
            oneRow[colInd] = chk[colInd].atd(rowIndex);
        }
    }
}

