/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import java.util.TreeMap;
import water.DKV;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class Storage {
    static Frame toFrame(Vector v2, Key key) {
        int log_rows_per_chunk = Math.max(1, 22 - (int)Math.floor(Math.log(1.0) / Math.log(2.0)));
        Vec vv = Vec.makeCon(0.0, (long)v2.size(), log_rows_per_chunk, false);
        Frame f2 = new Frame(key, new Vec[]{vv});
        try (Vec.Writer vw = f2.vecs()[0].open();){
            for (int r2 = 0; r2 < v2.size(); ++r2) {
                vw.set((long)r2, v2.get(r2));
            }
        }
        DKV.put(key, f2);
        return f2;
    }

    static Frame toFrame(Matrix m4, Key key) {
        int log_rows_per_chunk = Math.max(1, 22 - (int)Math.floor(Math.log(m4.cols()) / Math.log(2.0)));
        Vec[] v2 = new Vec[m4.cols()];
        for (int i2 = 0; i2 < m4.cols(); ++i2) {
            v2[i2] = Vec.makeCon(0.0, (long)m4.rows(), log_rows_per_chunk);
        }
        Frame f2 = ((FrameFiller)new FrameFiller((Matrix)m4).doAll((Frame)new Frame((Key<Frame>)key, (Vec[])v2)))._fr;
        DKV.put(key, f2);
        return f2;
    }

    static class FrameFiller
    extends MRTask<FrameFiller> {
        final DenseColMatrix dcm;
        final DenseRowMatrix drm;
        final SparseRowMatrix srm;
        final SparseColMatrix scm;

        FrameFiller(Matrix m4) {
            if (m4 instanceof DenseColMatrix) {
                this.dcm = (DenseColMatrix)m4;
                this.drm = null;
                this.srm = null;
                this.scm = null;
            } else if (m4 instanceof DenseRowMatrix) {
                this.dcm = null;
                this.drm = (DenseRowMatrix)m4;
                this.srm = null;
                this.scm = null;
            } else if (m4 instanceof SparseRowMatrix) {
                this.dcm = null;
                this.drm = null;
                this.srm = (SparseRowMatrix)m4;
                this.scm = null;
            } else {
                this.dcm = null;
                this.drm = null;
                this.srm = null;
                this.scm = (SparseColMatrix)m4;
            }
        }

        @Override
        public void map(Chunk[] cs) {
            Iced m4 = null;
            if (this.dcm != null) {
                m4 = this.dcm;
            }
            if (this.drm != null) {
                m4 = this.drm;
            }
            if (this.scm != null) {
                m4 = this.scm;
            }
            if (this.srm != null) {
                m4 = this.srm;
            }
            int off = (int)cs[0].start();
            assert (m4.cols() == cs.length);
            for (int c2 = 0; c2 < cs.length; ++c2) {
                for (int r2 = 0; r2 < cs[0]._len; ++r2) {
                    cs[c2].set(r2, m4.get(off + r2, c2));
                }
            }
        }
    }

    static final class SparseColMatrix
    extends Iced
    implements Matrix {
        private TreeMap<Integer, Float>[] _cols;
        private int _rows;

        SparseColMatrix(int rows, int cols) {
            this(null, rows, cols);
        }

        SparseColMatrix(Matrix v2, int rows, int cols) {
            this._rows = rows;
            this._cols = new TreeMap[cols];
            for (int col = 0; col < cols; ++col) {
                this._cols[col] = new TreeMap();
            }
            if (v2 != null) {
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        if (v2.get(row, col) == 0.0f) continue;
                        this.add(row, col, v2.get(row, col));
                    }
                }
            }
        }

        @Override
        public float get(int row, int col) {
            Float v2 = this._cols[col].get(row);
            if (v2 == null) {
                return 0.0f;
            }
            return v2.floatValue();
        }

        @Override
        public void add(int row, int col, float val) {
            this.set(row, col, this.get(row, col) + val);
        }

        @Override
        public void set(int row, int col, float val) {
            this._cols[col].put(row, Float.valueOf(val));
        }

        @Override
        public int cols() {
            return this._cols.length;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public long size() {
            return (long)this._rows * (long)this._cols.length;
        }

        TreeMap<Integer, Float> col(int col) {
            return this._cols[col];
        }

        @Override
        public float[] raw() {
            throw new UnsupportedOperationException("raw access to the data in a sparse matrix is not implemented.");
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static final class SparseRowMatrix
    extends Iced
    implements Matrix {
        private TreeMap<Integer, Float>[] _rows;
        private int _cols;

        SparseRowMatrix(int rows, int cols) {
            this(null, rows, cols);
        }

        SparseRowMatrix(Matrix v2, int rows, int cols) {
            int row;
            this._rows = new TreeMap[rows];
            for (row = 0; row < rows; ++row) {
                this._rows[row] = new TreeMap();
            }
            this._cols = cols;
            if (v2 != null) {
                for (row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        if (v2.get(row, col) == 0.0f) continue;
                        this.add(row, col, v2.get(row, col));
                    }
                }
            }
        }

        @Override
        public float get(int row, int col) {
            Float v2 = this._rows[row].get(col);
            if (v2 == null) {
                return 0.0f;
            }
            return v2.floatValue();
        }

        @Override
        public void add(int row, int col, float val) {
            this.set(row, col, this.get(row, col) + val);
        }

        @Override
        public void set(int row, int col, float val) {
            this._rows[row].put(col, Float.valueOf(val));
        }

        @Override
        public int cols() {
            return this._cols;
        }

        @Override
        public int rows() {
            return this._rows.length;
        }

        @Override
        public long size() {
            return (long)this._rows.length * (long)this._cols;
        }

        TreeMap<Integer, Float> row(int row) {
            return this._rows[row];
        }

        @Override
        public float[] raw() {
            throw new UnsupportedOperationException("raw access to the data in a sparse matrix is not implemented.");
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static final class DenseColMatrix
    extends Iced
    implements Matrix {
        private float[] _data;
        private int _cols;
        private int _rows;

        DenseColMatrix(int rows, int cols) {
            this(new float[cols * rows], rows, cols);
        }

        DenseColMatrix(float[] v2, int rows, int cols) {
            this._data = v2;
            this._rows = rows;
            this._cols = cols;
        }

        DenseColMatrix(DenseRowMatrix m4, int rows, int cols) {
            this(rows, cols);
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    this.set(row, col, m4.get(row, col));
                }
            }
        }

        @Override
        public float get(int row, int col) {
            assert (row < this._rows && col < this._cols);
            return this._data[col * this._rows + row];
        }

        @Override
        public void set(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            this._data[col * this._rows + row] = val;
        }

        @Override
        public void add(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            int n2 = col * this._rows + row;
            this._data[n2] = this._data[n2] + val;
        }

        @Override
        public int cols() {
            return this._cols;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public long size() {
            return (long)this._rows * (long)this._cols;
        }

        @Override
        public float[] raw() {
            return this._data;
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static final class DenseRowMatrix
    extends Iced
    implements Matrix {
        private float[] _data;
        private int _cols;
        private int _rows;

        DenseRowMatrix(int rows, int cols) {
            this(new float[cols * rows], rows, cols);
        }

        DenseRowMatrix(float[] v2, int rows, int cols) {
            this._data = v2;
            this._rows = rows;
            this._cols = cols;
        }

        @Override
        public float get(int row, int col) {
            assert (row < this._rows && col < this._cols) : "_data.length: " + this._data.length + ", checking: " + row + " < " + this._rows + " && " + col + " < " + this._cols;
            return this._data[row * this._cols + col];
        }

        @Override
        public void set(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            this._data[row * this._cols + col] = val;
        }

        @Override
        public void add(int row, int col, float val) {
            assert (row < this._rows && col < this._cols);
            int n2 = row * this._cols + col;
            this._data[n2] = this._data[n2] + val;
        }

        @Override
        public int cols() {
            return this._cols;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public long size() {
            return (long)this._rows * (long)this._cols;
        }

        @Override
        public float[] raw() {
            return this._data;
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static class DenseVector
    extends Iced
    implements Vector {
        private double[] _data;

        DenseVector(int len) {
            this._data = new double[len];
        }

        DenseVector(double[] v2) {
            this._data = v2;
        }

        @Override
        public double get(int i2) {
            return this._data[i2];
        }

        @Override
        public void set(int i2, double val) {
            this._data[i2] = val;
        }

        @Override
        public void add(int i2, double val) {
            int n2 = i2;
            this._data[n2] = this._data[n2] + val;
        }

        @Override
        public int size() {
            return this._data.length;
        }

        @Override
        public double[] raw() {
            return this._data;
        }

        @Override
        public Frame toFrame(Key key) {
            return Storage.toFrame(this, key);
        }
    }

    public static interface Tensor {
        public float get(int var1, int var2, int var3);

        public void set(int var1, int var2, int var3, float var4);

        public void add(int var1, int var2, int var3, float var4);

        public int slices();

        public int cols();

        public int rows();

        public long size();

        public float[] raw();

        public Frame toFrame(int var1, Key var2);
    }

    public static interface Matrix {
        public float get(int var1, int var2);

        public void set(int var1, int var2, float var3);

        public void add(int var1, int var2, float var3);

        public int cols();

        public int rows();

        public long size();

        public float[] raw();

        public Frame toFrame(Key var1);
    }

    public static interface Vector {
        public double get(int var1);

        public void set(int var1, double var2);

        public void add(int var1, double var2);

        public int size();

        public double[] raw();

        public Frame toFrame(Key var1);
    }
}

