/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.Storage;
import java.util.Arrays;
import java.util.Random;
import water.util.RandomUtils;

public class Dropout {
    private transient Random _rand;
    private transient byte[] _bits;
    private transient double _rate;

    public byte[] bits() {
        return this._bits;
    }

    public String toString() {
        String s2 = "Dropout: " + super.toString();
        s2 = s2 + "\nRandom: " + this._rand.toString();
        s2 = s2 + "\nDropout rate: " + this._rate;
        s2 = s2 + "\nbits: ";
        for (int i2 = 0; i2 < this._bits.length * 8; ++i2) {
            s2 = s2 + (this.unit_active(i2) ? "1" : "0");
        }
        s2 = s2 + "\n";
        return s2;
    }

    Dropout(int units) {
        this._bits = new byte[(units + 7) / 8];
        this._rand = RandomUtils.getRNG(0L);
        this._rate = 0.5;
    }

    Dropout(int units, double rate) {
        this(units);
        this._rate = rate;
    }

    public void randomlySparsifyActivation(Storage.Vector a2, long seed) {
        if (!(a2 instanceof Storage.DenseVector)) {
            throw new UnsupportedOperationException("randomlySparsifyActivation not implemented for this type: " + a2.getClass().getSimpleName());
        }
        this.randomlySparsifyActivation((Storage.DenseVector)a2, seed);
    }

    private void randomlySparsifyActivation(Storage.DenseVector a2, long seed) {
        if (this._rate == 0.0) {
            return;
        }
        this.setSeed(seed);
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            if (!((double)this._rand.nextFloat() < this._rate)) continue;
            a2.set(i2, 0.0);
        }
    }

    public void fillBytes(long seed) {
        this.setSeed(seed);
        if (this._rate == 0.5) {
            this._rand.nextBytes(this._bits);
        } else {
            Arrays.fill(this._bits, (byte)0);
            for (int i2 = 0; i2 < this._bits.length * 8; ++i2) {
                if (!((double)this._rand.nextFloat() > this._rate)) continue;
                int n2 = i2 / 8;
                this._bits[n2] = (byte)(this._bits[n2] | 1 << i2 % 8);
            }
        }
    }

    public boolean unit_active(int o2) {
        return (this._bits[o2 / 8] & 1 << o2 % 8) != 0;
    }

    private void setSeed(long seed) {
        if (seed >>> 32 < 65535L) {
            seed |= 0x5B93000000000000L;
        }
        if (seed << 32 >>> 32 < 65535L) {
            seed |= 0xDB910000L;
        }
        this._rand.setSeed(seed);
    }
}

