/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.FrameTask;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.Neurons;
import hex.deeplearning.Storage;
import hex.genmodel.utils.DistributionFamily;
import java.util.Arrays;
import java.util.Random;
import water.DKV;
import water.H2O;
import water.IcedUtils;
import water.Key;
import water.util.Log;
import water.util.RandomUtils;

public class DeepLearningTask
extends FrameTask<DeepLearningTask> {
    private final boolean _training;
    private DeepLearningModelInfo _localmodel;
    private DeepLearningModelInfo _sharedmodel;
    transient Neurons[] _neurons;
    transient Random _dropout_rng;
    int _chunk_node_count = 1;
    static long _lastWarn;
    static long _warnCount;

    public final DeepLearningModelInfo model_info() {
        assert (this._sharedmodel != null);
        return this._sharedmodel;
    }

    public DeepLearningTask(Key jobKey, DeepLearningModelInfo inputModel, float fraction, int iteration) {
        this(jobKey, inputModel, fraction, iteration, null);
    }

    public DeepLearningTask(Key jobKey, DeepLearningModelInfo inputModel, float fraction, int iteration, H2O.H2OCountedCompleter cmp) {
        super(jobKey, inputModel.data_info(), inputModel.get_params()._seed + inputModel.get_processed_global(), iteration, inputModel.get_params()._sparse, cmp);
        assert (inputModel.get_processed_local() == 0L);
        this._training = true;
        this._sharedmodel = inputModel;
        this._useFraction = fraction;
        this._shuffle = this.model_info().get_params()._shuffle_training_data;
    }

    @Override
    protected void setupLocal() {
        assert (this._localmodel == null);
        super.setupLocal();
        if (this.model_info().get_params()._elastic_averaging) {
            this._localmodel = (DeepLearningModelInfo)DKV.getGet(this._sharedmodel.localModelInfoKey(H2O.SELF));
            if (this._localmodel != null) {
                if (!Arrays.equals(this._localmodel.units, this._sharedmodel.units)) {
                    this._localmodel = IcedUtils.deepCopy(this._sharedmodel);
                } else {
                    this._localmodel.set_params(this._sharedmodel.get_params(), this._sharedmodel._model_id);
                    this._localmodel.set_processed_global(this._sharedmodel.get_processed_global());
                }
            } else {
                this._localmodel = IcedUtils.deepCopy(this._sharedmodel);
                this._sharedmodel = null;
            }
        } else {
            this._localmodel = this._sharedmodel;
            this._sharedmodel = null;
        }
        this._localmodel.set_processed_local(0L);
    }

    @Override
    protected boolean chunkInit() {
        if ((float)this._localmodel.get_processed_local() >= this._useFraction * (float)this._fr.numRows()) {
            return false;
        }
        this._neurons = DeepLearningTask.makeNeuronsForTraining(this._localmodel);
        this._dropout_rng = RandomUtils.getRNG(System.currentTimeMillis());
        return true;
    }

    @Override
    public final void processRow(long seed, DataInfo.Row r2, int mb) {
        seed = this._localmodel.get_params()._reproducible ? (seed += this._localmodel.get_processed_global()) : this._dropout_rng.nextLong();
        this._localmodel.checkMissingCats(r2.binIds);
        ((Neurons.Input)this._neurons[0]).setInput(seed, r2.isSparse() ? r2.numIds : null, r2.numVals, r2.nBins, r2.binIds, mb);
    }

    @Override
    public void processMiniBatch(long seed, double[] responses, double[] offsets, int n2) {
        assert (this._training);
        seed = this._localmodel.get_params()._reproducible ? (seed += this._localmodel.get_processed_global()) : this._dropout_rng.nextLong();
        DeepLearningTask.fpropMiniBatch(seed, this._neurons, this._localmodel, this._localmodel.get_params()._elastic_averaging ? this._sharedmodel : null, this._training, responses, offsets, n2);
        DeepLearningTask.bpropMiniBatch(this._neurons, n2);
    }

    public static void bpropMiniBatch(Neurons[] neurons, int n2) {
        neurons[neurons.length - 1].bpropOutputLayer(n2);
        for (int i2 = neurons.length - 2; i2 > 0; --i2) {
            neurons[i2].bprop(n2);
        }
        for (int mb = 0; mb < n2; ++mb) {
            for (int i3 = 0; i3 < neurons.length; ++i3) {
                Storage.DenseVector e2;
                Storage.DenseVector denseVector = e2 = neurons[i3]._e == null ? null : neurons[i3]._e[mb];
                if (e2 == null) continue;
                Arrays.fill(e2.raw(), 0.0);
            }
        }
    }

    @Override
    protected int getMiniBatchSize() {
        return this._localmodel.get_params()._mini_batch_size;
    }

    @Override
    protected void chunkDone(long n2) {
        if (this._training) {
            this._localmodel.add_processed_local(n2);
        }
    }

    @Override
    protected void closeLocal() {
        if (this._localmodel.get_params()._elastic_averaging) {
            DKV.put(this._localmodel.localModelInfoKey(H2O.SELF), this._localmodel, this._fs);
        }
        this._sharedmodel = null;
    }

    @Override
    public void reduce(DeepLearningTask other) {
        if (this._localmodel != null && other._localmodel != null && other._localmodel.get_processed_local() > 0L && other._localmodel != this._localmodel) {
            if (this._localmodel.get_processed_local() == 0L) {
                this._localmodel = other._localmodel;
                this._chunk_node_count = other._chunk_node_count;
            } else {
                this._localmodel.add(other._localmodel);
                this._chunk_node_count += other._chunk_node_count;
            }
            if (other._localmodel.isUnstable()) {
                this._localmodel.setUnstable();
            }
        }
    }

    @Override
    protected void postGlobal() {
        DeepLearningModel.DeepLearningParameters dlp = this._localmodel.get_params();
        if (H2O.CLOUD.size() > 1 && !dlp._replicate_training_data) {
            long now = System.currentTimeMillis();
            if (this._chunk_node_count < H2O.CLOUD.size() && now - _lastWarn > 5000L && _warnCount < 3L) {
                Log.warn(H2O.CLOUD.size() - this._chunk_node_count + " node(s) (out of " + H2O.CLOUD.size() + ") are not contributing to model updates. Consider setting replicate_training_data to true or using a larger training dataset (or fewer H2O nodes).");
                _lastWarn = now;
                ++_warnCount;
            }
        }
        assert ((!dlp._replicate_training_data || H2O.CLOUD.size() == 1) == !this._run_local);
        if (!this._run_local) {
            this._localmodel.add_processed_global(this._localmodel.get_processed_local());
            this._localmodel.set_processed_local(0L);
            if (this._chunk_node_count > 1) {
                this._localmodel.div(this._chunk_node_count);
            }
            if (this._localmodel.get_params()._elastic_averaging) {
                this._sharedmodel = DeepLearningModelInfo.timeAverage(this._localmodel);
            }
        } else {
            this._sharedmodel = this._localmodel;
        }
        if (this._sharedmodel == null) {
            this._sharedmodel = this._localmodel;
        }
        this._localmodel = null;
    }

    public static Neurons[] makeNeuronsForTraining(DeepLearningModelInfo minfo) {
        return DeepLearningTask.makeNeurons(minfo, true);
    }

    public static Neurons[] makeNeuronsForTesting(DeepLearningModelInfo minfo) {
        return DeepLearningTask.makeNeurons(minfo, false);
    }

    private static Neurons[] makeNeurons(DeepLearningModelInfo minfo, boolean training) {
        int i2;
        DataInfo dinfo = minfo.data_info();
        DeepLearningModel.DeepLearningParameters params = minfo.get_params();
        int[] h2 = params._hidden;
        Neurons[] neurons = new Neurons[h2.length + 2];
        neurons[0] = new Neurons.Input(params, minfo.units[0], dinfo);
        block10: for (i2 = 0; i2 < h2.length + (params._autoencoder ? 1 : 0); ++i2) {
            int n2 = params._autoencoder && i2 == h2.length ? minfo.units[0] : h2[i2];
            switch (params._activation) {
                case Tanh: {
                    neurons[i2 + 1] = new Neurons.Tanh(n2);
                    continue block10;
                }
                case TanhWithDropout: {
                    neurons[i2 + 1] = params._autoencoder && i2 == h2.length ? new Neurons.Tanh(n2) : new Neurons.TanhDropout(n2);
                    continue block10;
                }
                case Rectifier: {
                    neurons[i2 + 1] = new Neurons.Rectifier(n2);
                    continue block10;
                }
                case RectifierWithDropout: {
                    neurons[i2 + 1] = params._autoencoder && i2 == h2.length ? new Neurons.Rectifier(n2) : new Neurons.RectifierDropout(n2);
                    continue block10;
                }
                case Maxout: {
                    neurons[i2 + 1] = new Neurons.Maxout(params, 2, n2);
                    continue block10;
                }
                case MaxoutWithDropout: {
                    neurons[i2 + 1] = params._autoencoder && i2 == h2.length ? new Neurons.Maxout(params, 2, n2) : new Neurons.MaxoutDropout(params, 2, n2);
                    continue block10;
                }
                case ExpRectifier: {
                    neurons[i2 + 1] = new Neurons.ExpRectifier(n2);
                    continue block10;
                }
                case ExpRectifierWithDropout: {
                    neurons[i2 + 1] = params._autoencoder && i2 == h2.length ? new Neurons.ExpRectifier(n2) : new Neurons.ExpRectifierDropout(n2);
                }
            }
        }
        if (!params._autoencoder) {
            neurons[neurons.length - 1] = minfo._classification && minfo.get_params()._distribution != DistributionFamily.modified_huber ? new Neurons.Softmax(minfo.units[minfo.units.length - 1]) : new Neurons.Linear();
        }
        for (i2 = 0; i2 < neurons.length; ++i2) {
            neurons[i2].init(neurons, i2, params, minfo, training);
            neurons[i2]._input = neurons[0];
        }
        return neurons;
    }

    public static void fpropMiniBatch(long seed, Neurons[] neurons, DeepLearningModelInfo minfo, DeepLearningModelInfo consensus_minfo, boolean training, double[] responses, double[] offset, int n2) {
        for (int i2 = 1; i2 < neurons.length; ++i2) {
            neurons[i2].fprop(seed, training, n2);
        }
        for (int mb = 0; mb < n2; ++mb) {
            if (offset != null && offset[mb] > 0.0) {
                assert (!minfo._classification);
                double[] m4 = minfo.data_info()._normRespMul;
                double[] s2 = minfo.data_info()._normRespSub;
                double mul = m4 == null ? 1.0 : m4[0];
                double sub = s2 == null ? 0.0 : s2[0];
                neurons[neurons.length - 1]._a[mb].add(0, (offset[mb] - sub) * mul);
            }
            if (!training) continue;
            neurons[neurons.length - 1].setOutputLayerGradient(responses[mb], mb, n2);
            if (consensus_minfo == null) continue;
            for (int i3 = 1; i3 < neurons.length; ++i3) {
                neurons[i3]._wEA = consensus_minfo.get_weights(i3 - 1);
                neurons[i3]._bEA = consensus_minfo.get_biases(i3 - 1);
            }
        }
    }
}

