/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.Model;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.Neurons;
import hex.deeplearning.Storage;
import hex.genmodel.utils.DistributionFamily;
import java.util.Arrays;
import java.util.Random;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.IcedUtils;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.PrettyPrint;
import water.util.RandomBase;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public final class DeepLearningModelInfo
extends Iced<DeepLearningModelInfo> {
    public TwoDimTable summaryTable;
    public DataInfo data_info;
    private Storage.DenseRowMatrix[] dense_row_weights;
    private Storage.DenseVector[] biases;
    private Storage.DenseVector[] avg_activations;
    private Storage.DenseRowMatrix[] dense_row_weights_momenta;
    private Storage.DenseVector[] biases_momenta;
    private Storage.DenseRowMatrix[] dense_row_ada_dx_g;
    private Storage.DenseVector[] biases_ada_dx_g;
    private boolean[] _saw_missing_cats;
    public DeepLearningModel.DeepLearningParameters parameters;
    Key<Model> _model_id;
    private double[] mean_rate;
    private double[] rms_rate;
    private double[] mean_bias;
    private double[] rms_bias;
    private double[] mean_weight;
    public double[] rms_weight;
    public double[] mean_a;
    private volatile boolean unstable = false;
    private long processed_global;
    private long processed_local;
    int[] units;
    final boolean _classification;
    final Frame _train;
    final Frame _valid;
    public static GradientCheck gradientCheck = null;
    public static GradientCheck gradientCheckBias = null;

    public DataInfo data_info() {
        return this.data_info;
    }

    public long size() {
        long siz = 0L;
        for (Storage.DenseRowMatrix denseRowMatrix : this.dense_row_weights) {
            if (denseRowMatrix == null) continue;
            siz += denseRowMatrix.size();
        }
        for (Iced iced : this.biases) {
            siz += (long)iced.size();
        }
        return siz;
    }

    void checkMissingCats(int[] cats) {
        if (cats == null) {
            return;
        }
        if (this._saw_missing_cats == null) {
            return;
        }
        for (int i2 = 0; i2 < cats.length; ++i2) {
            assert (this.data_info._catMissing[i2]);
            if (this._saw_missing_cats[i2]) continue;
            this._saw_missing_cats[i2] = cats[i2] == this.data_info._catOffsets[i2 + 1] - 1;
        }
    }

    boolean has_momenta() {
        return this.get_params()._momentum_start != 0.0 || this.get_params()._momentum_stable != 0.0;
    }

    boolean adaDelta() {
        return this.get_params()._adaptive_rate;
    }

    public final Storage.DenseRowMatrix get_weights(int i2) {
        return this.dense_row_weights[i2];
    }

    public final Storage.DenseVector get_biases(int i2) {
        return this.biases[i2];
    }

    public final Storage.DenseRowMatrix get_weights_momenta(int i2) {
        return this.dense_row_weights_momenta[i2];
    }

    public final Storage.DenseVector get_biases_momenta(int i2) {
        return this.biases_momenta[i2];
    }

    public final Storage.DenseRowMatrix get_ada_dx_g(int i2) {
        return this.dense_row_ada_dx_g[i2];
    }

    public final Storage.DenseVector get_biases_ada_dx_g(int i2) {
        return this.biases_ada_dx_g[i2];
    }

    public final Storage.DenseVector get_avg_activations(int i2) {
        return this.avg_activations[i2];
    }

    public final DeepLearningModel.DeepLearningParameters get_params() {
        return this.parameters;
    }

    public final void set_params(DeepLearningModel.DeepLearningParameters p2, Key<Model> model_id) {
        this.parameters = (DeepLearningModel.DeepLearningParameters)p2.clone();
        this._model_id = model_id;
    }

    public boolean isUnstable() {
        return this.unstable;
    }

    public void setUnstable() {
        if (!this.unstable) {
            this.computeStats();
        }
        this.unstable = true;
    }

    public synchronized long get_processed_global() {
        return this.processed_global;
    }

    public synchronized void set_processed_global(long p2) {
        this.processed_global = p2;
    }

    public synchronized void add_processed_global(long p2) {
        this.processed_global += p2;
    }

    public synchronized long get_processed_local() {
        return this.processed_local;
    }

    public synchronized void set_processed_local(long p2) {
        this.processed_local = p2;
    }

    public synchronized void add_processed_local(long p2) {
        this.processed_local += p2;
    }

    public synchronized long get_processed_total() {
        return this.processed_global + this.processed_local;
    }

    private DeepLearningModelInfo() {
        this._classification = false;
        this._valid = null;
        this._train = null;
    }

    public DeepLearningModelInfo(DeepLearningModel.DeepLearningParameters params, Key model_id, DataInfo dinfo, int nClasses, Frame train, Frame valid) {
        int i2;
        boolean warn;
        int num_output;
        this._classification = nClasses > 1;
        this._train = train;
        this._valid = valid;
        this.data_info = dinfo;
        this.parameters = (DeepLearningModel.DeepLearningParameters)params.clone();
        this._model_id = model_id;
        DeepLearningModel.DeepLearningParameters.Sanity.modifyParms(this.parameters, this.parameters, nClasses);
        int num_input = dinfo.fullN();
        int n2 = this.get_params()._autoencoder ? num_input : (num_output = this._classification && this.parameters._distribution != DistributionFamily.modified_huber ? train.vec(this.parameters._response_column).cardinality() : 1);
        if (!this.get_params()._autoencoder) assert (num_output == nClasses || this.parameters._distribution == DistributionFamily.modified_huber);
        boolean[] blArray = this._saw_missing_cats = dinfo._cats > 0 ? new boolean[this.data_info._cats] : null;
        assert (num_input > 0);
        assert (num_output > 0);
        if (this.has_momenta() && this.adaDelta()) {
            throw new IllegalArgumentException("Cannot have non-zero momentum and adaptive rate at the same time.");
        }
        int layers = this.get_params()._hidden.length;
        this.units = new int[layers + 2];
        this.units[0] = this.get_params()._max_categorical_features <= Integer.MAX_VALUE - dinfo._nums ? Math.min(dinfo._nums + this.get_params()._max_categorical_features, num_input) : num_input;
        System.arraycopy(this.get_params()._hidden, 0, this.units, 1, layers);
        this.units[layers + 1] = num_output;
        boolean printLevels = (long)this.units[0] > 1000L;
        boolean bl = warn = (long)this.units[0] > 100000L;
        if (printLevels) {
            String[][] domains = dinfo._adaptedFrame.domains();
            if (warn) {
                Log.warn("===================================================================================================================================");
                Log.warn(num_input + " input features" + (dinfo._cats > 0 ? " (after categorical one-hot encoding)" : "") + ". Can be slow and require a lot of memory.");
            }
            FrameUtils.printTopCategoricalLevels(dinfo._adaptedFrame, warn, 10);
            if (warn) {
                Log.warn("Suggestions:");
                Log.warn(" *) Limit the size of the first hidden layer");
                if (dinfo._cats > 0) {
                    Log.warn(" *) Limit the total number of one-hot encoded features by setting 'categorical_encoding=\"enum_limited\"'");
                    Log.warn(" *) Limit the total number of one-hot encoded features with the parameter 'max_categorical_features' (experimental)");
                    Log.warn(" *) Run h2o.interaction(...,pairwise=F) on high-cardinality categorical columns to limit the factor count, see http://docs.h2o.ai/h2o/latest-stable/h2o-docs/data-science/deep-learning.html#faq");
                }
                Log.warn("===================================================================================================================================");
            }
        }
        int[] mult = new int[layers + 1];
        for (i2 = 0; i2 < layers; ++i2) {
            mult[i2] = this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.Maxout || this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout ? 2 : 1;
        }
        mult[layers] = 1;
        this.dense_row_weights = new Storage.DenseRowMatrix[layers + 1];
        this.dense_row_weights[0] = new Storage.DenseRowMatrix(mult[0] * this.units[1], this.units[0]);
        for (i2 = 1; i2 <= layers; ++i2) {
            this.dense_row_weights[i2] = new Storage.DenseRowMatrix(mult[i2] * this.units[i2 + 1], this.units[i2]);
        }
        this.biases = new Storage.DenseVector[layers + 1];
        for (i2 = 0; i2 <= layers; ++i2) {
            this.biases[i2] = new Storage.DenseVector(mult[i2] * this.units[i2 + 1]);
        }
        if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
            this.avg_activations = new Storage.DenseVector[layers];
            this.mean_a = new double[layers];
            for (i2 = 0; i2 < layers; ++i2) {
                this.avg_activations[i2] = new Storage.DenseVector(mult[i2] * this.units[i2 + 1]);
            }
        }
        this.allocateHelperArrays();
        this.mean_rate = new double[this.units.length - 1];
        this.rms_rate = new double[this.units.length - 1];
        this.mean_bias = new double[this.units.length - 1];
        this.rms_bias = new double[this.units.length - 1];
        this.mean_weight = new double[this.units.length - 1];
        this.rms_weight = new double[this.units.length - 1];
    }

    void allocateHelperArrays() {
        block7: {
            int i2;
            int[] mult;
            block6: {
                mult = new int[this.units.length - 1];
                for (i2 = 0; i2 < this.units.length - 1; ++i2) {
                    mult[i2] = this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.Maxout || this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout ? 2 : 1;
                }
                mult[this.units.length - 2] = 1;
                if (!this.has_momenta()) break block6;
                this.dense_row_weights_momenta = new Storage.DenseRowMatrix[this.dense_row_weights.length];
                if (this.dense_row_weights[0] != null) {
                    this.dense_row_weights_momenta[0] = new Storage.DenseRowMatrix(mult[0] * this.units[1], this.units[0]);
                }
                for (i2 = 1; i2 < this.dense_row_weights_momenta.length; ++i2) {
                    this.dense_row_weights_momenta[i2] = new Storage.DenseRowMatrix(mult[i2] * this.units[i2 + 1], this.units[i2]);
                }
                this.biases_momenta = new Storage.DenseVector[this.biases.length];
                for (i2 = 0; i2 < this.biases_momenta.length; ++i2) {
                    this.biases_momenta[i2] = new Storage.DenseVector(mult[i2] * this.units[i2 + 1]);
                }
                break block7;
            }
            if (!this.adaDelta()) break block7;
            this.dense_row_ada_dx_g = new Storage.DenseRowMatrix[this.dense_row_weights.length];
            this.dense_row_ada_dx_g[0] = new Storage.DenseRowMatrix(mult[0] * 2 * this.units[1], this.units[0]);
            for (i2 = 1; i2 < this.dense_row_ada_dx_g.length; ++i2) {
                this.dense_row_ada_dx_g[i2] = new Storage.DenseRowMatrix(mult[i2] * this.units[i2 + 1], 2 * this.units[i2]);
            }
            this.biases_ada_dx_g = new Storage.DenseVector[this.biases.length];
            for (i2 = 0; i2 < this.biases_ada_dx_g.length; ++i2) {
                this.biases_ada_dx_g[i2] = new Storage.DenseVector(mult[i2] * 2 * this.units[i2 + 1]);
            }
        }
    }

    TwoDimTable createSummaryTable() {
        this.computeStats();
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this);
        long byte_size = new AutoBuffer().put(this).buf().length;
        TwoDimTable table = new TwoDimTable("Status of Neuron Layers", (!this.get_params()._autoencoder ? "predicting " + this.data_info._adaptedFrame.lastVecName() + ", " : "") + (this.get_params()._autoencoder ? "auto-encoder" : (this._classification ? this.units[this.units.length - 1] + "-class classification" : "regression")) + ", " + (Object)((Object)this.get_params()._distribution) + " distribution, " + (Object)((Object)this.get_params()._loss) + " loss, " + String.format("%,d", this.size()) + " weights/biases, " + PrettyPrint.bytes(byte_size) + ", " + String.format("%,d", this.get_processed_global()) + " training samples, mini-batch size " + String.format("%,d", this.get_params()._mini_batch_size), new String[neurons.length], new String[]{"Layer", "Units", "Type", "Dropout", "L1", "L2", "Mean Rate", "Rate RMS", "Momentum", "Mean Weight", "Weight RMS", "Mean Bias", "Bias RMS"}, new String[]{"int", "int", "string", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double"}, new String[]{"%d", "%d", "%s", "%2.2f %%", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f"}, "");
        for (int i2 = 0; i2 < neurons.length; ++i2) {
            table.set(i2, 0, i2 + 1);
            table.set(i2, 1, neurons[i2].units);
            table.set(i2, 2, neurons[i2].getClass().getSimpleName());
            if (i2 == 0) {
                table.set(i2, 3, neurons[i2].params._input_dropout_ratio * 100.0);
                continue;
            }
            if (i2 < neurons.length - 1) {
                if (neurons[i2].params._hidden_dropout_ratios == null) {
                    table.set(i2, 3, 0);
                } else {
                    table.set(i2, 3, neurons[i2].params._hidden_dropout_ratios[i2 - 1] * 100.0);
                }
            }
            table.set(i2, 4, neurons[i2].params._l1);
            table.set(i2, 5, neurons[i2].params._l2);
            table.set(i2, 6, this.get_params()._adaptive_rate ? this.mean_rate[i2 - 1] : (double)neurons[i2].rate(this.get_processed_total()));
            table.set(i2, 7, this.get_params()._adaptive_rate ? this.rms_rate[i2 - 1] : 0.0);
            table.set(i2, 8, Float.valueOf(this.get_params()._adaptive_rate ? 0.0f : neurons[i2].momentum(this.get_processed_total())));
            table.set(i2, 9, this.mean_weight[i2 - 1]);
            table.set(i2, 10, this.rms_weight[i2 - 1]);
            table.set(i2, 11, this.mean_bias[i2 - 1]);
            table.set(i2, 12, this.rms_bias[i2 - 1]);
        }
        this.summaryTable = table;
        return this.summaryTable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.get_params()._quiet_mode) {
            if (this.get_params()._sparsity_beta > 0.0) {
                for (int k2 = 0; k2 < this.get_params()._hidden.length; ++k2) {
                    sb.append("Average activation in hidden layer ").append(k2).append(" is  ").append(this.mean_a[k2]).append(" \n");
                }
            }
            this.createSummaryTable();
            sb.append(this.summaryTable.toString(1));
        }
        return sb.toString();
    }

    public String toStringAll() {
        int i2;
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        for (i2 = 0; i2 < this.units.length - 1; ++i2) {
            sb.append("\nweights[").append(i2).append("][]=").append(Arrays.toString(this.get_weights(i2).raw()));
        }
        for (i2 = 0; i2 < this.units.length - 1; ++i2) {
            sb.append("\nbiases[").append(i2).append("][]=").append(Arrays.toString(this.get_biases(i2).raw()));
        }
        if (this.has_momenta()) {
            for (i2 = 0; i2 < this.units.length - 1; ++i2) {
                sb.append("\nweights_momenta[").append(i2).append("][]=").append(Arrays.toString(this.get_weights_momenta(i2).raw()));
            }
        }
        if (this.biases_momenta != null) {
            for (i2 = 0; i2 < this.units.length - 1; ++i2) {
                sb.append("\nbiases_momenta[").append(i2).append("][]=").append(Arrays.toString(this.biases_momenta[i2].raw()));
            }
        }
        sb.append("\nunits[]=").append(Arrays.toString(this.units));
        sb.append("\nprocessed global: ").append(this.get_processed_global());
        sb.append("\nprocessed local:  ").append(this.get_processed_local());
        sb.append("\nprocessed total:  ").append(this.get_processed_total());
        sb.append("\n");
        return sb.toString();
    }

    void initializeMembers(Key<Frame>[] initial_weights, Key<Frame>[] initial_biases) {
        int i2;
        this.randomizeWeights();
        for (i2 = 0; i2 < this.get_params()._hidden.length; ++i2) {
            if (this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.Rectifier || this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout || this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.Maxout || this.get_params()._activation == DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout) {
                Arrays.fill(this.biases[i2].raw(), i2 == 0 ? 0.5 : 1.0);
                continue;
            }
            if (this.get_params()._activation != DeepLearningModel.DeepLearningParameters.Activation.Tanh && this.get_params()._activation != DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout) continue;
            Arrays.fill(this.biases[i2].raw(), 0.0);
        }
        Arrays.fill(this.biases[this.biases.length - 1].raw(), 0.0);
        if (initial_weights != null || initial_biases != null) {
            Log.info("Initializing initial model state from user-given weights/biases.");
            for (i2 = 0; i2 < this.get_params()._hidden.length + 1; ++i2) {
                if (initial_weights[i2] == null) {
                    Log.info("No user-given weight matrix given for weights #" + (i2 + 1) + ". Initializing those weights randomly.");
                    continue;
                }
                if (initial_biases[i2] == null) {
                    Log.info("No user-given bias vector given for biases #" + (i2 + 1) + ". Initializing those biases randomly.");
                    continue;
                }
                Frame w2 = initial_weights[i2].get();
                if (w2 == null) {
                    throw new IllegalArgumentException("User-given weight matrix for weights #" + (i2 + 1) + " '" + initial_weights[i2].toString() + "' not found. Initializing those weights randomly.");
                }
                if (w2.numRows() != (long)this.get_weights(i2).rows() || w2.numCols() != this.get_weights(i2).cols()) {
                    throw new IllegalArgumentException("Dimensionality mismatch: initial_weights matrix #" + i2 + " should have " + this.get_weights(i2).rows() + " rows and " + this.get_weights(i2).cols() + " columns, but has " + w2.numRows() + " rows and " + w2.numCols() + " columns.");
                }
                Frame b2 = initial_biases[i2].get();
                if (b2 == null) {
                    throw new IllegalArgumentException("User-given bias vector for biases #" + (i2 + 1) + " '" + initial_biases[i2].toString() + "' not found. Initializing those biases randomly.");
                }
                if (b2.numRows() != (long)this.get_biases(i2).size() || b2.numCols() != 1) {
                    throw new IllegalArgumentException("Dimensionality mismatch: initial_biases vector #" + i2 + " should have " + this.get_biases(i2).size() + " rows and 1 column, but has " + b2.numRows() + " rows and " + b2.numCols() + " column(s).");
                }
                for (int c2 = 0; c2 < w2.numCols(); ++c2) {
                    int r2 = 0;
                    while ((long)r2 < w2.numRows()) {
                        this.get_weights(i2).set(r2, c2, (float)w2.vec(c2).at(r2));
                        ++r2;
                    }
                }
                int r3 = 0;
                while ((long)r3 < w2.numRows()) {
                    this.get_biases(i2).set(r3, (float)b2.vec(0).at(r3));
                    ++r3;
                }
            }
        } else {
            Log.info("Created random initial model state.");
        }
    }

    void initializeFromPretrainedModel(DeepLearningModelInfo autoencoder) {
        assert (autoencoder.parameters._autoencoder);
        this.randomizeWeights();
        for (int w2 = 0; w2 < this.dense_row_weights.length - 1; ++w2) {
            if (this.get_weights(w2).rows() != autoencoder.get_weights(w2).rows()) {
                throw new IllegalArgumentException("Mismatch between weights in pretrained model and this model: rows in layer " + w2 + ": " + autoencoder.get_weights(w2).rows() + " vs " + this.get_weights(w2).rows() + ". Enable ignored_const_cols for both models and/or check categorical levels for consistency.");
            }
            if (this.get_weights(w2).cols() != autoencoder.get_weights(w2).cols()) {
                throw new IllegalArgumentException("Mismatch between weights in pretrained model and this model: cols in layer " + w2 + ": " + autoencoder.get_weights(w2).cols() + " vs " + this.get_weights(w2).cols() + ". Enable ignored_const_cols for both models and/or check categorical levels for consistency.");
            }
            for (int i2 = 0; i2 < this.get_weights(w2).rows(); ++i2) {
                for (int j2 = 0; j2 < this.get_weights(w2).cols(); ++j2) {
                    this.get_weights(w2).set(i2, j2, autoencoder.get_weights(w2).get(i2, j2));
                }
            }
        }
        for (int i3 = 0; i3 < this.get_params()._hidden.length; ++i3) {
            for (int j3 = 0; j3 < this.biases[i3].raw().length; ++j3) {
                this.biases[i3].set(j3, autoencoder.biases[i3].get(j3));
            }
        }
        Arrays.fill(this.biases[this.biases.length - 1].raw(), 0.0);
    }

    public void add(DeepLearningModelInfo other) {
        int i2;
        for (i2 = 0; i2 < this.dense_row_weights.length; ++i2) {
            ArrayUtils.add(this.get_weights(i2).raw(), other.get_weights(i2).raw());
        }
        for (i2 = 0; i2 < this.biases.length; ++i2) {
            ArrayUtils.add(this.biases[i2].raw(), other.biases[i2].raw());
        }
        if (this.avg_activations != null) {
            for (i2 = 0; i2 < this.avg_activations.length; ++i2) {
                ArrayUtils.add(this.avg_activations[i2].raw(), other.biases[i2].raw());
            }
        }
        if (this.has_momenta()) {
            assert (other.has_momenta());
            for (i2 = 0; i2 < this.dense_row_weights_momenta.length; ++i2) {
                ArrayUtils.add(this.get_weights_momenta(i2).raw(), other.get_weights_momenta(i2).raw());
            }
            for (i2 = 0; i2 < this.biases_momenta.length; ++i2) {
                ArrayUtils.add(this.biases_momenta[i2].raw(), other.biases_momenta[i2].raw());
            }
        }
        if (this.adaDelta()) {
            assert (other.adaDelta());
            for (i2 = 0; i2 < this.dense_row_ada_dx_g.length; ++i2) {
                ArrayUtils.add(this.get_ada_dx_g(i2).raw(), other.get_ada_dx_g(i2).raw());
            }
        }
        this.add_processed_local(other.get_processed_local());
    }

    protected void mult(double N2) {
        this.div(1.0 / N2);
    }

    protected void div(double N2) {
        for (int i2 = 0; i2 < this.dense_row_weights.length; ++i2) {
            ArrayUtils.div(this.get_weights(i2).raw(), (float)N2);
        }
        for (Storage.DenseVector bias : this.biases) {
            ArrayUtils.div(bias.raw(), N2);
        }
        if (this.avg_activations != null) {
            for (Storage.DenseVector avgac : this.avg_activations) {
                ArrayUtils.div(avgac.raw(), N2);
            }
        }
        if (this.has_momenta()) {
            for (int i3 = 0; i3 < this.dense_row_weights_momenta.length; ++i3) {
                ArrayUtils.div(this.get_weights_momenta(i3).raw(), (float)N2);
            }
            for (Storage.DenseVector bias_momenta : this.biases_momenta) {
                ArrayUtils.div(bias_momenta.raw(), N2);
            }
        }
        if (this.adaDelta()) {
            for (int i4 = 0; i4 < this.dense_row_ada_dx_g.length; ++i4) {
                ArrayUtils.div(this.get_ada_dx_g(i4).raw(), (float)N2);
            }
        }
    }

    double uniformDist(Random rand, double min2, double max) {
        return min2 + (double)rand.nextFloat() * (max - min2);
    }

    private void randomizeWeights() {
        for (int w2 = 0; w2 < this.dense_row_weights.length; ++w2) {
            RandomBase rng = RandomUtils.getRNG(this.get_params()._seed + 195911405L + (long)w2 + 1L);
            double range = Math.sqrt(6.0 / (double)(this.units[w2] + this.units[w2 + 1]));
            for (int i2 = 0; i2 < this.get_weights(w2).rows(); ++i2) {
                for (int j2 = 0; j2 < this.get_weights(w2).cols(); ++j2) {
                    if (this.get_params()._initial_weight_distribution == DeepLearningModel.DeepLearningParameters.InitialWeightDistribution.UniformAdaptive) {
                        if (w2 == this.dense_row_weights.length - 1 && this._classification) {
                            this.get_weights(w2).set(i2, j2, (float)(4.0 * this.uniformDist(rng, -range, range)));
                            continue;
                        }
                        this.get_weights(w2).set(i2, j2, (float)this.uniformDist(rng, -range, range));
                        continue;
                    }
                    if (this.get_params()._initial_weight_distribution == DeepLearningModel.DeepLearningParameters.InitialWeightDistribution.Uniform) {
                        this.get_weights(w2).set(i2, j2, (float)this.uniformDist(rng, -this.get_params()._initial_weight_scale, this.get_params()._initial_weight_scale));
                        continue;
                    }
                    if (this.get_params()._initial_weight_distribution != DeepLearningModel.DeepLearningParameters.InitialWeightDistribution.Normal) continue;
                    this.get_weights(w2).set(i2, j2, (float)(rng.nextGaussian() * this.get_params()._initial_weight_scale));
                }
            }
        }
    }

    public float[] computeVariableImportances() {
        int i2;
        float[] vi = new float[this.units[0]];
        Arrays.fill(vi, 0.0f);
        if (this.units.length == 2) {
            for (i2 = 0; i2 < this.units[0]; ++i2) {
                for (int j2 = 0; j2 < this.units[1]; ++j2) {
                    float wij = this.get_weights(0).get(j2, i2);
                    int n2 = i2;
                    vi[n2] = vi[n2] + Math.abs(wij);
                }
            }
        } else {
            int i3;
            int k2;
            float[][] Qik = new float[this.units[0]][this.units[2]];
            float[] sum_wj = new float[this.units[1]];
            float[] sum_wk = new float[this.units[2]];
            for (float[] Qi : Qik) {
                Arrays.fill(Qi, 0.0f);
            }
            Arrays.fill(sum_wj, 0.0f);
            Arrays.fill(sum_wk, 0.0f);
            for (int j3 = 0; j3 < this.units[1]; ++j3) {
                for (int i4 = 0; i4 < this.units[0]; ++i4) {
                    float wij = this.get_weights(0).get(j3, i4);
                    int n3 = j3;
                    sum_wj[n3] = sum_wj[n3] + Math.abs(wij);
                }
            }
            for (k2 = 0; k2 < this.units[2]; ++k2) {
                for (int j4 = 0; j4 < this.units[1]; ++j4) {
                    float wjk = this.get_weights(1).get(k2, j4);
                    int n4 = k2;
                    sum_wk[n4] = sum_wk[n4] + Math.abs(wjk);
                }
            }
            for (i3 = 0; i3 < this.units[0]; ++i3) {
                for (int k3 = 0; k3 < this.units[2]; ++k3) {
                    for (int j5 = 0; j5 < this.units[1]; ++j5) {
                        float wij = this.get_weights(0).get(j5, i3);
                        float wjk = this.get_weights(1).get(k3, j5);
                        float[] fArray = Qik[i3];
                        int n5 = k3;
                        fArray[n5] = fArray[n5] + Math.abs(wij) / sum_wj[j5] * Math.abs(wjk) / sum_wk[k3];
                    }
                }
            }
            for (k2 = 0; k2 < this.units[2]; ++k2) {
                int i5;
                float sumQk = 0.0f;
                for (i5 = 0; i5 < this.units[0]; ++i5) {
                    sumQk += Qik[i5][k2];
                }
                for (i5 = 0; i5 < this.units[0]; ++i5) {
                    float[] fArray = Qik[i5];
                    int n6 = k2;
                    fArray[n6] = fArray[n6] / sumQk;
                }
            }
            for (i3 = 0; i3 < this.units[0]; ++i3) {
                vi[i3] = ArrayUtils.sum(Qik[i3]);
            }
        }
        ArrayUtils.div(vi, ArrayUtils.maxValue(vi));
        if (this._saw_missing_cats != null) {
            for (i2 = 0; i2 < this._saw_missing_cats.length; ++i2) {
                assert (this.data_info._catMissing[i2]);
                if (this._saw_missing_cats[i2]) continue;
                vi[this.data_info._catOffsets[i2 + 1] - 1] = 0.0f;
            }
        }
        return vi;
    }

    public void computeStats() {
        float[][] rate = this.get_params()._adaptive_rate ? (Object)new float[this.units.length - 1][] : (float[][])null;
        Object object = rate;
        if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
            for (int k2 = 0; k2 < this.get_params()._hidden.length; ++k2) {
                this.mean_a[k2] = 0.0;
                for (int j2 = 0; j2 < this.avg_activations[k2].size(); ++j2) {
                    int n2 = k2;
                    this.mean_a[n2] = this.mean_a[n2] + this.avg_activations[k2].get(j2);
                }
                int n3 = k2;
                this.mean_a[n3] = this.mean_a[n3] / (double)this.avg_activations[k2].size();
            }
        }
        for (int y2 = 0; y2 < this.units.length - 1; ++y2) {
            int u2;
            this.rms_rate[y2] = 0.0;
            this.mean_rate[y2] = 0.0;
            this.rms_bias[y2] = 0.0;
            this.mean_bias[y2] = 0.0;
            this.rms_weight[y2] = 0.0;
            this.mean_weight[y2] = 0.0;
            for (u2 = 0; u2 < this.biases[y2].size(); ++u2) {
                int n4 = y2;
                this.mean_bias[n4] = this.mean_bias[n4] + this.biases[y2].get(u2);
            }
            if (rate != null) {
                rate[y2] = new float[this.get_weights(y2).raw().length];
            }
            for (u2 = 0; u2 < this.get_weights(y2).raw().length; ++u2) {
                int n5 = y2;
                this.mean_weight[n5] = this.mean_weight[n5] + (double)this.get_weights(y2).raw()[u2];
                if (rate == null) continue;
                float RMS_dx = MathUtils.approxSqrt(this.get_ada_dx_g(y2).raw()[2 * u2] + (float)this.get_params()._epsilon);
                float invRMS_g = MathUtils.approxInvSqrt(this.get_ada_dx_g(y2).raw()[2 * u2 + 1] + (float)this.get_params()._epsilon);
                rate[y2][u2] = RMS_dx * invRMS_g;
                int n6 = y2;
                this.mean_rate[n6] = this.mean_rate[n6] + (double)rate[y2][u2];
            }
            int n7 = y2;
            this.mean_bias[n7] = this.mean_bias[n7] / (double)this.biases[y2].size();
            int n8 = y2;
            this.mean_weight[n8] = this.mean_weight[n8] / (double)this.get_weights(y2).size();
            if (rate != null) {
                int n9 = y2;
                this.mean_rate[n9] = this.mean_rate[n9] / (double)rate[y2].length;
            }
            for (u2 = 0; u2 < this.biases[y2].size(); ++u2) {
                double db = this.biases[y2].get(u2) - this.mean_bias[y2];
                int n10 = y2;
                this.rms_bias[n10] = this.rms_bias[n10] + db * db;
            }
            u2 = 0;
            while ((long)u2 < this.get_weights(y2).size()) {
                double dw = (double)this.get_weights(y2).raw()[u2] - this.mean_weight[y2];
                int n11 = y2;
                this.rms_weight[n11] = this.rms_weight[n11] + dw * dw;
                if (rate != null) {
                    double drate = (double)rate[y2][u2] - this.mean_rate[y2];
                    int n12 = y2;
                    this.rms_rate[n12] = this.rms_rate[n12] + drate * drate;
                }
                ++u2;
            }
            this.rms_bias[y2] = MathUtils.approxSqrt(this.rms_bias[y2] / (double)this.biases[y2].size());
            this.rms_weight[y2] = MathUtils.approxSqrt(this.rms_weight[y2] / (double)this.get_weights(y2).size());
            if (rate != null) {
                this.rms_rate[y2] = MathUtils.approxSqrt(this.rms_rate[y2] / (double)rate[y2].length);
            }
            double thresh = 1.0E10;
            double bthresh = 100000.0;
            this.unstable |= Double.isNaN(this.mean_bias[y2]) || Double.isNaN(this.rms_bias[y2]) || Double.isNaN(this.mean_weight[y2]) || Double.isNaN(this.rms_weight[y2]) || Math.abs(this.mean_weight[y2]) > 1.0E10 || this.rms_weight[y2] > 1.0E10 || Math.abs(this.mean_bias[y2]) > 100000.0 || this.rms_bias[y2] > 100000.0;
        }
    }

    protected long checksum_impl() {
        this.computeStats();
        Random rng = new Random(-557122629L);
        double cs = Double.longBitsToDouble(this.get_params()._seed);
        cs += (double)(this.size() * this.get_processed_total());
        for (double d2 : this.mean_bias) {
            cs += rng.nextDouble() * (d2 + 123.23);
        }
        for (double d2 : this.rms_bias) {
            cs += rng.nextDouble() * (d2 + 123.23);
        }
        for (double d2 : this.mean_weight) {
            cs += rng.nextDouble() * (d2 + 123.23);
        }
        for (double d2 : this.rms_weight) {
            cs += rng.nextDouble() * (d2 + 123.23);
        }
        for (double d2 : this.mean_rate) {
            cs += rng.nextDouble() * (d2 + 123.23);
        }
        for (double d2 : this.rms_rate) {
            cs += rng.nextDouble() * (d2 + 123.23);
        }
        return Double.doubleToRawLongBits(cs);
    }

    public static DeepLearningModelInfo timeAverage(DeepLearningModelInfo nodeAverageModel) {
        float pa = (float)nodeAverageModel.get_params()._elastic_averaging_moving_rate;
        assert (pa > 0.0f && pa <= 1.0f);
        DeepLearningModelInfo elasticAverage = (DeepLearningModelInfo)DKV.getGet(nodeAverageModel.elasticAverageModelInfoKey());
        if (elasticAverage == null || pa == 1.0f) {
            elasticAverage = IcedUtils.deepCopy(nodeAverageModel);
        } else {
            nodeAverageModel.mult(pa);
            elasticAverage.mult(1.0f - pa);
            elasticAverage.add(nodeAverageModel);
            elasticAverage.set_processed_global(nodeAverageModel.get_processed_global());
        }
        elasticAverage.set_processed_local(0L);
        DKV.put(elasticAverage.elasticAverageModelInfoKey(), elasticAverage);
        return elasticAverage;
    }

    public Key localModelInfoKey(H2ONode node) {
        return Key.make(this._model_id + ".node" + node.index(), (byte)1, (byte)31, true, node);
    }

    public Key elasticAverageModelInfoKey() {
        return Key.make(this._model_id + ".elasticaverage", (byte)1, (byte)31, true, H2O.CLOUD._memary[0]);
    }

    public static class GradientCheck {
        int layer;
        int row;
        int col;
        double gradient;

        GradientCheck(int l2, int r2, int c2) {
            this.layer = l2;
            this.row = r2;
            this.col = c2;
            this.gradient = 0.0;
        }

        void apply(int l2, int r2, int c2, double g2) {
            if (r2 == this.row && c2 == this.col && l2 == this.layer) {
                this.gradient += g2;
            }
        }
    }
}

