/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;

public class Storage {
    private static Frame toFrame(Matrix m4, Key<Frame> key) {
        H2O.submitTask(new ConvertMatrixToFrame(m4, key)).join();
        Frame f2 = (Frame)DKV.getGet(key);
        assert (f2 != null);
        return f2;
    }

    private static class FillVec
    extends RecursiveAction {
        final Matrix _m;
        final Vec _v;
        final int _col;

        FillVec(Matrix m4, Vec v2, int col) {
            this._m = m4;
            this._v = v2;
            this._col = col;
        }

        @Override
        public void compute() {
            try (Vec.Writer vw = this._v.open();){
                for (int r2 = 0; r2 < this._m.rows(); ++r2) {
                    vw.set((long)r2, this._m.get(r2, this._col));
                }
            }
        }
    }

    private static class ConvertMatrixToFrame
    extends H2O.H2OCountedCompleter<ConvertMatrixToFrame> {
        private final Matrix _m;
        private final Key<Frame> _key;

        private ConvertMatrixToFrame(Matrix m4, Key<Frame> key) {
            this._m = m4;
            this._key = key;
        }

        @Override
        public void compute2() {
            int log_rows_per_chunk = Math.max(1, 22 - (int)Math.floor(Math.log(this._m.rows()) / Math.log(2.0)));
            Vec[] vs = new Vec[this._m.cols()];
            FillVec[] fv = new FillVec[this._m.cols()];
            for (int i2 = 0; i2 < this._m.cols(); ++i2) {
                vs[i2] = Vec.makeCon(0.0, (long)this._m.rows(), log_rows_per_chunk);
                fv[i2] = new FillVec(this._m, vs[i2], i2);
            }
            ForkJoinTask.invokeAll(fv);
            Frame f2 = new Frame(this._key, vs);
            DKV.put(this._key, f2);
            this.tryComplete();
        }
    }

    public static class DenseRowMatrix
    extends AbstractMatrix<DenseRowMatrix> {
        private double[] _data;
        private int _cols;
        private int _rows;

        DenseRowMatrix(int rows, int cols) {
            this(MemoryManager.malloc8d(cols * rows), rows, cols);
        }

        private DenseRowMatrix(double[] v2, int rows, int cols) {
            this._data = v2;
            this._rows = rows;
            this._cols = cols;
        }

        @Override
        public double get(int row, int col) {
            assert (row < this._rows && col < this._cols) : "_data.length: " + this._data.length + ", checking: " + row + " < " + this._rows + " && " + col + " < " + this._cols;
            return this._data[row * this._cols + col];
        }

        @Override
        public void set(int row, int col, double val) {
            assert (row < this._rows && col < this._cols);
            this._data[row * this._cols + col] = val;
        }

        @Override
        public void add(int row, int col, double val) {
            assert (row < this._rows && col < this._cols);
            int n2 = row * this._cols + col;
            this._data[n2] = this._data[n2] + val;
        }

        @Override
        public int cols() {
            return this._cols;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public long size() {
            return (long)this._rows * (long)this._cols;
        }

        @Override
        public double[] raw() {
            return this._data;
        }
    }

    static abstract class AbstractMatrix<T extends AbstractMatrix>
    extends Iced<T>
    implements Matrix {
        AbstractMatrix() {
        }

        @Override
        public final Frame toFrame(Key<Frame> key) {
            return Storage.toFrame(this, key);
        }
    }

    public static interface Matrix {
        public double get(int var1, int var2);

        public void set(int var1, int var2, double var3);

        public void add(int var1, int var2, double var3);

        public int cols();

        public int rows();

        public long size();

        public double[] raw();

        public Frame toFrame(Key<Frame> var1);
    }
}

