/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.coxph.CoxPH;
import water.H2O;
import water.LocalMR;
import water.MrFun;

class EfronDJKSetupFun
extends MrFun<EfronDJKSetupFun> {
    private final CoxPH.CoxPHTask _coxMR;
    double[] _riskTermT2;
    double[] _cumsumRiskTerm;

    public EfronDJKSetupFun() {
        this._coxMR = null;
    }

    private EfronDJKSetupFun(CoxPH.CoxPHTask coxMR) {
        this._coxMR = coxMR;
        this._riskTermT2 = new double[coxMR.sizeEvents.length];
        this._cumsumRiskTerm = new double[coxMR.sizeEvents.length];
    }

    @Override
    protected void map(int t2) {
        double sizeEvents_t = this._coxMR.sizeEvents[t2];
        long countEvents_t = this._coxMR.countEvents[t2];
        double sumRiskEvents_t = this._coxMR.sumRiskEvents[t2];
        double rcumsumRisk_t = this._coxMR.rcumsumRisk[t2];
        double avgSize = sizeEvents_t / (double)countEvents_t;
        for (long e2 = 0L; e2 < countEvents_t; ++e2) {
            double frac = (double)e2 / (double)countEvents_t;
            double term = rcumsumRisk_t - frac * sumRiskEvents_t;
            int n2 = t2;
            this._riskTermT2[n2] = this._riskTermT2[n2] + avgSize * frac / term;
            int n3 = t2;
            this._cumsumRiskTerm[n3] = this._cumsumRiskTerm[n3] + avgSize / term;
        }
    }

    private EfronDJKSetupFun postProcess() {
        int timeLen = this._coxMR._time.length;
        for (int t2 = 1; t2 < this._cumsumRiskTerm.length; ++t2) {
            int n2 = t2;
            this._cumsumRiskTerm[n2] = this._cumsumRiskTerm[n2] + (t2 % timeLen == 0 ? 0.0 : this._cumsumRiskTerm[t2 - 1]);
        }
        return this;
    }

    static EfronDJKSetupFun setupEfron(CoxPH.CoxPHTask coxMR) {
        EfronDJKSetupFun djkTermSetup = new EfronDJKSetupFun(coxMR);
        H2O.submitTask(new LocalMR((MrFun)djkTermSetup, coxMR.sizeEvents.length)).join();
        return djkTermSetup.postProcess();
    }
}

