/*
 * Decompiled with CFR 0.152.
 */
package hex.aggregator;

import hex.DataInfo;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ToEigenVec;
import hex.aggregator.Aggregator;
import hex.pca.PCAModel;
import hex.util.LinearAlgebraUtils;
import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.VecUtils;

public class AggregatorModel
extends Model<AggregatorModel, AggregatorParameters, AggregatorOutput>
implements Model.ExemplarMembers {
    public Aggregator.Exemplar[] _exemplars;
    public long[] _counts;
    public Key<Vec> _exemplar_assignment_vec_key;

    @Override
    public ToEigenVec getToEigenVec() {
        return LinearAlgebraUtils.toEigen;
    }

    public AggregatorModel(Key selfKey, AggregatorParameters parms, AggregatorOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    protected Model.PredictScoreResult predictScoreImpl(Frame orig, Frame adaptedFr, String destination_key, Job j2, boolean computeMetrics, CFuncRef customMetricFunc) {
        return new Model.PredictScoreResult(this, null, null, null);
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        Keyed.remove(this._exemplar_assignment_vec_key);
        return super.remove_impl(fs, cascade);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return null;
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        return preds;
    }

    public Frame createFrameOfExemplars(Frame orig, Key destination_key) {
        final long[] keep = new long[this._exemplars.length];
        for (int i2 = 0; i2 < keep.length; ++i2) {
            keep[i2] = this._exemplars[i2].gid;
        }
        Vec exAssignment = this._exemplar_assignment_vec_key.get();
        Vec booleanCol = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c2) {
                for (int i2 = 0; i2 < keep.length; ++i2) {
                    if (keep[i2] < c2.start() || keep[i2] >= c2.start() + (long)c2._len) continue;
                    c2.set((int)(keep[i2] - c2.start()), 1L);
                }
            }
        }.doAll((Frame)new Frame((Vec[])new Vec[]{exAssignment.makeZero()})))._fr.vec(0);
        Vec[] vecs = Arrays.copyOf(orig.vecs(), orig.vecs().length + 1);
        vecs[vecs.length - 1] = booleanCol;
        Frame ff = new Frame(orig.names(), orig.vecs());
        ff.add("predicate", booleanCol);
        Frame res = ((Frame.DeepSelect)new Frame.DeepSelect().doAll(orig.types(), ff)).outputFrame(destination_key, orig.names(), orig.domains());
        FrameUtils.shrinkDomainsToObservedSubset(res);
        booleanCol.remove();
        assert (res.numRows() == (long)this._exemplars.length);
        Vec cnts = res.anyVec().makeZero();
        Vec.Writer vw = cnts.open();
        for (int i3 = 0; i3 < this._counts.length; ++i3) {
            vw.set((long)i3, this._counts[i3]);
        }
        vw.close();
        res.add("counts", cnts);
        DKV.put(destination_key, res);
        return res;
    }

    public Frame createMappingOfExemplars(Key destinationKey) {
        final long[] keep = MemoryManager.malloc8(this._exemplars.length);
        for (int i2 = 0; i2 < keep.length; ++i2) {
            keep[i2] = this._exemplars[i2].gid;
        }
        Vec exAssignment = this._exemplar_assignment_vec_key.get();
        Arrays.sort(keep);
        Vec exemplarAssignment = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c1, NewChunk nc) {
                for (int i2 = 0; i2 < c1._len; ++i2) {
                    long gid = c1.at8(i2);
                    nc.addNum(ArrayUtils.find(keep, gid));
                }
            }
        }.doAll((byte)3, exAssignment)).outputFrame().vec(0);
        Frame mapping = new Frame(destinationKey, new String[]{"exemplar_assignment"}, new Vec[]{exemplarAssignment});
        long[] uniqueExemplars = ((VecUtils.CollectIntegerDomain)new VecUtils.CollectIntegerDomain().doAll(mapping.vecs())).domain();
        assert (uniqueExemplars.length == this._exemplars.length);
        assert (mapping.numRows() == exAssignment.length());
        for (long exmp : uniqueExemplars) {
            assert (exmp <= (long)this._exemplars.length);
        }
        DKV.put(mapping);
        return mapping;
    }

    @Override
    public Frame scoreExemplarMembers(Key<Frame> destination_key, final int exemplarIdx) {
        Vec booleanCol = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c2, NewChunk nc) {
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    nc.addNum(c2.at8(i2) == AggregatorModel.this._exemplars[exemplarIdx].gid ? 1L : 0L, 0);
                }
            }
        }.doAll((byte)3, new Frame(this._exemplar_assignment_vec_key.get()))).outputFrame().anyVec();
        Frame orig = ((AggregatorParameters)this._parms).train();
        Vec[] vecs = Arrays.copyOf(orig.vecs(), orig.vecs().length + 1);
        vecs[vecs.length - 1] = booleanCol;
        Frame ff = new Frame(orig.names(), orig.vecs());
        ff.add("predicate", booleanCol);
        Frame res = ((Frame.DeepSelect)new Frame.DeepSelect().doAll(orig.types(), ff)).outputFrame(destination_key, orig.names(), orig.domains());
        FrameUtils.shrinkDomainsToObservedSubset(res);
        DKV.put(res);
        assert (res.numRows() == this._counts[exemplarIdx]);
        booleanCol.remove();
        return res;
    }

    public void checkConsistency() {
        long sum = 0L;
        for (long l2 : this._counts) {
            sum += l2;
        }
        assert (sum == ((AggregatorParameters)this._parms).train().numRows());
        long[] exemplarGIDs = new long[this._counts.length];
        for (int i2 = 0; i2 < this._exemplars.length; ++i2) {
            exemplarGIDs[i2] = this._exemplars[i2].gid;
        }
        long[] counts = new long[this._exemplars.length];
        int i3 = 0;
        while ((long)i3 < ((AggregatorParameters)this._parms).train().numRows()) {
            long ass = this._exemplar_assignment_vec_key.get().at8(i3);
            for (int j2 = 0; j2 < exemplarGIDs.length; ++j2) {
                if (exemplarGIDs[j2] != ass) continue;
                int n2 = j2;
                counts[n2] = counts[n2] + 1L;
                break;
            }
            ++i3;
        }
        sum = 0L;
        for (long l3 : counts) {
            sum += l3;
        }
        assert (sum == ((AggregatorParameters)this._parms).train().numRows());
        for (i = 0; i < counts.length; ++i) {
            assert (counts[i] == this._counts[i]);
        }
    }

    public static class AggregatorOutput
    extends Model.Output {
        public Key<Frame> _output_frame;
        public Key<Frame> _mapping_frame;

        public AggregatorOutput(Aggregator b2) {
            super(b2);
        }

        @Override
        public int nfeatures() {
            return this._output_frame.get().numCols() - 1;
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.Clustering;
        }
    }

    public static class AggregatorParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NORMALIZE;
        public PCAModel.PCAParameters.Method _pca_method = PCAModel.PCAParameters.Method.Power;
        public int _k = 1;
        public int _target_num_exemplars = 5000;
        public double _rel_tol_num_exemplars = 0.5;
        public boolean _use_all_factor_levels = false;
        public boolean _save_mapping_frame = false;
        public int _num_iteration_without_new_exemplar = 500;

        @Override
        public String algoName() {
            return "Aggregator";
        }

        @Override
        public String fullName() {
            return "Aggregator";
        }

        @Override
        public String javaName() {
            return AggregatorModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return 5 + 2 * this.train().anyVec().nChunks() - 1;
        }
    }
}

