/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.LinkFunction;
import hex.LogExpUtil;
import hex.LogFunction;
import hex.Model;

class TweedieDistribution
extends Distribution {
    public TweedieDistribution(Model.Parameters params) {
        super(params, (LinkFunction)new LogFunction());
    }

    @Override
    public double deviance(double w2, double y2, double f2) {
        f2 = this.link(f2);
        assert (this._tweediePower > 1.0 && this._tweediePower < 2.0);
        return 2.0 * w2 * (Math.pow(y2, 2.0 - this._tweediePower) / ((1.0 - this._tweediePower) * (2.0 - this._tweediePower)) - y2 * LogExpUtil.exp(f2 * (1.0 - this._tweediePower)) / (1.0 - this._tweediePower) + LogExpUtil.exp(f2 * (2.0 - this._tweediePower)) / (2.0 - this._tweediePower));
    }

    @Override
    public double negHalfGradient(double y2, double f2) {
        assert (this._tweediePower > 1.0 && this._tweediePower < 2.0);
        return y2 * LogExpUtil.exp(f2 * (1.0 - this._tweediePower)) - LogExpUtil.exp(f2 * (2.0 - this._tweediePower));
    }

    @Override
    public double initFNum(double w2, double o2, double y2) {
        return w2 * y2 * LogExpUtil.exp(o2 * (1.0 - this._tweediePower));
    }

    @Override
    public double initFDenom(double w2, double o2, double y2) {
        return w2 * LogExpUtil.exp(o2 * (2.0 - this._tweediePower));
    }

    @Override
    public double gammaNum(double w2, double y2, double z2, double f2) {
        return w2 * y2 * LogExpUtil.exp(f2 * (1.0 - this._tweediePower));
    }

    @Override
    public double gammaDenom(double w2, double y2, double z2, double f2) {
        return w2 * LogExpUtil.exp(f2 * (2.0 - this._tweediePower));
    }
}

