/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.LinkFunction;
import hex.genmodel.utils.LinkFunctionType;
import org.apache.commons.math3.distribution.NormalDistribution;

class OprobitFunction
extends LinkFunction {
    NormalDistribution normalDistribution;

    public OprobitFunction() {
        this.linkFunctionType = LinkFunctionType.oprobit;
        this.normalDistribution = new NormalDistribution(0.0, 1.0);
    }

    @Override
    public double link(double f2) {
        return this.normalDistribution.inverseCumulativeProbability(f2);
    }

    @Override
    public double linkInv(double f2) {
        return this.normalDistribution.cumulativeProbability(f2);
    }

    @Override
    public String linkInvString(String f2) {
        return "new org.apache.commons.math3.distribution.NormalDistribution(0, 1).cumulativeProbability(" + f2 + ");";
    }
}

