/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ClusteringModel;
import hex.CustomMetric;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.genmodel.GenModel;
import java.util.ArrayList;
import java.util.Arrays;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class ModelMetricsClustering
extends ModelMetricsUnsupervised {
    public long[] _size = null;
    public double[] _withinss = null;
    public double _totss;
    public double _tot_withinss;
    public double _betweenss = Double.NaN;

    public double totss() {
        return this._totss;
    }

    public double tot_withinss() {
        return this._tot_withinss;
    }

    public double betweenss() {
        return this._betweenss;
    }

    public ModelMetricsClustering(Model model, Frame frame, CustomMetric customMetric) {
        super(model, frame, 0L, Double.NaN, customMetric);
        this._tot_withinss = Double.NaN;
        this._totss = Double.NaN;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" total sum of squares: " + (float)this._totss + "\n");
        sb.append(" total within sum of squares: " + (float)this._tot_withinss + "\n");
        sb.append(" total between sum of squares: " + (float)this._betweenss + "\n");
        if (this._size != null) {
            sb.append(" per cluster sizes: " + Arrays.toString(this._size) + "\n");
        }
        if (this._withinss != null) {
            sb.append(" per cluster within sum of squares: " + Arrays.toString(this._withinss) + "\n");
        }
        return sb.toString();
    }

    public TwoDimTable createCentroidStatsTable() {
        if (this._size == null || this._withinss == null) {
            return null;
        }
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Centroid");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Size");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Within Cluster Sum of Squares");
        colTypes.add("double");
        colFormat.add("%.5f");
        int K2 = this._size.length;
        assert (this._withinss.length == K2);
        TwoDimTable table = new TwoDimTable("Centroid Statistics", null, new String[K2], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        for (int k2 = 0; k2 < K2; ++k2) {
            int col = 0;
            table.set(k2, col++, k2 + 1);
            table.set(k2, col++, this._size[k2]);
            table.set(k2, col, this._withinss[k2]);
        }
        return table;
    }

    public static class MetricBuilderClustering
    extends ModelMetricsUnsupervised.MetricBuilderUnsupervised<MetricBuilderClustering> {
        public long[] _size;
        public double[] _within_sumsqe;
        private double[] _colSum;
        private double[] _colSumSq;

        public MetricBuilderClustering(int ncol, int nclust) {
            this._work = new double[ncol];
            this._size = new long[nclust];
            this._within_sumsqe = new double[nclust];
            Arrays.fill(this._size, 0L);
            Arrays.fill(this._within_sumsqe, 0.0);
            this._colSum = new double[ncol];
            this._colSumSq = new double[ncol];
            Arrays.fill(this._colSum, 0.0);
            Arrays.fill(this._colSumSq, 0.0);
        }

        @Override
        public double[] perRow(double[] preds, float[] dataRow, Model m4) {
            assert (m4 instanceof ClusteringModel);
            assert (!Double.isNaN(preds[0]));
            ClusteringModel clm = (ClusteringModel)m4;
            boolean standardize = ((ClusteringModel.ClusteringOutput)clm._output)._centers_std_raw != null;
            double[][] centers = standardize ? ((ClusteringModel.ClusteringOutput)clm._output)._centers_std_raw : ((ClusteringModel.ClusteringOutput)clm._output)._centers_raw;
            int clus = (int)preds[0];
            double[] colSum = new double[this._colSum.length];
            double[] colSumSq = new double[this._colSumSq.length];
            double sqr = GenModel.KMeans_distance(centers[clus], dataRow, ((ClusteringModel.ClusteringOutput)clm._output)._mode, colSum, colSumSq);
            ArrayUtils.add(this._colSum, colSum);
            ArrayUtils.add(this._colSumSq, colSumSq);
            ++this._count;
            int n2 = clus;
            this._size[n2] = this._size[n2] + 1L;
            this._sumsqe += sqr;
            int n3 = clus;
            this._within_sumsqe[n3] = this._within_sumsqe[n3] + sqr;
            if (Double.isNaN(this._sumsqe)) {
                throw new H2OIllegalArgumentException("Sum of Squares is invalid (Double.NaN) - Check for missing values in the dataset.");
            }
            return preds;
        }

        @Override
        public void reduce(MetricBuilderClustering mm4) {
            super.reduce(mm4);
            ArrayUtils.add(this._size, mm4._size);
            ArrayUtils.add(this._within_sumsqe, mm4._within_sumsqe);
            ArrayUtils.add(this._colSum, mm4._colSum);
            ArrayUtils.add(this._colSumSq, mm4._colSumSq);
        }

        @Override
        public void reduceForCV(MetricBuilderClustering mm4) {
            super.reduce(mm4);
            ArrayUtils.add(this._colSum, mm4._colSum);
            ArrayUtils.add(this._colSumSq, mm4._colSumSq);
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m4, Frame f2) {
            assert (m4 instanceof ClusteringModel);
            ModelMetricsClustering mm4 = new ModelMetricsClustering(m4, f2, this._customMetric);
            this.setOverallStatToModelMetrics((ClusteringModel)m4, f2.numRows(), mm4);
            if (this._size != null && this._within_sumsqe != null) {
                this.setCentroidsStatToModelMetrics(mm4);
            }
            return m4.addMetrics(mm4);
        }

        private void setOverallStatToModelMetrics(ClusteringModel clm, long numRows, ModelMetricsClustering mm4) {
            mm4._tot_withinss = this._sumsqe;
            if (clm._parms._weights_column != null) {
                numRows = this._count;
            }
            if (((ClusteringModel.ClusteringParameters)clm._parms)._k == 1) {
                mm4._totss = mm4._tot_withinss;
            } else {
                mm4._totss = 0.0;
                for (int i2 = 0; i2 < this._colSum.length; ++i2) {
                    if (((ClusteringModel.ClusteringOutput)clm._output)._mode[i2] == -1) {
                        mm4._totss += this._colSumSq[i2] - this._colSum[i2] * this._colSum[i2] / (double)numRows;
                        continue;
                    }
                    mm4._totss += this._colSum[i2];
                }
            }
            mm4._betweenss = mm4._totss - mm4._tot_withinss;
        }

        private void setCentroidsStatToModelMetrics(ModelMetricsClustering mm4) {
            mm4._size = this._size;
            mm4._withinss = new double[this._size.length];
            for (int i2 = 0; i2 < mm4._withinss.length; ++i2) {
                mm4._withinss[i2] = this._within_sumsqe[i2];
            }
        }
    }
}

