/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.pipe.db;

import com.ziclix.python.sql.PyConnection;
import com.ziclix.python.sql.pipe.Sink;
import com.ziclix.python.sql.pipe.db.BaseDB;
import com.ziclix.python.sql.zxJDBC;
import java.util.HashSet;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class DBSink
extends BaseDB
implements Sink {
    protected PyObject sql = Py.None;
    protected Set exclude;
    protected PyList rows = new PyList();
    protected int batchsize;
    protected PyObject bindings;
    protected PyDictionary indexedBindings;

    public DBSink(PyConnection connection, Class dataHandler, String tableName, PyObject exclude, PyObject bindings, int batchsize) {
        super(connection, dataHandler, tableName);
        this.bindings = bindings;
        this.batchsize = batchsize;
        this.exclude = new HashSet();
        this.indexedBindings = new PyDictionary();
        if (exclude != Py.None) {
            for (int i2 = 0; i2 < exclude.__len__(); ++i2) {
                PyString lowered = Py.newString(((PyString)exclude.__getitem__(i2)).lower());
                this.exclude.add(lowered);
            }
        }
    }

    protected boolean excluded(PyObject key) {
        PyString lowered = Py.newString(((PyString)key).lower());
        return this.exclude.contains(lowered);
    }

    protected void createSql(PyObject row) {
        int i2;
        if (row == Py.None || row.__len__() == 0) {
            throw zxJDBC.makeException(zxJDBC.getString("noColInfo"));
        }
        int index = 0;
        int len = row.__len__();
        PyObject entry = Py.None;
        PyObject col = Py.None;
        PyObject pyIndex = Py.None;
        StringBuffer sb = new StringBuffer("insert into ").append(this.tableName).append(" (");
        for (i2 = 0; i2 < len - 1; ++i2) {
            entry = row.__getitem__(i2);
            col = entry.__getitem__(0);
            if (this.excluded(col)) continue;
            sb.append(col).append(",");
            pyIndex = Py.newInteger(index++);
            try {
                this.indexedBindings.__setitem__(pyIndex, this.bindings.__getitem__(col));
                continue;
            }
            catch (Exception e2) {
                this.indexedBindings.__setitem__(pyIndex, entry.__getitem__(1));
            }
        }
        entry = row.__getitem__(len - 1);
        col = entry.__getitem__(0);
        if (!this.excluded(col)) {
            sb.append(col);
            pyIndex = Py.newInteger(index++);
            try {
                this.indexedBindings.__setitem__(pyIndex, this.bindings.__getitem__(col));
            }
            catch (Exception e3) {
                this.indexedBindings.__setitem__(pyIndex, entry.__getitem__(1));
            }
        }
        sb.append(") values (");
        for (i2 = 1; i2 < len; ++i2) {
            sb.append("?,");
        }
        sb.append("?)");
        if (index == 0) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("excludedAllCols"));
        }
        this.sql = Py.newString(sb.toString());
    }

    @Override
    public void row(PyObject row) {
        if (this.sql != Py.None) {
            if (this.batchsize <= 0) {
                this.cursor.execute(this.sql, row, this.indexedBindings, Py.None);
                this.connection.commit();
            } else {
                this.rows.append(row);
                int len = this.rows.__len__();
                if (len % this.batchsize == 0) {
                    this.cursor.execute(this.sql, this.rows, this.indexedBindings, Py.None);
                    this.connection.commit();
                    this.rows = new PyList();
                }
            }
        } else {
            this.createSql(row);
        }
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        try {
            int len = this.rows.__len__();
            if (len > 0) {
                this.cursor.execute(this.sql, this.rows, this.indexedBindings, Py.None);
                this.connection.commit();
            }
        }
        finally {
            this.cursor.close();
        }
    }
}

