/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.pipe.csv;

import com.ziclix.python.sql.pipe.Sink;
import com.ziclix.python.sql.pipe.csv.CSVString;
import java.io.PrintWriter;
import org.python.core.Py;
import org.python.core.PyObject;

public class CSVSink
implements Sink {
    protected boolean header = false;
    protected String delimiter;
    protected PrintWriter writer;
    protected PyObject converters;

    public CSVSink(PrintWriter writer) {
        this(writer, Py.None);
    }

    public CSVSink(PrintWriter writer, PyObject converters) {
        this.writer = writer;
        this.converters = converters;
        this.delimiter = ",";
    }

    @Override
    public void row(PyObject row) {
        String[] values = new String[row.__len__()];
        if (this.header) {
            for (int i2 = 0; i2 < row.__len__(); ++i2) {
                values[i2] = this.convert(Py.newInteger(i2), row.__getitem__(i2));
            }
        } else {
            for (int i3 = 0; i3 < row.__len__(); ++i3) {
                values[i3] = row.__getitem__(i3).__getitem__(0).toString();
            }
            this.header = true;
        }
        this.println(values);
    }

    protected String convert(PyObject index, PyObject object) {
        PyObject converter;
        if (this.converters != Py.None && (converter = this.converters.__finditem__(index)) != Py.None) {
            object = converter.__call__(object);
        }
        if (object == Py.None || object == null) {
            return "";
        }
        return CSVString.toCSV(object.toString());
    }

    protected void println(String[] row) {
        for (int i2 = 0; i2 < row.length - 1; ++i2) {
            this.writer.print(row[i2]);
            this.writer.print(this.delimiter);
        }
        this.writer.println(row[row.length - 1]);
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }
}

