/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.shaded.json.JSONObject;
import com.nimbusds.jose.shaded.json.parser.JSONParser;
import com.nimbusds.jose.shaded.json.parser.ParseException;
import com.nimbusds.jose.util.Base64URL;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONObjectUtils {
    public static Map<String, Object> parse(String s2) throws java.text.ParseException {
        return JSONObjectUtils.parse(s2, -1);
    }

    public static Map<String, Object> parse(String s2, int sizeLimit) throws java.text.ParseException {
        Object o2;
        if (sizeLimit >= 0 && s2.length() > sizeLimit) {
            throw new java.text.ParseException("The parsed string is longer than the max accepted size of " + sizeLimit + " characters", 0);
        }
        try {
            o2 = new JSONParser(640).parse(s2);
        }
        catch (ParseException e2) {
            throw new java.text.ParseException("Invalid JSON: " + e2.getMessage(), 0);
        }
        catch (Exception e3) {
            throw new java.text.ParseException("Unexpected exception: " + e3.getMessage(), 0);
        }
        catch (StackOverflowError e4) {
            throw new java.text.ParseException("Excessive JSON object and / or array nesting", 0);
        }
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new java.text.ParseException("JSON entity is not an object", 0);
    }

    @Deprecated
    public static Map<String, Object> parseJSONObject(String s2) throws java.text.ParseException {
        return JSONObjectUtils.parse(s2);
    }

    private static <T> T getGeneric(Map<String, Object> o2, String key, Class<T> clazz) throws java.text.ParseException {
        if (o2.get(key) == null) {
            return null;
        }
        Object value = o2.get(key);
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new java.text.ParseException("Unexpected type of JSON object member with key \"" + key + "\"", 0);
        }
        return (T)value;
    }

    public static boolean getBoolean(Map<String, Object> o2, String key) throws java.text.ParseException {
        Boolean value = JSONObjectUtils.getGeneric(o2, key, Boolean.class);
        if (value == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value;
    }

    public static int getInt(Map<String, Object> o2, String key) throws java.text.ParseException {
        Number value = JSONObjectUtils.getGeneric(o2, key, Number.class);
        if (value == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.intValue();
    }

    public static long getLong(Map<String, Object> o2, String key) throws java.text.ParseException {
        Number value = JSONObjectUtils.getGeneric(o2, key, Number.class);
        if (value == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.longValue();
    }

    public static float getFloat(Map<String, Object> o2, String key) throws java.text.ParseException {
        Number value = JSONObjectUtils.getGeneric(o2, key, Number.class);
        if (value == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.floatValue();
    }

    public static double getDouble(Map<String, Object> o2, String key) throws java.text.ParseException {
        Number value = JSONObjectUtils.getGeneric(o2, key, Number.class);
        if (value == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is missing or null", 0);
        }
        return value.doubleValue();
    }

    public static String getString(Map<String, Object> o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, String.class);
    }

    public static URI getURI(Map<String, Object> o2, String key) throws java.text.ParseException {
        String value = JSONObjectUtils.getString(o2, key);
        if (value == null) {
            return null;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e2) {
            throw new java.text.ParseException(e2.getMessage(), 0);
        }
    }

    public static List<Object> getJSONArray(Map<String, Object> o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, List.class);
    }

    public static String[] getStringArray(Map<String, Object> o2, String key) throws java.text.ParseException {
        List<Object> jsonArray = JSONObjectUtils.getJSONArray(o2, key);
        if (jsonArray == null) {
            return null;
        }
        try {
            return jsonArray.toArray(new String[0]);
        }
        catch (ArrayStoreException e2) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is not an array of strings", 0);
        }
    }

    public static List<String> getStringList(Map<String, Object> o2, String key) throws java.text.ParseException {
        String[] array = JSONObjectUtils.getStringArray(o2, key);
        if (array == null) {
            return null;
        }
        return Arrays.asList(array);
    }

    public static Map<String, Object> getJSONObject(Map<String, Object> o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, JSONObject.class);
    }

    public static Base64URL getBase64URL(Map<String, Object> o2, String key) throws java.text.ParseException {
        String value = JSONObjectUtils.getString(o2, key);
        if (value == null) {
            return null;
        }
        return new Base64URL(value);
    }

    public static String toJSONString(Map<String, ?> o2) {
        return JSONObject.toJSONString(o2);
    }

    public static Map<String, Object> newJSONObject() {
        return new HashMap<String, Object>();
    }

    private JSONObjectUtils() {
    }
}

